/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpilhausWorldOceanInASquare
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Spilhaus World Ocean in a Square";
    public static final int PROPERTIES = 4096;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double SQRT2_TIMES_K = 2.62205755429212;
    private static final double MAX_X_OVER_RS = 1.854074677301372;
    private static final double MAX_Y_OVER_RS = 1.854074677301372;
    private static final double CENTER_LON = 66.94970198;
    private static final double CENTER_LAT = -49.56371678;
    private static final double AZIMUTH = 40.17823482;
    private LonLatRotator rotMatrices_ = new LonLatRotator(66.94970198, -49.56371678, 40.17823482);
    private double kRS_;
    private double sqrt2timesKRS_;

    public SpilhausWorldOceanInASquare(int width, int height) {
        this(width, height, 0, 0);
    }

    public SpilhausWorldOceanInASquare(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 1.854074677301372, 1.854074677301372);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.kRS_ = 1.854074677301372 * this.rS_;
        this.sqrt2timesKRS_ = 2.62205755429212 * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double tt;
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double lonP = llP[0];
        double latP = llP[1];
        if (latP > 89.99999) {
            return new Point2D.Double((double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
        }
        if (latP < -89.99999) {
            return new Point2D.Double((double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
        }
        double lambdaRad = Math.toRadians(this.lonToLambda(lonP));
        double absLambdaRad = Math.abs(lambdaRad);
        double sinHalfLambda = Math.sin(0.5 * absLambdaRad);
        double phiRad = Math.toRadians(latP);
        double absPhiRad = Math.abs(phiRad);
        double sinPhiP = Math.tan(0.5 * absPhiRad);
        double cosPhiP = Math.sqrt(1.0 - sinPhiP * sinPhiP);
        double cosA = cosPhiP * sinHalfLambda;
        double cosB = sinPhiP;
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        if (sinPhiP + cosA < 0.0) {
            mmm = -mmm;
        }
        if (sinPhiP - cosA < 0.0) {
            nnn = -nnn;
        }
        double x = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double y = Elliptic.ellipticF(nnn, 0.5000000000000001);
        if (lambdaRad < 0.0) {
            tt = x;
            x = y;
            y = tt;
        }
        if (phiRad < 0.0) {
            tt = x;
            x = -y;
            y = -tt;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > this.kRS_ || absY > this.kRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double[] absLL = this.transformAbsXYrs2LL(xOverRS, yOverRS);
        if (absLL == null || Double.isNaN(absLL[0]) || Double.isNaN(absLL[1])) {
            return null;
        }
        double lambda = absLL[0];
        double phi = absLL[1];
        if (x < 0.0) {
            // empty if block
        }
        if (y < 0.0) {
            // empty if block
        }
        double[] ll = this.rotMatrices_.inverse(lambda, phi);
        return new PointLL(this.lambdaC_ + ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SpilhausWorldOceanInASquare spilhausWorldOceanInASquare = this;
        synchronized (spilhausWorldOceanInASquare) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double[] llRot;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = -this.dxMax_; ix < this.dxMax_ && (llRot = this.transformAbsXYrs2LL(xOverRS = (x = (double)ix + 0.5) * this.invRS_, yOverRS)) != null; ++ix) {
                    double[] ll = this.rotMatrices_.inverse(llRot[0], llRot[1]);
                    this.setInvPoint(ix, iy, ll[0], ll[1]);
                }
            }
        }
    }

    @Override
    protected void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    private double[] transformAbsXYrs2LL(double x, double y) {
        double cosB;
        double[] jacobiM = Elliptic.jacobiSnCnDn(x, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(y, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = y > x ? Math.acos(cosAminusB) : -Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double sinPhiP = cosB = Math.cos(b);
        double phiPRad = Math.asin(sinPhiP);
        double cosPhiP = Math.cos(phiPRad);
        double phiRad = 2.0 * Math.atan(sinPhiP);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double sinHalfLambda = cosA / cosPhiP;
        double lambdaRad = 2.0 * Math.asin(sinHalfLambda);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo((double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
        path.lineTo((double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ + this.kRS_);
        path.lineTo((double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
        path.lineTo((double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ - this.kRS_);
        path.closePath();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        g2x.draw(path);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Bezier bcurve;
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        Point2D.Double lastdot = new Point2D.Double(0.0, 0.0);
        double lat = -maxLat;
        while (lat < maxLat) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                this.drawCurve(g2d, ptlist);
            } else {
                if (ptlist.size() != 0 && dot.distance(lastdot) > 50.0) {
                    this.drawCurve(g2d, ptlist);
                }
                ptlist.add(dot);
                lastdot.setLocation(dot.x, dot.y);
            }
            double absLat = Math.abs(lat);
            if (absLat >= maxLat - 1.0) {
                lat += 0.1;
                continue;
            }
            lat += 0.3;
        }
        dot = this.transformLL2XY(lon, maxLat);
        if (dot != null) {
            ptlist.add(new Point2D.Double(dot.x, dot.y));
        }
        if (ptlist.size() > 1 && (bcurve = new Bezier(false, ptlist)) != null) {
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Bezier bcurve;
        Point2D.Double dot;
        double lon;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(800);
        Point2D.Double lastdot = new Point2D.Double(0.0, 0.0);
        for (lon = -180.0; lon < 180.0; lon += 0.3) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                this.drawCurve(g2d, ptlist);
                continue;
            }
            if (ptlist.size() != 0 && dot.distance(lastdot) > 50.0) {
                this.drawCurve(g2d, ptlist);
            }
            ptlist.add(dot);
            lastdot.setLocation(dot.x, dot.y);
        }
        dot = this.transformLL2XY(lon, lat);
        if (dot != null) {
            ptlist.add(new Point2D.Double(dot.x, dot.y));
        }
        if (ptlist.size() > 1 && (bcurve = new Bezier(false, ptlist)) != null) {
            bcurve.draw(g2d);
        }
    }

    private void drawCurve(Graphics2D g2d, ArrayList<Point2D.Double> ptlist) {
        Bezier bcurve;
        if (ptlist.size() > 1 && (bcurve = new Bezier(false, ptlist)) != null) {
            bcurve.draw(g2d);
        }
        ptlist.clear();
    }
}

