/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataLonLatZonal
extends PanData2D
implements PanDataLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_3 = new PrintfFormat("%.3f");
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private double[] gridLats_;

    public PanDataLonLatZonal(PanPlotMeta pmeta, NcArray nca, Dimension size) {
        this(pmeta, nca, size.width, size.height);
    }

    public PanDataLonLatZonal(PanPlotMeta pmeta, NcArray nca, int w, int h) {
        super(pmeta, nca, w, h);
        this.setAxisBounds(-90.0, 90.0);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayLonLat)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayLonLat");
        }
        return true;
    }

    @Override
    public String getXAxisName() {
        return "Longitude";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_east";
    }

    @Override
    public String getYAxisName() {
        return "Latitude";
    }

    @Override
    public String getYAxisUnits() {
        return "degree_north";
    }

    @Override
    public boolean isGlobal() {
        return !(Math.abs(this.tBound_ - this.bBound_) < 180.0);
    }

    @Override
    public double getGlobalMean() {
        if (!this.isGlobal()) {
            return Double.NaN;
        }
        if (this.comboType_ == PanCombinationType.COMPARE) {
            return Double.NaN;
        }
        double yDegPerPxl = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        double[] rowLats = new double[this.gridHeight_];
        for (int row = 0; row < this.gridHeight_; ++row) {
            rowLats[row] = this.tBound_ + ((double)row + 0.5) * yDegPerPxl;
        }
        double tweight = 0.0;
        double result = 0.0;
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rweight = Math.cos(Math.toRadians(rowLats[row]));
            for (int col = 0; col < this.gridWidth_; ++col) {
                double val = this.valueAt(col, row);
                if (Double.isNaN(val) || Double.isInfinite(val)) continue;
                result += val * rweight;
                tweight += rweight;
            }
        }
        if (tweight == 0.0) {
            return Double.NaN;
        }
        return result /= tweight;
    }

    public double getRowAverageAtAxisPt(int gridNum, double latitude) {
        int minindex = -1;
        double mindiff = 99999.0;
        for (int jj = 0; jj < this.gridHeight_; ++jj) {
            double diff = Math.abs(this.gridLats_[jj] - latitude);
            if (!(diff < mindiff)) continue;
            mindiff = diff;
            minindex = jj;
        }
        if (minindex >= 0) {
            return this.getRowAverageAt(gridNum, minindex);
        }
        return Double.NaN;
    }

    public double getRowAverageAt(int gridNum, int row) {
        if (gridNum == 1 && this.comboType_ != PanCombinationType.COMPARE) {
            return Double.NaN;
        }
        double result = 0.0;
        int count = 0;
        for (int col = 0; col < this.gridWidth_; ++col) {
            double val;
            double d = val = gridNum == 0 ? this.valueAt(col, row) : this.secondValueAt(col, row);
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            result += val;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return result;
        }
        return result /= (double)count;
    }

    public void describeDataAtAxisPt(StringBuilder sb, double latitude) {
        if (this.needsGridding_) {
            this.regrid();
        }
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
        double value = this.getRowAverageAtAxisPt(0, latitude);
        if (this.comboType_ == PanCombinationType.COMPARE) {
            sb.append("Line Value 1: ");
        } else {
            sb.append("Line Value: ");
        }
        if (!Double.isNaN(value)) {
            sb.append(PFORMAT_10G.sprintfx(value)).append('\n');
        } else {
            sb.append("null or NaN\n");
        }
        if (this.comboType_ == PanCombinationType.COMPARE) {
            value = this.getRowAverageAtAxisPt(1, latitude);
            sb.append("Line Value 2: ");
            if (!Double.isNaN(value)) {
                sb.append(PFORMAT_10G.sprintfx(value)).append('\n');
            } else {
                sb.append("null or NaN\n");
            }
        }
    }

    @Override
    public double getMinValue() {
        int istrokes = this.comboType_ == PanCombinationType.COMPARE ? 2 : 1;
        double result = Double.MAX_VALUE;
        for (int i = 0; i < istrokes; ++i) {
            for (int j = 0; j < this.gridHeight_; ++j) {
                double rowAve = this.getRowAverageAt(i, j);
                if (Double.isNaN(rowAve)) continue;
                result = Math.min(result, rowAve);
            }
        }
        return result;
    }

    @Override
    public double getMaxValue() {
        int istrokes = this.comboType_ == PanCombinationType.COMPARE ? 2 : 1;
        double result = Double.MIN_VALUE;
        for (int i = 0; i < istrokes; ++i) {
            for (int j = 0; j < this.gridHeight_; ++j) {
                double rowAve = this.getRowAverageAt(i, j);
                if (Double.isNaN(rowAve)) continue;
                result = Math.max(result, rowAve);
            }
        }
        return result;
    }

    public boolean setAxisBounds(double bound1, double bound2) {
        this.lBound_ = -180.0;
        this.rBound_ = 180.0;
        this.tBound_ = Math.max(bound1, bound2);
        this.bBound_ = Math.min(bound1, bound2);
        this.setBoundsChanged();
        return true;
    }

    public double getLatitude(int jj) {
        return this.gridLats_[jj];
    }

    @Override
    protected void prepareGrid() {
        this.prepareLatitudes();
    }

    private void prepareLatitudes() {
        this.gridLats_ = new double[this.gridHeight_];
        double degPerPxl = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        for (int jj = 0; jj < this.gridHeight_; ++jj) {
            this.gridLats_[jj] = this.tBound_ + ((double)jj + 0.5) * degPerPxl;
        }
    }

    @Override
    protected void prepareXGrid() {
    }

    @Override
    protected void prepareYGrid() {
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        if (this.gridWidth_ < 1 || this.gridHeight_ < 1) {
            return null;
        }
        double xPerPxl = (this.lBound_ - this.rBound_) / (double)this.gridWidth_;
        double yPerPxl = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        double xx = this.lBound_ + x * xPerPxl;
        double yy = this.tBound_ + y * yPerPxl;
        return new Point2D.Double(xx, yy);
    }

    public double valueAt(PointLL ll) {
        double lon;
        double lat = ll.getLat();
        for (lon = ll.getLon(); lon < this.lBound_; lon += 360.0) {
        }
        while (lon > this.rBound_) {
            lon -= 360.0;
        }
        int gridX = (int)((double)this.gridWidth_ * (lon - this.lBound_) / (this.rBound_ - this.lBound_));
        int gridY = (int)((double)this.gridHeight_ * (lat - this.tBound_) / (this.bBound_ - this.tBound_));
        return this.valueAt(gridX, gridY);
    }

    @Override
    public void describeDataAt(StringBuilder sb, int ii, int jj) {
        throw new UnsupportedOperationException("Use describeData(StringBuilder,PointLL) instead.");
    }

    public void describeDataAt(StringBuilder sb, PointLL ll) {
        double lon;
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
        double lat = ll.getLat();
        for (lon = ll.getLon(); lon < this.lBound_; lon += 360.0) {
        }
        while (lon > this.rBound_) {
            lon -= 360.0;
        }
        sb.append("Lon: ").append(PFORMAT_3.sprintfx(lon)).append("\u00b0E").append('\n').append("Lat: ").append(PFORMAT_3.sprintfx(lat)).append("\u00b0N").append('\n');
        sb.append("Displayed value: ");
        double dd = this.valueAt(ll);
        if (Double.isNaN(dd)) {
            sb.append("NaN");
        } else {
            sb.append(PFORMAT_10G.sprintfx(dd));
        }
        sb.append("\n \n");
        for (int i = 0; i < 2; ++i) {
            if (this.ncArrays_[i] == null || i == 0 && this.comboType_ == PanCombinationType.A2_ONLY || i == 1 && this.comboType_ == PanCombinationType.A1_ONLY) continue;
            sb.append("Array ").append(i + 1).append(": ");
            NcArray nca = this.ncArrays_[i];
            int[] xy = ((NcArrayLonLat)((Object)nca)).getEnclosingCell(lon, lat);
            if (xy == null) {
                sb.append("Outside array bounds\n");
                continue;
            }
            nca.describeCell(sb, this.scaleFormatter_, xy);
            sb.append('\n');
        }
    }
}

