/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanPlotSizeComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLayoutPrefsPanel
extends PanAbstractPrefsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotSizeComboBox sizeCombo_;
    private PanIntSpinner bWeightSpinner_;
    private ColorComboBox bkgdCombo_;
    private boolean refreshing_;

    public PanLayoutPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Layout"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a plot, set\u2026");
        this.sizeCombo_ = new PanPlotSizeComboBox();
        PanGuiUtils.setSizeRegular(this.sizeCombo_);
        this.bkgdCombo_ = new ColorComboBox(PaletteType.BLACK_WHITE);
        this.bWeightSpinner_ = PanIntSpinner.weight(null, prefs_.getInt("plot:border.weight"), 25, 300);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 4, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 3, 1));
        this.add((Component)new JLabel("Plot Size:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)this.sizeCombo_, new FGConstraint(1, row));
        this.add((Component)new JLabel("Border:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(new JLabel("Weight:\u2009"), this.bWeightSpinner_, new JLabel("%")), new FGConstraint(1, row));
        this.add((Component)new JLabel("Background:\u2009"), new FGConstraint(0, ++row, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.bkgdCombo_), new FGConstraint(1, row));
    }

    private void attachListeners() {
        this.sizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.setInt("plot:size.factor", this.sizeCombo_.getSelectedSizeFactor());
        });
        this.bWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:border.weight", this.bWeightSpinner_.getIntValue());
        });
        this.bkgdCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:color.background", this.bkgdCombo_.getSelectedColor());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.sizeCombo_.setSelectedSize(prefs_.getInt("plot:size.factor"));
        this.bWeightSpinner_.setValue(prefs_.getInt("plot:border.weight"));
        this.bkgdCombo_.setSelectedColor(prefs_.getColor("plot:color.background"));
        this.refreshing_ = false;
    }
}

