/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.exc.NcMismatchException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatReduced2D;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.math.GeometryUtils;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatReduced2D
extends NcArray
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double RAD_PER_DEG = Math.PI / 180;
    private CoordinateAxis lonVarDS_;
    private CoordinateAxis latVarDS_;
    protected NcAxis xAxis_;
    protected NcAxis yAxis_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private boolean hasBounds_;
    private VariableDS lonBoundsVar_;
    private VariableDS latBoundsVar_;
    private Array lonBoundsArray_;
    private Array latBoundsArray_;
    private Index lonBoundsIndex_;
    private Index latBoundsIndex_;
    private int bdsCornerDimIndex_ = -1;
    private int numReducePts_ = -1;
    private int numXs_;
    private int numYs_;
    private int reduceDimIndex_ = -1;
    private int[][] reversedGrid_;
    private boolean rankMismatch_;

    public NcArrayLonLatReduced2D(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private void initMe() {
        Dimension dim22;
        Dimension dim21;
        CoordinateSystem[] csarrray = this.getCoordinateSystems();
        if (csarrray.length == 0) {
            throw new NcException("Coordinate system not found");
        }
        CoordinateSystem cs = csarrray[0];
        if (cs == null) {
            throw new NcException("Coordinate system not found");
        }
        this.lonVarDS_ = cs.getLonAxis();
        this.latVarDS_ = cs.getLatAxis();
        if (this.lonVarDS_ == null || this.latVarDS_ == null) {
            throw new NcException("Lon or lat variable not found");
        }
        if (!(this.lonVarDS_ instanceof CoordinateAxis2D)) {
            throw new NcMismatchException("Longitude is not CoordinateAxis2D");
        }
        if (!(this.latVarDS_ instanceof CoordinateAxis2D)) {
            throw new NcMismatchException("Latitude is not CoordinateAxis2D");
        }
        int[] lonshape = this.lonVarDS_.getShape();
        if (lonshape.length != 2) {
            throw new NcMismatchException("Bad longitude variable shape");
        }
        int[] latshape = this.latVarDS_.getShape();
        if (latshape.length != 2) {
            throw new NcMismatchException("Bad latitude variable shape");
        }
        Dimension dim11 = this.lonVarDS_.getDimension(0);
        if (!dim11.equals(dim21 = this.latVarDS_.getDimension(0))) {
            throw new NcMismatchException("Dimension mismatch");
        }
        Dimension dim12 = this.lonVarDS_.getDimension(1);
        if (!dim12.equals(dim22 = this.latVarDS_.getDimension(1))) {
            throw new NcMismatchException("Dimension mismatch");
        }
        VariableDS dimVar = null;
        for (int i = 0; i < this.rank_; ++i) {
            String compress;
            String[] tokens;
            Attribute compressA;
            Dimension d = this.getDimension(i);
            dimVar = this.dataset_.getCoordinateVariable(d);
            if (dimVar == null || (compressA = dimVar.findAttribute("compress")) == null || (tokens = (compress = compressA.getStringValue()).split(" ")).length != 2) continue;
            Dimension dd1 = this.dataset_.getNjDimension(tokens[0]);
            Dimension dd2 = this.dataset_.getNjDimension(tokens[1]);
            if (!dim11.equals(dd1) || !dim12.equals(dd2)) continue;
            this.reduceDimIndex_ = i;
            break;
        }
        if (dimVar == null) {
            throw new NcException("Could not find reduction dim var");
        }
        if (this.reduceDimIndex_ < 0) {
            throw new NcException("Could not find reduction dimensions");
        }
        try {
            this.lonArray_ = this.lonVarDS_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
            int vrank = this.lonVarDS_.getRank();
            int arank = this.lonArray_.getRank();
            int irank = this.lonIndex_.getRank();
            if (vrank != arank && arank == vrank + 1 && arank == irank) {
                this.rankMismatch_ = true;
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read longitude coordinates array: {}", (Object)exc.getMessage());
            throw new NcException("Could not read longitude coordinates array.", exc);
        }
        try {
            this.latArray_ = this.latVarDS_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read latitude coordinates array: {}", (Object)exc.getMessage());
            throw new NcException("Could not read latitude coordinates array.", exc);
        }
        int[] shape = this.lonArray_.getShape();
        this.numXs_ = shape[0];
        this.numYs_ = shape[1];
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, dim11.getShortName(), this.numXs_);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, dim12.getShortName(), this.numYs_);
        this.reversedGrid_ = new int[this.numXs_][this.numYs_];
        for (int jj = 0; jj < this.numYs_; ++jj) {
            for (int ii = 0; ii < this.numXs_; ++ii) {
                this.reversedGrid_[ii][jj] = -1;
            }
        }
        try {
            Array dimArray = dimVar.read();
            this.numReducePts_ = (int)dimArray.getSize();
            int i = 0;
            while (i < this.numReducePts_) {
                int index = dimArray.getInt(i);
                int x = index / this.numYs_;
                int y = index - x * this.numYs_;
                this.reversedGrid_[x][y] = i++;
            }
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Could not prepare expansion array");
        }
        String lonBoundsName_ = null;
        String latBoundsName_ = null;
        try {
            lonBoundsName_ = this.lonVarDS_.findAttribute("bounds").getStringValue();
        }
        catch (Exception index) {
            // empty catch block
        }
        try {
            latBoundsName_ = this.latVarDS_.findAttribute("bounds").getStringValue();
        }
        catch (Exception index) {
            // empty catch block
        }
        if (lonBoundsName_ == null || latBoundsName_ == null) {
            LOGGER.warn("Bounds name is null");
            return;
        }
        NcDataset dataset = this.getDataset();
        this.lonBoundsVar_ = dataset.getVariableDS(lonBoundsName_);
        this.latBoundsVar_ = dataset.getVariableDS(latBoundsName_);
        if (this.lonBoundsVar_ == null || this.latBoundsVar_ == null) {
            LOGGER.warn("Auxiliary coordinates have bounds names but no bounds vars");
            return;
        }
        if (this.lonBoundsVar_.getRank() != 3) {
            LOGGER.warn("Lon bounds var does not have rank 3");
            return;
        }
        if (this.latBoundsVar_.getRank() != 3) {
            LOGGER.warn("Lat bounds var does not have rank 3");
            return;
        }
        int[] bShape = this.lonBoundsVar_.getShape();
        if (bShape[0] == 4) {
            this.bdsCornerDimIndex_ = 0;
            if (bShape[1] != shape[0] || bShape[2] != shape[1]) {
                LOGGER.warn("Lon bounds var has wrong shape (C).");
                return;
            }
        } else if (bShape[2] == 4) {
            this.bdsCornerDimIndex_ = 2;
            if (bShape[0] != shape[0] || bShape[1] != shape[1]) {
                LOGGER.warn("Lon bounds var has wrong shape (D).");
                return;
            }
        } else {
            LOGGER.warn("bdsCornerDimIndex_ == 1?");
        }
        bShape = this.latBoundsVar_.getShape();
        if (this.bdsCornerDimIndex_ == 0) {
            if (bShape[1] != shape[0] || bShape[2] != shape[1]) {
                LOGGER.warn("Lat bounds var has wrong shape (E).");
                return;
            }
        } else if (bShape[0] != shape[0] || bShape[1] != shape[1]) {
            LOGGER.warn("Lat bounds var has wrong shape (F).");
            return;
        }
        try {
            this.lonBoundsArray_ = this.lonBoundsVar_.read();
            this.lonBoundsIndex_ = this.lonBoundsArray_.getIndex();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read lon axis bounds array");
            return;
        }
        try {
            this.latBoundsArray_ = this.latBoundsVar_.read();
            this.latBoundsIndex_ = this.latBoundsArray_.getIndex();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read lat axis bounds array");
            return;
        }
        this.hasBounds_ = true;
    }

    public NcAxis getXAxis() {
        return this.xAxis_;
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    @Override
    protected void createFreeDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.reduceDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    @Override
    protected void findExtremaImpl() {
        double[] range = this.getActualRangeAttrValues();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        for (int i = 0; i < this.numReducePts_; ++i) {
            this.findExtremaTestValue(this.valueAt(i));
        }
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.numReducePts_) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + ", " + this.numReducePts_);
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed - index = {}.{}", (Object)index);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    public double valueAt(int col, int row) {
        try {
            if (this.reversedGrid_[col][row] < 0) {
                return Double.NaN;
            }
            return this.getDoubleFromSlice(this.reversedGrid_[col][row]);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed -  row,col = {}.{}", (Object)row, (Object)col);
            return -1.0;
        }
    }

    private double getDoubleFromSlice(int index) {
        if (this.needsSlice_) {
            this.doSlice();
        }
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.reduceDimIndex_] = index;
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.reduceDimIndex_] = 0;
            sShape[this.reduceDimIndex_] = this.numReducePts_;
            this.slice_ = this.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception doing slice: {}, {}", (Object)exc.getClass().getSimpleName(), (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.getMessage());
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatReduced2D();
    }

    public double longitudeAt(int col, int row) {
        if (this.rankMismatch_) {
            return this.lonArray_.getDouble(this.lonIndex_.set(0, col, row));
        }
        return this.lonArray_.getDouble(this.lonIndex_.set(col, row));
    }

    public double latitudeAt(int col, int row) {
        double lat = this.rankMismatch_ ? this.latArray_.getDouble(this.latIndex_.set(0, col, row)) : this.latArray_.getDouble(this.latIndex_.set(col, row));
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return Double.NaN;
        }
        return lat;
    }

    public PointLL lonLatAt(int col, int row) {
        if (col < 0 || row < 0 || col >= this.numXs_ || row >= this.numYs_) {
            return null;
        }
        return new PointLL(this.longitudeAt(col, row), this.latitudeAt(col, row));
    }

    public boolean doCellsAbut(int col1, int row1, int col2, int row2) {
        double[][] cx1 = this.cornerLonLats(col1, row1);
        double[][] cx2 = this.cornerLonLats(col2, row2);
        if (cx1 == null) {
            return false;
        }
        if (cx2 == null) {
            return false;
        }
        double lon11 = cx1[0][0];
        double lon12 = cx1[1][0];
        double lon13 = cx1[2][0];
        double lon14 = cx1[3][0];
        double lon21 = cx2[0][0];
        double lon22 = cx2[1][0];
        double lon23 = cx2[2][0];
        double lon24 = cx2[3][0];
        if (lon21 - 90.0 > lon11) {
            lon21 -= 360.0;
            lon22 -= 360.0;
            lon23 -= 360.0;
            lon24 -= 360.0;
        } else if (lon11 - 90.0 > lon21) {
            lon21 += 360.0;
            lon22 += 360.0;
            lon23 += 360.0;
            lon24 += 360.0;
        }
        if (Math.abs(lon11 - lon21) > 30.0) {
            return false;
        }
        double lat11 = cx1[0][1];
        double lat12 = cx1[1][1];
        double lat13 = cx1[2][1];
        double lat14 = cx1[3][1];
        double lat21 = cx2[0][1];
        double lat22 = cx2[1][1];
        double lat23 = cx2[2][1];
        double lat24 = cx2[3][1];
        double eps = 0.001 * Math.max(Math.abs(lon11 - 0.25 * (lon11 + lon12 + lon13 + lon14)), Math.abs(lat11 - 0.25 * (lat11 + lat12 + lat13 + lat14)));
        if (MathUtils.dequals(lon11, lon22, eps) && MathUtils.dequals(lat11, lat22, eps) && MathUtils.dequals(lon14, lon23, eps) && MathUtils.dequals(lat14, lat23, eps)) {
            return true;
        }
        if (MathUtils.dequals(lon11, lon24, eps) && MathUtils.dequals(lat11, lat24, eps) && MathUtils.dequals(lon12, lon23, eps) && MathUtils.dequals(lat12, lat23, eps)) {
            return true;
        }
        if (MathUtils.dequals(lon13, lon22, eps) && MathUtils.dequals(lat13, lat22, eps) && MathUtils.dequals(lon14, lon21, eps) && MathUtils.dequals(lat14, lat21, eps)) {
            return true;
        }
        return MathUtils.dequals(lon13, lon24, eps) && MathUtils.dequals(lat13, lat24, eps) && MathUtils.dequals(lon12, lon21, eps) && MathUtils.dequals(lat12, lat21, eps);
    }

    public boolean doCellsShareCorner(int col1, int row1, int col2, int row2) {
        double[][] b1 = this.cornerLonLats(col1, row1);
        double[][] b2 = this.cornerLonLats(col2, row2);
        if (b1 == null || b2 == null) {
            return false;
        }
        double tolerance = 0.25 * MathUtils.max(Math.abs(b1[0][0] - b1[2][0]), Math.abs(b1[0][1] - b1[2][1]), Math.abs(b1[1][0] - b1[2][0]), Math.abs(b1[1][1] - b1[2][1]));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double absDiff = Math.abs(b1[i][0] - b2[j][0]);
                if (!(absDiff < tolerance) && !(Math.abs(absDiff - 360.0) < tolerance) || !(Math.abs(b1[i][1] - b2[j][1]) < tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public double[][] cornerLonLats(int col, int row) {
        if (this.hasBounds_) {
            return this.getCornersFromBounds(col, row);
        }
        return this.estimateCellCornersFor(col, row);
    }

    private double[][] getCornersFromBounds(int col, int row) {
        double lon0 = this.longitudeAt(col, row);
        double lat0 = this.latitudeAt(col, row);
        if (lon0 > 180.0) {
            lon0 -= 360.0;
        } else if (lon0 < -180.0) {
            lon0 += 360.0;
        }
        if (this.lonVarDS_.isMissing(lon0) || this.latVarDS_.isMissing(lat0)) {
            return null;
        }
        double lon1 = this.cornerLongitudeAt(col, row, 0);
        double lon2 = this.cornerLongitudeAt(col, row, 1);
        double lon3 = this.cornerLongitudeAt(col, row, 2);
        double lon4 = this.cornerLongitudeAt(col, row, 3);
        if (this.lonBoundsVar_.isMissing(lon1) && this.lonBoundsVar_.isMissing(lon2) && this.lonBoundsVar_.isMissing(lon3) && this.lonBoundsVar_.isMissing(lon4)) {
            return null;
        }
        if (this.lonVarDS_.isMissing(lon1)) {
            lon1 = lon0;
        }
        if (this.lonVarDS_.isMissing(lon2)) {
            lon2 = lon0;
        }
        if (this.lonVarDS_.isMissing(lon3)) {
            lon3 = lon0;
        }
        if (this.lonVarDS_.isMissing(lon4)) {
            lon4 = lon0;
        }
        while (lon0 - lon1 > 45.0) {
            lon1 += 360.0;
        }
        while (lon0 - lon2 > 45.0) {
            lon2 += 360.0;
        }
        while (lon0 - lon3 > 45.0) {
            lon3 += 360.0;
        }
        while (lon0 - lon4 > 45.0) {
            lon4 += 360.0;
        }
        while (lon1 - lon0 > 45.0) {
            lon1 -= 360.0;
        }
        while (lon2 - lon0 > 45.0) {
            lon2 -= 360.0;
        }
        while (lon3 - lon0 > 45.0) {
            lon3 -= 360.0;
        }
        while (lon4 - lon0 > 45.0) {
            lon4 -= 360.0;
        }
        double lat1 = this.cornerLatitudeAt(col, row, 0);
        double lat2 = this.cornerLatitudeAt(col, row, 1);
        double lat3 = this.cornerLatitudeAt(col, row, 2);
        double lat4 = this.cornerLatitudeAt(col, row, 3);
        if (this.latBoundsVar_.isMissing(lat1)) {
            lat1 = lat0;
        }
        if (this.latBoundsVar_.isMissing(lat2)) {
            lat2 = lat0;
        }
        if (this.latBoundsVar_.isMissing(lat3)) {
            lat3 = lat0;
        }
        if (this.latBoundsVar_.isMissing(lat4)) {
            lat4 = lat0;
        }
        return new double[][]{{lon1, lat1}, {lon2, lat2}, {lon3, lat3}, {lon4, lat4}};
    }

    private double cornerLongitudeAt(int col, int row, int corner) {
        if (this.bdsCornerDimIndex_ == 0) {
            return this.lonBoundsArray_.getDouble(this.lonBoundsIndex_.set(corner, col, row));
        }
        if (this.bdsCornerDimIndex_ == 2) {
            return this.lonBoundsArray_.getDouble(this.lonBoundsIndex_.set(col, row, corner));
        }
        throw new NcException("cornerLongitudeAt failed");
    }

    private double cornerLatitudeAt(int col, int row, int corner) {
        if (this.bdsCornerDimIndex_ == 0) {
            return this.latBoundsArray_.getDouble(this.latBoundsIndex_.set(corner, col, row));
        }
        if (this.bdsCornerDimIndex_ == 2) {
            return this.latBoundsArray_.getDouble(this.latBoundsIndex_.set(col, row, corner));
        }
        throw new NcException("cornerLatitudeAt failed");
    }

    private double[][] estimateCellCornersFor(int col, int row) {
        int i = col;
        int j = row;
        double lon00 = this.longitudeAt(col, row);
        double lat00 = this.latitudeAt(col, row);
        if (lon00 > 180.0) {
            lon00 -= 360.0;
        } else if (lon00 < -180.0) {
            lon00 += 360.0;
        }
        int im1 = Math.max(i - 1, 0);
        int ip1 = Math.min(i + 1, this.numXs_ - 1);
        int jm1 = Math.max(j - 1, 0);
        int jp1 = Math.min(j + 1, this.numYs_ - 1);
        double lonMM = this.longitudeAt(im1, jm1);
        double lon0M = this.longitudeAt(i, jm1);
        double lonPM = this.longitudeAt(ip1, jm1);
        double lonP0 = this.longitudeAt(ip1, j);
        double lonPP = this.longitudeAt(ip1, jp1);
        double lon0P = this.longitudeAt(i, jp1);
        double lonMP = this.longitudeAt(im1, jp1);
        double lonM0 = this.longitudeAt(im1, j);
        double latMM = this.latitudeAt(im1, jm1);
        double lat0M = this.latitudeAt(i, jm1);
        double latPM = this.latitudeAt(ip1, jm1);
        double latP0 = this.latitudeAt(ip1, j);
        double latPP = this.latitudeAt(ip1, jp1);
        double lat0P = this.latitudeAt(i, jp1);
        double latMP = this.latitudeAt(im1, jp1);
        double latM0 = this.latitudeAt(im1, j);
        while (lon00 - lonMM > 45.0) {
            lonMM += 360.0;
        }
        while (lon00 - lon0M > 45.0) {
            lon0M += 360.0;
        }
        while (lon00 - lonPM > 45.0) {
            lonPM += 360.0;
        }
        while (lon00 - lonP0 > 45.0) {
            lonP0 += 360.0;
        }
        while (lon00 - lonPP > 45.0) {
            lonPP += 360.0;
        }
        while (lon00 - lon0P > 45.0) {
            lon0P += 360.0;
        }
        while (lon00 - lonMP > 45.0) {
            lonMP += 360.0;
        }
        while (lon00 - lonM0 > 45.0) {
            lonM0 += 360.0;
        }
        while (lonMM - lon00 > 45.0) {
            lonMM -= 360.0;
        }
        while (lon0M - lon00 > 45.0) {
            lon0M -= 360.0;
        }
        while (lonPM - lon00 > 45.0) {
            lonPM -= 360.0;
        }
        while (lonP0 - lon00 > 45.0) {
            lonP0 -= 360.0;
        }
        while (lonPP - lon00 > 45.0) {
            lonPP -= 360.0;
        }
        while (lon0P - lon00 > 45.0) {
            lon0P -= 360.0;
        }
        while (lonMP - lon00 > 45.0) {
            lonMP -= 360.0;
        }
        while (lonM0 - lon00 > 45.0) {
            lonM0 -= 360.0;
        }
        if (lonM0 == lon00 && latM0 == lat00) {
            lonMM = lon0M - (lonPM - lon0M);
            latMM = lat0M - (latPM - lat0M);
            lonM0 = lon00 - (lonP0 - lon00);
            latM0 = lat00 - (latP0 - lat00);
            lonMP = lon0P - (lonPP - lon0P);
            latMP = lat0P - (latPP - lat0P);
        } else if (lonP0 == lon00 && latP0 == lat00) {
            lonPM = lon0M + (lon0M - lonMM);
            latPM = lat0M + (lat0M - latMM);
            lonP0 = lon00 + (lon00 - lonM0);
            latP0 = lat00 + (lat00 - latM0);
            lonPP = lon0P + (lon0P - lonMP);
            latPP = lat0P + (lat0P - latMP);
        }
        if (lon0M == lon00 && lat0M == lat00) {
            lonMM = lonM0 - (lonMP - lonM0);
            latMM = latM0 - (latMP - latM0);
            lon0M = lon00 - (lon0P - lon00);
            lat0M = lat00 - (lat0P - lat00);
            lonPM = lonP0 - (lonPP - lonP0);
            latPM = latP0 - (latPP - latP0);
        } else if (lon0P == lon00 && lat0P == lat00) {
            lonMP = lonM0 + (lonM0 - lonMM);
            latMP = latM0 + (latM0 - latMM);
            lon0P = lon00 + (lon00 - lon0M);
            lat0P = lat00 + (lat00 - lat0M);
            lonPP = lonP0 + (lonP0 - lonPM);
            latPP = latP0 + (latP0 - latPM);
        }
        double[] cornerMM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonMM, latMM, lonM0, latM0);
        double[] cornerPM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonPM, latPM, lonP0, latP0);
        double[] cornerPP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonPP, latPP, lonP0, latP0);
        double[] cornerMP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonMP, latMP, lonM0, latM0);
        return new double[][]{cornerMM, cornerPM, cornerPP, cornerMP};
    }

    @Override
    public double[] aveFourLL(double lon1, double lat1, double lon2, double lat2, double lon3, double lat3, double lon4, double lat4) {
        boolean good4;
        boolean good2 = !Double.isNaN(lat2) && !this.latVarDS_.isMissing(lat2);
        boolean good3 = !Double.isNaN(lat3) && !this.latVarDS_.isMissing(lat3);
        boolean bl = good4 = !Double.isNaN(lat4) && !this.latVarDS_.isMissing(lat4);
        if (good2 && good3 && good4) {
            return new double[]{0.25 * (lon1 + lon2 + lon3 + lon4), 0.25 * (lat1 + lat2 + lat3 + lat4)};
        }
        if (good2 && good3) {
            return new double[]{0.5 * (lon1 + lon3), 0.5 * (lat1 + lat3)};
        }
        if (good3 && good4) {
            return new double[]{0.5 * (lon1 + lon3), 0.5 * (lat1 + lat3)};
        }
        if (good2 && good4) {
            return new double[]{0.5 * (lon2 + lon4), 0.5 * (lat2 + lat4)};
        }
        if (good2) {
            return new double[]{0.5 * (lon1 + lon2), 0.5 * (lat1 + lat2)};
        }
        if (good4) {
            return new double[]{0.5 * (lon1 + lon4), 0.5 * (lat1 + lat4)};
        }
        if (good3) {
            return new double[]{lon1, lat1};
        }
        return new double[]{lon1, lat1};
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double latD;
        double lonD;
        double latC;
        double lonC;
        double latB;
        double lonB;
        double latA;
        double lonA;
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int col = -1;
        int row = -1;
        for (int i = 0; i < this.numXs_; ++i) {
            for (int j = 0; j < this.numYs_; ++j) {
                double lat1;
                double lon1;
                try {
                    lon1 = this.longitudeAt(i, j);
                    lat1 = this.latitudeAt(i, j);
                }
                catch (Exception exc) {
                    continue;
                }
                if (Double.isNaN(lon1) || Double.isNaN(lat1)) continue;
                double dlon = lon1 - lon;
                double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
                double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
                double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
                double angle = Math.acos(cosAngle);
                if (angle == 0.0) {
                    return new int[]{i, j};
                }
                if (!(angle < mindist)) continue;
                mindist = angle;
                col = i;
                row = j;
            }
        }
        if (col < 0) {
            return null;
        }
        double lon0 = this.longitudeAt(col, row);
        double lat0 = this.latitudeAt(col, row);
        try {
            lonA = this.longitudeAt(col - 1, row);
            latA = this.latitudeAt(col - 1, row);
        }
        catch (Exception exc) {
            lonA = lon0;
            latA = lon0;
        }
        try {
            lonB = this.longitudeAt(col, row - 1);
            latB = this.latitudeAt(col, row - 1);
        }
        catch (Exception exc) {
            lonB = lon0;
            latB = lon0;
        }
        try {
            lonC = this.longitudeAt(col + 1, row);
            latC = this.latitudeAt(col + 1, row);
        }
        catch (Exception exc) {
            lonC = lon0;
            latC = lon0;
        }
        try {
            lonD = this.longitudeAt(col, row + 1);
            latD = this.latitudeAt(col, row + 1);
        }
        catch (Exception exc) {
            lonD = lon0;
            latD = lon0;
        }
        if (GeometryUtils.isPointInQuadrilateral(lon0, lat0, lonA, latA, lonB, latB, lonC, latC, lonD, latD)) {
            return new int[]{col, row};
        }
        return null;
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        sb.append("Not yet implemented.");
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatReduced2D.canGridVariable(ncd, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS) {
        Dimension d22;
        Dimension d21;
        List l = varDS.getCoordinateSystems();
        if (l == null || l.isEmpty()) {
            return false;
        }
        CoordinateSystem cs = (CoordinateSystem)l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        if (!(lonax instanceof CoordinateAxis2D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis2D)) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (lonshape.length != 2 || latshape.length != 2) {
            return false;
        }
        Dimension d11 = lonax.getDimension(0);
        if (!d11.equals(d21 = latax.getDimension(0))) {
            return false;
        }
        Dimension d12 = lonax.getDimension(1);
        if (!d12.equals(d22 = latax.getDimension(1))) {
            return false;
        }
        int rank = varDS.getRank();
        for (int i = 0; i < rank; ++i) {
            String compress;
            String[] tokens;
            Dimension d = varDS.getDimension(i);
            if (d == null) {
                LOGGER.debug("Dimension # {} is apparently null", (Object)i);
                return false;
            }
            VariableDS cv = ncd.getCoordinateVariable(d);
            if (cv == null) {
                LOGGER.debug("Dimension '{}' does not have matching coordinate variable", (Object)d);
                return false;
            }
            Attribute compressA = cv.findAttribute("compress");
            if (compressA == null || (tokens = (compress = compressA.getStringValue()).split(" ")).length != 2) continue;
            Dimension dd1 = ncd.getNjDimension(tokens[0]);
            Dimension dd2 = ncd.getNjDimension(tokens[1]);
            if (!d11.equals(dd1) || !d12.equals(dd2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LonLatEdges getLonLatEdges() {
        return LonLatEdges.ENTIRE_GLOBE;
    }
}

