/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridderLatVert;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import ucar.units.Converter;

public class NcGridderTimeVert
extends NcGridderLatVert {
    @Override
    public void regridNoInterpolate(NcArray nca, double[] target) {
        int j;
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        Converter vertConverter = this.getYAxisUnitsConverter(nca2D);
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        int numXs = xAxis.getValues().length;
        int numYs = yAxis.getValues().length;
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            double top = 0.0;
            double bottom = 0.0;
            for (int jj = 0; jj < numYs; ++jj) {
                if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                    top = jj;
                    bottom = jj + 1;
                } else {
                    top = yBounds[jj][0];
                    bottom = yBounds[jj][1];
                    if (vertConverter != null) {
                        top = vertConverter.convert(top);
                        bottom = vertConverter.convert(bottom);
                    }
                    if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                        if (!(top > 0.0)) continue block0;
                        top = Math.log10(top);
                        if (!(bottom > 0.0)) continue block0;
                        bottom = Math.log10(bottom);
                    }
                }
                if (!(this.rowYY_[j] <= top && this.rowYY_[j] > bottom) && (!(this.rowYY_[j] > top) || !(this.rowYY_[j] <= bottom))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            double xx = this.colXX_[i];
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs; ++ii) {
                double b1 = xBounds[ii][0];
                double b2 = xBounds[ii][1];
                if (!(xx >= b1) || !(xx < b2)) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.gridHeight_; ++j) {
            int i;
            if (srcRow[j] < 0) {
                for (i = 0; i < this.gridWidth_; ++i) {
                    this.setValue(target, i, j, Double.NaN);
                }
                continue;
            }
            for (i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) {
                    this.setValue(target, i, j, Double.NaN);
                    continue;
                }
                double value = nca2D.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca2D.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                this.setValue(target, i, j, value);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        Converter vertConverter = this.getYAxisUnitsConverter(nca2D);
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastY = numYs - 1;
        int[] srcCol = new int[this.gridWidth_];
        int[] srcRow = new int[this.gridHeight_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                double ynext;
                double ythis;
                if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                    ythis = (double)jj + 0.5;
                    ynext = (double)jj + 1.5;
                } else {
                    ythis = yVals[jj];
                    ynext = yVals[jj + 1];
                    if (vertConverter != null) {
                        ythis = vertConverter.convert(ythis);
                        ynext = vertConverter.convert(ynext);
                    }
                    if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                        if (!(ythis > 0.0)) continue;
                        ythis = Math.log10(ythis);
                        if (!(ynext > 0.0)) continue;
                        ynext = Math.log10(ynext);
                    }
                }
                if (!(this.rowYY_[j] >= ythis && this.rowYY_[j] < ynext) && (!(this.rowYY_[j] <= ythis) || !(this.rowYY_[j] > ynext))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs - 1; ++ii) {
                double xx = this.colXX_[i];
                if (!(xx >= xVals[ii] && xx < xVals[ii + 1]) && (!(xx <= xVals[ii]) || !(xx > xVals[ii + 1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double ynext;
            double ythis;
            int rowJ = srcRow[j];
            int rowJP1 = srcRow[j] + 1;
            if (rowJ == -1) continue;
            if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                ythis = (double)rowJ + 0.5;
                ynext = (double)rowJP1 + 0.5;
            } else {
                ythis = yVals[rowJ];
                ynext = yVals[rowJP1];
                if (vertConverter != null) {
                    ythis = vertConverter.convert(ythis);
                    ynext = vertConverter.convert(ynext);
                }
                if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                    ythis = Math.log10(ythis);
                    ynext = Math.log10(ynext);
                }
            }
            double yPct = (this.rowYY_[j] - ythis) / (ynext - ythis);
            for (int i = 0; i < this.gridWidth_; ++i) {
                int colI = srcCol[i];
                int colIP1 = srcCol[i] + 1;
                if (colI == -1) continue;
                double xPct = (this.colXX_[i] - xVals[colI]) / (xVals[colIP1] - xVals[colI]);
                double valTL = nca2D.valueAt(colI, rowJ);
                double valTR = nca2D.valueAt(colIP1, rowJ);
                double valBL = nca2D.valueAt(colI, rowJP1);
                double valBR = nca2D.valueAt(colIP1, rowJP1);
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }
}

