/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.overlay.GissBOverlay;
import gov.nasa.giss.map.overlay.GissOverlay;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OverlayFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static HashMap<String, Class<? extends MapOverlay>> ohash_ = new HashMap(10);

    private OverlayFactory() {
    }

    public static boolean registerOverlayExt(String fext, Class<? extends MapOverlay> oclass) {
        ohash_.put(fext.toLowerCase(), oclass);
        return true;
    }

    public static boolean isOverlayName(File ff) {
        return OverlayFactory.isOverlayName(ff.getName());
    }

    public static boolean isOverlayName(String fname) {
        Class<? extends MapOverlay> o = ohash_.get(fname.toLowerCase());
        return o != null;
    }

    public static MapOverlay create(String type) {
        Class<? extends MapOverlay> oclass = OverlayFactory.classForName(type);
        if (oclass == null) {
            throw new IllegalArgumentException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Constructor<? extends MapOverlay> c = oclass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Construction error: " + exc.getMessage());
        }
    }

    public static MapOverlay open(File file) throws FileNotFoundException, IOException {
        Objects.requireNonNull(file, "File cannot be null.");
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        Class<? extends MapOverlay> oclass = OverlayFactory.classForName(file.getName());
        if (oclass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{File.class};
            Object[] args = new Object[]{file};
            Constructor<? extends MapOverlay> c = oclass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t == null) {
                if (LOGGER.isTraceEnabled()) {
                    ite.printStackTrace();
                }
                throw new IllegalArgumentException("Construction error: " + ite.getMessage());
            }
            if (LOGGER.isTraceEnabled()) {
                t.printStackTrace();
            }
            throw new IllegalArgumentException(t.getMessage());
        }
        catch (Exception exc) {
            LOGGER.warn("Construction error: {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Construction error: " + exc.getMessage());
        }
    }

    public static MapOverlay open(URL url) {
        Objects.requireNonNull(url, "URL cannot be null.");
        Class<? extends MapOverlay> oclass = OverlayFactory.classForName(url.getFile());
        if (oclass == null) {
            throw new IllegalArgumentException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{URL.class};
            Object[] args = new Object[]{url};
            Constructor<? extends MapOverlay> c = oclass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            LOGGER.warn("Construction error: {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Construction error: " + exc.getMessage());
        }
    }

    public static MapOverlay open(byte[] bytes, String name) {
        Class<? extends MapOverlay> oclass = OverlayFactory.classForName(name);
        if (oclass == null) {
            throw new IllegalArgumentException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{byte[].class};
            Object[] args = new Object[]{bytes};
            Constructor<? extends MapOverlay> c = oclass.getConstructor(types);
            return c.newInstance(args);
        }
        catch (Exception exc) {
            LOGGER.warn("Construction error: {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new IllegalArgumentException("Construction error: " + exc.getMessage());
        }
    }

    private static Class<? extends MapOverlay> classForExtension(String fext) {
        return ohash_.get(fext.toLowerCase());
    }

    private static Class<? extends MapOverlay> classForName(String fname) {
        String fext = FileUtils.extractFnameExt(fname);
        return ohash_.get(fext.toLowerCase());
    }

    public static String[] getValidExtensions() {
        Set<String> kset = ohash_.keySet();
        int osize = ohash_.size();
        return kset.toArray(new String[osize]);
    }

    public static String[] getOutlineExtensions() {
        Set<String> kset = ohash_.keySet();
        ArrayList<String> extlist = new ArrayList<String>(ohash_.size());
        for (String fext : kset) {
            if (!OverlayFactory.classForExtension(fext).isAssignableFrom(OutlineOverlay.class)) continue;
            extlist.add(fext);
        }
        return extlist.toArray(new String[0]);
    }

    static {
        OverlayFactory.registerOverlayExt("cno", GissOverlay.class);
        OverlayFactory.registerOverlayExt("cnob", GissBOverlay.class);
        OverlayFactory.registerOverlayExt("shp", ShapefileOverlay.class);
    }
}

