/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.PointPoleProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AugustEpicycloidal
extends PointPoleProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "August Epicycloidal";
    public static final int PROPERTIES = 4096;
    private static final double LOBE_DX = 1.885618016720417;
    private static final double LOBE_DY = 1.4142135623730951;
    private static final double MAX_X_OVER_RS = 2.0;
    private static final double MAX_Y_OVER_RS = 1.4142135623730951;

    public AugustEpicycloidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public AugustEpicycloidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 2.0, 1.4142135623730951);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        Point2D.Double p2d = this.transformLL2XYIgnoreMargins(this.lambdaC_, 90.0);
        if (p2d == null) {
            LOGGER.trace("null");
        } else {
            LOGGER.trace("{}, {}", (Object)((p2d.x - (double)this.outCenterX_) * this.invRS_), (Object)((p2d.y - (double)this.outCenterY_) * this.invRS_));
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (Math.abs(lambdaRad) < 1.0E-5 && Math.abs(phiRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double lambdaRadOver2 = 0.5 * lambdaRad;
        double phiRadOver2 = 0.5 * phiRad;
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(phiRadOver2) < 1.0E-5) {
            double xp = Math.sin(lambdaRadOver2) / (1.0 + Math.cos(lambdaRadOver2));
            x = 0.5 * xp * (3.0 + xp * xp);
            y = 0.0;
        } else if (Math.abs(lambdaRadOver2) < 1.0E-5) {
            double tanHalfPhi = Math.tan(phiRadOver2);
            double xtanHalfPhi = Math.sqrt(1.0 - tanHalfPhi * tanHalfPhi);
            double yp = tanHalfPhi / (1.0 + xtanHalfPhi);
            x = 0.0;
            y = 0.5 * yp * (3.0 - yp * yp);
        } else {
            double tanHalfPhi = Math.tan(phiRadOver2);
            double xtanHalfPhi = Math.sqrt(1.0 - tanHalfPhi * tanHalfPhi);
            double denom = 1.0 + Math.cos(lambdaRadOver2) * xtanHalfPhi;
            double xp = Math.sin(lambdaRadOver2) * xtanHalfPhi / denom;
            double yp = tanHalfPhi / denom;
            double xp2 = xp * xp;
            double yp2 = yp * yp;
            x = 0.5 * xp * (3.0 + xp2 - 3.0 * yp2);
            y = 0.5 * yp * (3.0 + 3.0 * xp2 - yp2);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double capY;
        double capY2;
        double capX2;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        if (absy < 1.0E-5) {
            if (absXOverRS > Math.PI) {
                return null;
            }
            double lambdaRad = Math.signum(x) * Math.toDegrees(absXOverRS);
            return new PointLL(this.lambdaC_ + lambdaRad, 0.0);
        }
        if (absx < 1.0E-5) {
            if (absYOverRS > 1.0) {
                return null;
            }
            double phiRad = Math.signum(y) * Math.toDegrees(absYOverRS);
            return new PointLL(this.lambdaC_, phiRad);
        }
        double v = absYOverRS;
        double v2 = v * v;
        double u = absXOverRS;
        double u2 = u * u;
        double onePlusU2PlusV2 = 1.0 + u2 + v2;
        double sinSq3Eta = 0.5 * (onePlusU2PlusV2 - Math.sqrt(onePlusU2PlusV2 * onePlusU2PlusV2 - 4.0 * v2));
        double sin3Eta = Math.sqrt(sinSq3Eta);
        double etaRad = Math.asin(sin3Eta) / 3.0;
        double cosh3Xi = v / sin3Eta;
        double xiRad = MathUtils.arcosh(cosh3Xi) / 3.0;
        double capX = 2.0 * Math.sinh(xiRad) * Math.cos(etaRad);
        double lambdaRad = 2.0 * Math.atan2(2.0 * capX, 1.0 - (capX2 = capX * capX) - (capY2 = (capY = 2.0 * Math.cosh(xiRad) * Math.sin(etaRad)) * capY));
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = 2.0 * Math.atan2(2.0 * capY, 1.0 + capX2 + capY2);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AugustEpicycloidal augustEpicycloidal = this;
        synchronized (augustEpicycloidal) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double v = y * this.invRS_;
                double v2 = v * v;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double u = x * this.invRS_;
                    double u2 = u * u;
                    double onePlusU2PlusV2 = 1.0 + u2 + v2;
                    double sinSq3Eta = 0.5 * (onePlusU2PlusV2 - Math.sqrt(onePlusU2PlusV2 * onePlusU2PlusV2 - 4.0 * v2));
                    double sin3Eta = Math.sqrt(sinSq3Eta);
                    double etaRad = Math.asin(sin3Eta) / 3.0;
                    double cosh3Xi = v / sin3Eta;
                    double xiRad = Math.log(cosh3Xi + Math.sqrt(cosh3Xi * cosh3Xi - 1.0)) / 3.0;
                    double capX = 2.0 * Math.sinh(xiRad) * Math.cos(etaRad);
                    double capY = 2.0 * Math.cosh(xiRad) * Math.sin(etaRad);
                    double capX2 = capX * capX;
                    double capY2 = capY * capY;
                    double lambdaRad = 2.0 * Math.atan2(2.0 * capX, 1.0 - capX2 - capY2);
                    double phiRad = 2.0 * Math.atan2(2.0 * capY, 1.0 + capX2 + capY2);
                    if (lambdaRad > Math.PI && u > 1.885618016720417) continue block3;
                    if (lambdaRad > Math.PI) continue;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

