/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanZeroCenterScaleAction
extends AbstractAction {
    private final PanPlotMeta pmeta_;
    private final PanScaleControls scaleControls_;
    private boolean busy_;

    public PanZeroCenterScaleAction(PanPlotMeta pmeta, PanScaleControls scaleControls) {
        super(PanProperties.MENU_PROPS.getString("center-on-zero"));
        this.pmeta_ = pmeta;
        this.scaleControls_ = scaleControls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        PanData data = this.pmeta_.getData();
        double min = data.getMinValue();
        double max = data.getMaxValue();
        if (Double.isNaN(min)) {
            min = -0.1;
            max = 0.1;
        }
        double halfRange = 0.5 * Math.abs(max - min);
        this.scaleControls_.setScaleRange(-halfRange, halfRange);
        this.busy_ = false;
    }
}

