/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.util.PanColorbarLocation;
import gov.nasa.giss.panoply.util.PanExportKmlOption;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanKmzUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void save(File f, PanLonLatPlot llplot, Hashtable<PanExportKmlOption, Object> options) throws IOException {
        String fname = f.getName();
        String lcname = fname.toLowerCase();
        boolean knockout = false;
        boolean borderVis = false;
        boolean includeColorbar = false;
        if (options.containsKey((Object)PanExportKmlOption.KNOCKOUT)) {
            knockout = (Boolean)options.get((Object)PanExportKmlOption.KNOCKOUT);
        }
        if (options.containsKey((Object)PanExportKmlOption.BORDER)) {
            borderVis = (Boolean)options.get((Object)PanExportKmlOption.BORDER);
        }
        if (options.containsKey((Object)PanExportKmlOption.CBAR)) {
            includeColorbar = (Boolean)options.get((Object)PanExportKmlOption.CBAR);
        }
        String fnameRoot = lcname.endsWith(".kmz") ? fname.substring(0, fname.length() - 4) : fname;
        fnameRoot = fnameRoot.replaceAll("\\s", "_");
        LOGGER.trace("create ZipOutputStream");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
        LOGGER.trace("writeKml");
        PanKmzUtils.writeKml(fnameRoot, out, llplot, includeColorbar);
        LOGGER.trace("writeMap");
        PanKmzUtils.writeMap(fnameRoot, out, llplot, knockout, borderVis);
        if (includeColorbar) {
            LOGGER.trace("writeColorbar");
            PanKmzUtils.writeColorbar(fnameRoot, out, llplot);
        }
        LOGGER.trace("close ZipOutputStream");
        out.close();
    }

    private static void writeKml(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot llplot, boolean includeColorbar) throws IOException {
        PanPlotMeta pmeta = llplot.getMeta();
        String ttext = pmeta.getString("title.text");
        String stext = pmeta.getString("subtitle.text");
        LonLatEdges edges = llplot.getLonLatEdges();
        LOGGER.trace("edges {}", (Object)edges);
        ArrayList<Object> kmlStrs = new ArrayList<Object>();
        kmlStrs.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        kmlStrs.add("<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
        kmlStrs.add("<Folder>\n");
        kmlStrs.add("<open>1</open>\n");
        kmlStrs.add("<GroundOverlay>\n");
        if (ttext == null || ttext.isEmpty()) {
            kmlStrs.add("<name>" + fnameRoot + "</name>\n");
        } else {
            kmlStrs.add("<name>" + ttext + "</name>\n");
        }
        kmlStrs.add("<Icon>");
        kmlStrs.add("<href>" + fnameRoot + ".png</href>");
        kmlStrs.add("</Icon>\n");
        kmlStrs.add("<LatLonBox>\n");
        kmlStrs.add("<west>" + edges.getWest() + "</west>\n");
        kmlStrs.add("<north>" + edges.getNorth() + "</north>\n");
        kmlStrs.add("<east>" + edges.getEast() + "</east>\n");
        kmlStrs.add("<south>" + edges.getSouth() + "</south>\n");
        kmlStrs.add("</LatLonBox>\n");
        if (stext != null && !stext.isEmpty()) {
            kmlStrs.add("<description>\n");
            kmlStrs.add("<![CDATA[\n");
            kmlStrs.add(stext);
            kmlStrs.add("]]>\n");
            kmlStrs.add("</description>\n");
        }
        kmlStrs.add("</GroundOverlay>\n");
        if (includeColorbar) {
            boolean isHorizontal = PanColorbarLocation.matching(pmeta.getString("colorbar.location")).isHorizontal();
            kmlStrs.add("<ScreenOverlay>\n");
            kmlStrs.add("<name>Colorbar</name>\n");
            kmlStrs.add("<Icon>");
            kmlStrs.add("<href>" + fnameRoot + "_cbar.png</href>");
            kmlStrs.add("</Icon>\n");
            if (isHorizontal) {
                kmlStrs.add("<overlayXY x=\"0.5\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\" />\n");
                kmlStrs.add("<screenXY x=\"0.5\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\" />\n");
            } else {
                kmlStrs.add("<overlayXY x=\"1.0\" y=\"0.5\" xunits=\"fraction\" yunits=\"fraction\" />\n");
                kmlStrs.add("<screenXY x=\"1.0\" y=\"0.5\" xunits=\"fraction\" yunits=\"fraction\" />\n");
            }
            kmlStrs.add("<size x=\"-1\" y=\"-1\" xunits=\"fraction\" yunits=\"fraction\" />\n");
            kmlStrs.add("</ScreenOverlay>\n");
        }
        kmlStrs.add("</Folder>\n");
        kmlStrs.add("</kml>\n");
        zipstream.putNextEntry(new ZipEntry(fnameRoot + ".kml"));
        for (String string : kmlStrs) {
            byte[] bytes = string.getBytes("UTF-8");
            zipstream.write(bytes, 0, bytes.length);
        }
        zipstream.closeEntry();
    }

    private static void writeMap(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot llplot, boolean knockout, boolean borderVis) throws IOException {
        zipstream.putNextEntry(new ZipEntry(fnameRoot + ".png"));
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        BufferedImage img = llplot.drawKmlIconImage(knockout, borderVis);
        ImageIO.write((RenderedImage)img, "png", bstream);
        byte[] bytes = bstream.toByteArray();
        zipstream.write(bytes, 0, bytes.length);
        zipstream.closeEntry();
    }

    private static void writeColorbar(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot llplot) throws IOException {
        PanPlotPiece cb = llplot.getKmzColorbar();
        if (cb == null) {
            LOGGER.warn("Colorbar is null.");
            return;
        }
        Color oldbg = cb.getBackground();
        boolean oldOpaque = cb.isOpaque();
        if (oldbg.equals(Color.WHITE)) {
            cb.setOpaque(true);
        }
        BufferedImage img = cb.getImage();
        cb.setOpaque(oldOpaque);
        zipstream.putNextEntry(new ZipEntry(fnameRoot + "_cbar.png"));
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", bstream);
        byte[] bytes = bstream.toByteArray();
        zipstream.write(bytes, 0, bytes.length);
        zipstream.closeEntry();
    }

    private PanKmzUtils() {
    }
}

