/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import java.awt.Color;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotScrollPane
extends JScrollPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Border FOCUSED_BORDER;
    private static final Border UNFOCUSED_BORDER;

    public PanPlotScrollPane(Component cc) {
        super(cc);
        this.setOpaque(false);
        this.setBorder(null);
        this.getViewport().setOpaque(false);
        this.setViewportBorder(UNFOCUSED_BORDER);
        this.setBorder(null);
    }

    public void togglePlotBorderActive(boolean active) {
        if (active) {
            this.setViewportBorder(FOCUSED_BORDER);
        } else {
            this.setViewportBorder(UNFOCUSED_BORDER);
        }
        this.repaint();
    }

    static {
        UNFOCUSED_BORDER = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        Color c = UIManager.getColor("Focus.color");
        FOCUSED_BORDER = BorderFactory.createLineBorder(c, 4);
    }
}

