/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanClient {
    private static final int PANOPLY_PORT = 2880;
    private ArrayList<File> files_;
    private boolean serverFound_;
    private boolean success_;

    public static boolean testForPriorInstance(ArrayList<File> files) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        try {
            PanClient pc = new PanClient();
            if (files != null && files.size() > 0) {
                pc.attachFiles(files);
            }
            pc.testForServer();
            if (pc.isSuccessful()) {
                logger.debug("A previous instance of Panoply is active on this computer.");
                return true;
            }
            if (pc.isServerFound()) {
                logger.debug("A previous instance of Panoply is active, but I couldn't talk to it.");
                logger.debug("I will proceed as if there is no such instance.");
            } else {
                logger.debug("No previous instance of Panoply seems to be running.");
            }
        }
        catch (ConnectException exc) {
            logger.debug("ConnectException occurred testing whether a previous instance of Panoply is running.");
            logger.debug("This likely means that there is no such instance.");
            logger.debug("This instance will become the prior instance if others are started.");
        }
        catch (Exception exc) {
            logger.debug("An Exception occurred testing whether a previous instance of Panoply is running.");
            logger.debug("Exception is {}", (Object)exc.toString());
            logger.debug("I will proceed as if there is not.");
        }
        return false;
    }

    private PanClient() {
    }

    private void attachFiles(ArrayList<File> files) {
        this.files_ = files;
    }

    private void testForServer() throws ConnectException, IOException, UnknownHostException {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Socket socket = new Socket((String)null, 2880);
        InputStreamReader isr = new InputStreamReader(socket.getInputStream());
        BufferedReader fromServer = new BufferedReader(isr);
        PrintWriter toServer = new PrintWriter(socket.getOutputStream(), true);
        this.serverFound_ = true;
        this.success_ = true;
        int isize = this.files_ != null ? this.files_.size() : 0;
        logger.trace("isize {}", (Object)isize);
        int sentCount = 0;
        if (isize > 0) {
            String readFromServer;
            while ((readFromServer = fromServer.readLine()) != null) {
                String sendToServer;
                logger.trace("server asked for '{}'", (Object)readFromServer);
                if ("Bye.".equalsIgnoreCase(readFromServer)) break;
                if ("panoply".equalsIgnoreCase(readFromServer)) {
                    sendToServer = "panoply";
                } else if ("version".equalsIgnoreCase(readFromServer)) {
                    sendToServer = "4.5";
                } else if ("userid".equalsIgnoreCase(readFromServer)) {
                    String userName = System.getProperty("user.name");
                    sendToServer = userName == null ? "unknown" : userName;
                } else if ("filepath".equalsIgnoreCase(readFromServer)) {
                    sendToServer = this.files_.get(sentCount).getAbsolutePath();
                    ++sentCount;
                } else if ("continue?".equalsIgnoreCase(readFromServer)) {
                    sendToServer = sentCount < isize ? "y" : "n";
                } else {
                    if (readFromServer.toLowerCase().startsWith("error")) {
                        logger.warn("Server sent error '{}'", (Object)readFromServer);
                        if (sentCount > 0) {
                            this.success_ = true;
                            break;
                        }
                        this.success_ = false;
                        break;
                    }
                    logger.warn("Server sent unknown query '{}'", (Object)readFromServer);
                    this.success_ = false;
                    break;
                }
                logger.trace("send to server: '{}'", (Object)sendToServer);
                toServer.println(sendToServer);
            }
        }
        if (sentCount > 0) {
            logger.trace("{} file(s) passed to PanServer", (Object)sentCount);
        }
        toServer.println("Bye.");
        toServer.close();
        fromServer.close();
        socket.close();
    }

    private boolean isServerFound() {
        return this.serverFound_;
    }

    private boolean isSuccessful() {
        return this.success_;
    }
}

