/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;
import ucar.units.Converter;
import ucar.units.SI;
import ucar.units.ScaledUnit;
import ucar.units.Unit;

public class NcArrayLonLatAlbersEqualAreaConic
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private Projection njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;
    private double termC_;
    private double nn_;
    private double twoN_;
    private double oneOverN_;
    private double rho0_;
    private double oneOverAsq_;
    private double aOverN_;
    private double nSq_;
    private double phiIter1_;
    private double phiIter2_;
    private double phiIter3_;
    private double betaTerm_;

    public NcArrayLonLatAlbersEqualAreaConic(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.ALBERS_CONIC);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.ALBERS_CONIC)) {
            throw new NcException("Variable is not projected type Albers equal-area conic.");
        }
        LOGGER.trace("Using GISS proj");
        this.initGissProj();
    }

    private void initUnidataProj() {
        CoordinateSystem[] csarray = this.getCoordinateSystemArray();
        if (csarray.length == 0) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = csarray[0];
        if (cs == null) {
            throw new NcException("CoordinateSystem[0] is null");
        }
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("CoordinateSystem returned null projection handler.");
        }
        LOGGER.trace("CoordinateSystem returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof AlbersEqualArea) && !(pj instanceof AlbersEqualAreaEllipse)) {
            LOGGER.warn("Expected AlbersEqualArea(X) class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("CoordinateSystem returned projection class " + pj.getClass().getSimpleName() + " when AlbersEqualArea or AlbersEqualAreaEllipse was expected");
        }
        String xUnits = this.getCoordinateAxisOfType(NcAxisType.GEOX).getUnitsString();
        try {
            ScaledUnit projUnit = new ScaledUnit(1000.0, SI.METER);
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exc) {
            this.njProj_ = null;
        }
        this.njProj_ = pj;
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("albers_equal_area_conic") && !this.mappingName_.equalsIgnoreCase("albers_conical_equal_area")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not albers_equal_area_conic or albers_conical_equal_area");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        LOGGER.trace("ellipsoid {}", (Object)this.ellipsoid_);
        double phi1 = 30.0;
        double phi2 = -30.0;
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcException("Coordinate transform variable is missing standard parallel(s)");
        }
        if (parallelsA.isArray()) {
            Array pararray = parallelsA.getValues();
            double[] parvalues = (double[])pararray.get1DJavaArray(DataType.DOUBLE);
            phi1 = parvalues[0];
            phi2 = parvalues[1];
        } else {
            phi2 = phi1 = parallelsA.getNumericValue().doubleValue();
        }
        double phi1Rad = Math.toRadians(phi1);
        double phi2Rad = Math.toRadians(phi2);
        LOGGER.trace("phiC {}, phiCRad {}", (Object)this.phiC_, (Object)this.phiCRad_);
        LOGGER.trace("phi1 {}, phi1Rad {}", (Object)phi1, (Object)phi1Rad);
        LOGGER.trace("phi2 {}, phi2Rad {}", (Object)phi2, (Object)phi2Rad);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        double sinPhiC = Math.sin(this.phiCRad_);
        double sinPhi1 = Math.sin(phi1Rad);
        double sinPhi2 = Math.sin(phi2Rad);
        if (this.ellipsoid_) {
            double sinSqPhiC = sinPhiC * sinPhiC;
            double eSinPhiC = this.eccen_ * sinPhiC;
            double sinSqPhi1 = sinPhi1 * sinPhi1;
            double eSinPhi1 = this.eccen_ * sinPhi1;
            double sinSqPhi2 = sinPhi2 * sinPhi2;
            double eSinPhi2 = this.eccen_ * sinPhi2;
            double q0 = this.oneMinusE2_ * (sinPhiC / (1.0 - this.eccenSq_ * sinSqPhiC) - this.oneOver2E_ * Math.log((1.0 - eSinPhiC) / (1.0 + eSinPhiC)));
            double q1 = this.oneMinusE2_ * (sinPhi1 / (1.0 - this.eccenSq_ * sinSqPhi1) - this.oneOver2E_ * Math.log((1.0 - eSinPhi1) / (1.0 + eSinPhi1)));
            double q2 = this.oneMinusE2_ * (sinPhi2 / (1.0 - this.eccenSq_ * sinSqPhi2) - this.oneOver2E_ * Math.log((1.0 - eSinPhi2) / (1.0 + eSinPhi2)));
            double m1 = cosPhi1 / Math.sqrt(1.0 - this.eccenSq_ * sinSqPhi1);
            double m2 = cosPhi2 / Math.sqrt(1.0 - this.eccenSq_ * sinSqPhi2);
            double m1Sq = m1 * m1;
            double m2Sq = m2 * m2;
            this.nn_ = (m1Sq - m2Sq) / (q2 - q1);
            this.oneOverN_ = 1.0 / this.nn_;
            this.aOverN_ = this.semimajor_ * this.oneOverN_;
            this.termC_ = m1Sq + this.nn_ * q1;
            this.rho0_ = this.aOverN_ * Math.sqrt(this.termC_ - this.nn_ * q0);
            LOGGER.trace("q0 {}, q1 {}, q2 {}", q0, q1, q2);
            LOGGER.trace("m1 {}, m2 {}, n {}", m1, m2, this.nn_);
            LOGGER.trace("C {}", (Object)this.termC_);
            LOGGER.trace("rho0 {}", (Object)this.rho0_);
            this.oneOverAsq_ = 1.0 / (this.semimajor_ * this.semimajor_);
            double eccen4 = this.eccenSq_ * this.eccenSq_;
            double eccen6 = this.eccenSq_ * eccen4;
            this.phiIter1_ = this.eccenSq_ / 3.0 + 31.0 * eccen4 / 180.0 + 517.0 * eccen6 / 5040.0;
            this.phiIter2_ = 23.0 * eccen4 / 360.0 + 251.0 * eccen6 / 3780.0;
            this.phiIter3_ = 761.0 * eccen6 / 45360.0;
            this.betaTerm_ = 1.0 / (1.0 - this.oneMinusE2_ * this.oneOver2E_ * Math.log((1.0 - this.eccen_) / Math.log(1.0 + this.eccen_)));
        } else {
            this.nn_ = 0.5 * (sinPhi1 + sinPhi2);
            this.twoN_ = 2.0 * this.nn_;
            this.oneOverN_ = 1.0 / this.nn_;
            this.nSq_ = this.nn_ * this.nn_;
            this.termC_ = cosPhi1 * cosPhi1 + this.twoN_ * sinPhi1;
            this.rho0_ = this.radius_ * Math.sqrt(this.termC_ - this.twoN_ * sinPhiC) * this.oneOverN_;
        }
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        if (this.ellipsoid_) {
            return this.transformLL2XYEllipsoid(lon, lat);
        }
        return this.transformLL2XYSphere(lon, lat);
    }

    public Point2D.Double transformLL2XYSphere(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double rho = this.radius_ * Math.sqrt(this.termC_ - this.twoN_ * Math.sin(phiRad)) * this.oneOverN_;
        double theta = this.nn_ * lambdaRad;
        double x = rho * Math.sin(theta);
        double y = this.rho0_ - rho * Math.cos(theta);
        return new Point2D.Double(x + this.falseEasting_, y + this.falseNorthing_);
    }

    public Point2D.Double transformLL2XYEllipsoid(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double sinSqPhi = sinPhi * sinPhi;
        double eSinPhi = this.eccen_ * sinPhi;
        double q = this.oneMinusE2_ * (sinPhi / (1.0 - this.eccenSq_ * sinSqPhi) - this.oneOver2E_ * Math.log((1.0 - eSinPhi) / (1.0 + eSinPhi)));
        double rho = this.aOverN_ * Math.sqrt(this.termC_ - this.nn_ * q);
        double theta = this.nn_ * lambdaRad;
        double x = rho * Math.sin(theta);
        double y = this.rho0_ - rho * Math.cos(theta);
        return new Point2D.Double(x + this.falseEasting_, y + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        if (this.ellipsoid_) {
            return this.transformXY2LLEllipsoid(xx, yy);
        }
        return this.transformXY2LLSphere(xx, yy);
    }

    public PointLL transformXY2LLSphere(double xx, double yy) {
        double rho0MinusY = this.rho0_ - yy;
        double rho = Math.hypot(xx, rho0MinusY);
        double nRho = this.nn_ * rho;
        double phiRad = Math.asin(0.5 * (this.termC_ - nRho * nRho) * this.oneOverN_);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double theta = this.nn_ < 0.0 ? Math.atan2(-xx, -rho0MinusY) : Math.atan2(xx, rho0MinusY);
        double lambdaRad = theta * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }

    public PointLL transformXY2LLEllipsoid(double xx, double yy) {
        double yOverR = xx * this.oneOverR_;
        double xOverR = yy * this.oneOverR_;
        double rho0MinusYOverR = this.rho0_ - yOverR;
        double rho = Math.hypot(xOverR, rho0MinusYOverR);
        double q = (this.termC_ - rho * rho * this.nSq_ * this.oneOverAsq_) * this.oneOverN_;
        double theta = this.nn_ < 0.0 ? Math.atan2(-xOverR, -rho0MinusYOverR) : Math.atan2(xOverR, rho0MinusYOverR);
        double betaRad = Math.asin(q * this.betaTerm_);
        double phiRad = betaRad + this.phiIter1_ * Math.sin(2.0 * betaRad) + this.phiIter2_ * Math.sin(4.0 * betaRad) + this.phiIter3_ * Math.sin(6.0 * betaRad);
        if (Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = theta * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

