/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;

public class NcArrayLonLatMSGNavigation
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Projection njProj_;

    public NcArrayLonLatMSGNavigation(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.MSG_NAV);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.MSG_NAV)) {
            throw new NcException("Variable is not projected type MSG navigation.");
        }
        this.initUnidataProj();
    }

    private void initUnidataProj() {
        CoordinateSystem[] csarray = this.getCoordinateSystemArray();
        if (csarray.length == 0) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = csarray[0];
        if (cs == null) {
            throw new NcException("CoordinateSystem is null");
        }
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("CoordinateSystem returned null projection handler.");
        }
        LOGGER.trace("CoordinateSystem returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof MSGnavigation)) {
            LOGGER.warn("Expected MSGnavigation class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("CoordinateSystem returned projection class " + pj.getClass().getSimpleName() + " when MSGnavigation was expected");
        }
        this.njProj_ = pj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        return NcArrayLonLatMSGNavigation.transformNjLL2XY(this.njProj_, lon, lat);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        return NcArrayLonLatMSGNavigation.transformNjXY2LL(this.njProj_, x, y);
    }
}

