/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;

public abstract class BinaryColorTable
extends AbstractColorTable {
    protected BinaryColorTable() {
    }

    protected BinaryColorTable(File file, int min, int max) throws FileNotFoundException, IllegalArgumentException, IOException {
        Objects.requireNonNull(file, "File cannot be null.");
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(file.toURI().toURL());
        try (FileInputStream fis = new FileInputStream(file);){
            this.fillColorTable(this.readBytes(fis, min, max));
        }
    }

    protected BinaryColorTable(URL url, int min, int max) throws IOException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.setURL(url);
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is);
             DataInputStream dis = new DataInputStream(bis);){
            this.fillColorTable(this.readBytes(dis, min, max));
        }
    }

    public BinaryColorTable(byte[] b) throws IOException {
        this.fillColorTable(b);
    }

    @Override
    public boolean saveAs(File f) throws FileNotFoundException, IOException {
        try (FileOutputStream ostream = new FileOutputStream(f);){
            ostream.write(this.getBytes());
        }
        return true;
    }

    protected abstract byte[] getBytes();

    private byte[] readBytes(InputStream is, int min, int max) throws IllegalArgumentException, IOException {
        if (min <= 0 || max <= 0) {
            throw new IllegalArgumentException("Bytecount must be positive");
        }
        if (min > max) {
            throw new IllegalArgumentException("Max bytecount must be >= min");
        }
        byte[] b = new byte[max];
        int bytesRead = is.read(b);
        if (bytesRead < min) {
            throw new IOException("Invalid CT. Could not read at least " + min + " bytes.");
        }
        byte[] bb = Arrays.copyOf(b, bytesRead);
        return bb;
    }

    protected abstract void fillColorTable(byte[] var1) throws EOFException;
}

