/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class GriegerTriptychial
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Grieger Triptychial";
    public static final int PROPERTIES = 0x201000;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double TWO_K = 3.708149354602744;
    private static final double MAX_X_OVER_RS = 3.708149354602744;
    private static final double MAX_Y_OVER_RS = 1.854074677301372;
    private double kRS_;
    private double twoKRS_;
    private double close2KRS_;
    private double closeKRS_;
    private double almost2KRS_;
    private double almostKRS_;
    private double cosPhiC_;
    private double sinPhiC_;
    private LonLatRotator rotMatricesC_ = new LonLatRotator();
    private LonLatRotator rotMatricesO_ = new LonLatRotator();

    public GriegerTriptychial(int width, int height) {
        this(width, height, 0, 0);
    }

    public GriegerTriptychial(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x201000, width, height, xmargin, ymargin, 3.708149354602744, 1.854074677301372);
        this.setCenter(0.0, 45.0);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatricesC_ != null) {
            double lonR = MapUtils.normalizeMP180(180.0 + lon);
            double latR = -lat;
            this.rotMatricesC_.setAngles(lon, lat);
            this.rotMatricesO_.setAngles(lonR, latR, 90.0);
        }
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    protected final void finishScaling() {
        this.kRS_ = 1.854074677301372 * this.rS_;
        this.twoKRS_ = 3.708149354602744 * this.rS_;
        this.close2KRS_ = this.twoKRS_ - 25.0;
        this.closeKRS_ = this.kRS_ - 25.0;
        this.almost2KRS_ = this.twoKRS_ - 10.0;
        this.almostKRS_ = this.kRS_ - 10.0;
    }

    @Override
    public boolean isRecenterableLon() {
        return true;
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double ttemp;
        boolean central = true;
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ < 0.0) {
            central = false;
        }
        double[] llP = central ? this.rotMatricesC_.rotate(lon, lat) : this.rotMatricesO_.rotate(lon, lat);
        double lambdaRad2 = Math.toRadians(MapUtils.normalizeMP180(llP[0]));
        double phiRad2 = Math.toRadians(llP[1]);
        double absLambdaRad = Math.abs(lambdaRad2);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double sinLambda = Math.sin(absLambdaRad);
        double absPhiRad = Math.abs(phiRad2);
        double cosPhi2 = Math.cos(absPhiRad);
        double sinPhi2 = Math.sin(absPhiRad);
        double cosA = cosPhi2 * sinLambda;
        double cosB = sinPhi2;
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        if (sinPhi2 + cosA < 0.0) {
            mmm = -mmm;
        }
        if (sinPhi2 - cosA < 0.0) {
            nnn = -nnn;
        }
        double xx = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double yy = Elliptic.ellipticF(nnn, 0.5000000000000001);
        if (lambdaRad2 < 0.0 && phiRad2 < 0.0) {
            xx = -xx;
            yy = -yy;
        } else if (lambdaRad2 < 0.0) {
            ttemp = yy;
            yy = xx;
            xx = ttemp;
        } else if (phiRad2 < 0.0) {
            ttemp = yy;
            yy = -xx;
            xx = -ttemp;
        }
        if (!central) {
            xx = xx < 0.0 ? (xx += 3.708149354602744) : (xx -= 3.708149354602744);
        }
        double x = (double)this.outCenterX_ + xx * this.rS_;
        double y = (double)this.outCenterY_ - yy * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double[] llRot;
        boolean outer;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > this.twoKRS_ || absY > this.kRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        boolean bl = outer = Math.abs(xOverRS) > 1.854074677301372;
        if (outer) {
            xOverRS = xOverRS > 1.854074677301372 ? (xOverRS -= 3.708149354602744) : (xOverRS += 3.708149354602744);
        }
        if ((llRot = this.transformXYrs2LLRot(xOverRS, yOverRS)) == null || Double.isNaN(llRot[0]) || Double.isNaN(llRot[1])) {
            return null;
        }
        double[] ll = outer ? this.rotMatricesO_.inverse(llRot[0], llRot[1]) : this.rotMatricesC_.inverse(llRot[0], llRot[1]);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GriegerTriptychial griegerTriptychial = this;
        synchronized (griegerTriptychial) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double[] llRot;
                    boolean outer;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    boolean bl = outer = Math.abs(xOverRS) > 1.854074677301372;
                    if (outer) {
                        xOverRS = xOverRS > 1.854074677301372 ? (xOverRS -= 3.708149354602744) : (xOverRS += 3.708149354602744);
                    }
                    if ((llRot = this.transformXYrs2LLRot(xOverRS, yOverRS)) == null) continue;
                    double[] ll = outer ? this.rotMatricesO_.inverse(llRot[0], llRot[1]) : this.rotMatricesC_.inverse(llRot[0], llRot[1]);
                    this.setInvPoint(ix, iy, ll[0], ll[1]);
                }
            }
        }
    }

    private double[] transformXYrs2LLRot(double x, double y) {
        double cosB;
        double xx = Math.abs(x);
        double yy = Math.abs(y);
        double[] jacobiM = Elliptic.jacobiSnCnDn(xx, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(yy, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = y * x < 0.0 ? -Math.acos(cosAminusB) : Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double sinPhi = cosB = Math.cos(b);
        double phiRad = x < 0.0 ? -Math.asin(sinPhi) : Math.asin(sinPhi);
        double cosPhi = Math.cos(phiRad);
        double sinLambda = cosA / cosPhi;
        double lambdaRad = x < 0.0 ? -Math.asin(sinLambda) : Math.asin(sinLambda);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawRect(g2d, (double)this.outCenterX_ - this.twoKRS_, (double)this.outCenterY_ - this.kRS_, 2.0 * this.twoKRS_, this.twoKRS_);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dot;
        double lat;
        double lambda = this.lonToLambda(lon);
        double abslambda = Math.abs(lambda);
        if (abslambda < 1.0E-5) {
            Point2D.Double dotN = this.transformLL2XY(lon, maxLat - 1.0E-5);
            Point2D.Double dotS = this.transformLL2XY(lon, -maxLat + 1.0E-5);
            if (this.phiC_ > 0.0) {
                GraphicUtils.drawLine(g2d, dotN.x, dotN.y, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
                GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_, dotS.x, dotS.y);
            } else {
                GraphicUtils.drawLine(g2d, dotS.x, dotS.y, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
                GraphicUtils.drawLine(g2d, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_, dotN.x, dotN.y);
            }
            return;
        }
        if (abslambda > 179.99999) {
            if (Math.abs(this.phiC_) > 89.99999) {
                Point2D.Double dotN = this.transformLL2XY(lon, maxLat - 1.0E-5);
                Point2D.Double dotS = this.transformLL2XY(lon, -maxLat + 1.0E-5);
                if (this.phiC_ > 0.0) {
                    GraphicUtils.drawLine(g2d, dotN.x, dotN.y, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
                    GraphicUtils.drawLine(g2d, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_, dotS.x, dotS.y);
                } else {
                    GraphicUtils.drawLine(g2d, dotS.x, dotS.y, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
                    GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_, dotN.x, dotN.y);
                }
                return;
            }
            if (this.phiC_ < 0.0) {
                Point2D.Double dotS = this.transformLL2XY(lon, -maxLat + 1.0E-5);
                Point2D.Double dotA = this.transformLL2XY(lon, Math.min(-this.phiC_ - 1.0E-5, maxLat - 1.0E-5));
                GraphicUtils.drawLine(g2d, dotS.x, dotS.y, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
                GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_, dotA.x, dotA.y);
                if (maxLat > -this.phiC_) {
                    Point2D.Double dotB = this.transformLL2XY(lon, -this.phiC_ + 1.0E-5);
                    Point2D.Double dotN = this.transformLL2XY(lon, maxLat - 1.0E-5);
                    GraphicUtils.drawLine(g2d, dotB.x, dotB.y, dotN.x, dotN.y);
                }
                return;
            }
            Point2D.Double dotN = this.transformLL2XY(lon, maxLat - 1.0E-5);
            Point2D.Double dotA = this.transformLL2XY(lon, Math.max(-this.phiC_ + 1.0E-5, -maxLat + 1.0E-5));
            GraphicUtils.drawLine(g2d, dotN.x, dotN.y, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_, dotA.x, dotA.y);
            if (maxLat > this.phiC_) {
                Point2D.Double dotB = this.transformLL2XY(lon, -this.phiC_ - 1.0E-5);
                Point2D.Double dotS = this.transformLL2XY(lon, -maxLat + 1.0E-5);
                GraphicUtils.drawLine(g2d, dotB.x, dotB.y, dotS.x, dotS.y);
            }
            return;
        }
        boolean pm90 = Math.abs(90.0 - abslambda) < 1.0E-5;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        Point2D.Double lastdot = new Point2D.Double(0.0, 0.0);
        double lastLat = lat = maxLat < -89.99999 ? -89.99999 : -maxLat;
        boolean lastGood = false;
        while (lat < maxLat) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                if (lastGood && lat - lastLat > 0.1) {
                    lat -= 0.01;
                    continue;
                }
                this.drawCurve(g2d, ptlist);
                lastLat = lat;
                lat += 0.01;
                continue;
            }
            if (ptlist.size() != 0) {
                if (pm90 && lat >= 0.0 && lastLat < 0.0) {
                    this.drawCurve(g2d, ptlist);
                } else if (dot.distance(lastdot) > this.kRS_) {
                    this.drawCurve(g2d, ptlist);
                }
            }
            ptlist.add(dot);
            lastdot.setLocation(dot.x, dot.y);
            lastLat = lat;
            lastGood = true;
            double absLat = Math.abs(lat);
            if (Math.abs(dot.x - (double)this.outCenterX_) > this.almost2KRS_ || Math.abs(dot.y - (double)this.outCenterY_) > this.almostKRS_) {
                lat += 0.01;
                continue;
            }
            if (Math.abs(dot.x - (double)this.outCenterX_) > this.close2KRS_ || Math.abs(dot.y - (double)this.outCenterY_) > this.closeKRS_) {
                lat += 0.025;
                continue;
            }
            lat += 0.3;
        }
        Point2D.Double double_ = dot = lat < 89.99999 ? this.transformLL2XY(lon, maxLat) : null;
        if (dot == null) {
            this.drawCurve(g2d, ptlist);
        } else if (ptlist.size() != 0) {
            if (dot.distance(lastdot) > 25.0) {
                this.drawCurve(g2d, ptlist);
            } else {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
                this.drawCurve(g2d, ptlist);
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot;
        double lon;
        if (lat == 0.0 && Math.abs(this.phiC_) > 89.99999) {
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ - this.kRS_, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_, (double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ + this.kRS_);
            return;
        }
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(800);
        Point2D.Double lastdot = new Point2D.Double(0.0, 0.0);
        double endLon = this.lambdaC_ + 179.99999;
        double lastLon = lon = this.lambdaC_ - 179.99999;
        boolean lastGood = false;
        while (lon < endLon) {
            if (lat == 0.0 && (lon > this.lambdaC_ - 90.0 && lastLon < this.lambdaC_ - 90.0 || lon > this.lambdaC_ + 90.0 && lastLon < this.lambdaC_ + 90.0)) {
                this.drawCurve(g2d, ptlist);
                lastGood = false;
            }
            if ((dot = this.transformLL2XY(lon, lat)) == null) {
                if (lastGood && lon - lastLon > 0.1) {
                    lon -= 0.01;
                    continue;
                }
                this.drawCurve(g2d, ptlist);
                lastLon = lon;
                lastGood = false;
                lon += 0.01;
                continue;
            }
            if (ptlist.size() != 0 && dot.distance(lastdot) > 25.0) {
                this.drawCurve(g2d, ptlist);
            }
            ptlist.add(dot);
            lastdot.setLocation(dot.x, dot.y);
            lastLon = lon;
            lastGood = true;
            if (Math.abs(dot.x - (double)this.outCenterX_) > this.almost2KRS_ || Math.abs(dot.y - (double)this.outCenterY_) > this.almostKRS_) {
                lon += 0.01;
                continue;
            }
            if (Math.abs(dot.x - (double)this.outCenterX_) > this.close2KRS_ || Math.abs(dot.y - (double)this.outCenterY_) > this.closeKRS_) {
                lon += 0.025;
                continue;
            }
            lon += 0.3;
        }
        dot = this.transformLL2XY(endLon, lat);
        if (dot == null) {
            this.drawCurve(g2d, ptlist);
        } else if (ptlist.size() != 0) {
            if (dot.distance(lastdot) > 25.0) {
                this.drawCurve(g2d, ptlist);
            } else {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
                this.drawCurve(g2d, ptlist);
            }
        }
    }

    private void drawCurve(Graphics2D g2d, ArrayList<Point2D.Double> ptlist) {
        Bezier bcurve;
        if (ptlist.size() > 1 && (bcurve = new Bezier(false, ptlist)) != null) {
            bcurve.draw(g2d);
        }
        ptlist.clear();
    }
}

