/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McBrydeThomas4
extends InterruptedPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "McBryde-Thomas Flat-Polar Quartic";
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double CONST_K = 0.5;
    private static final double CONST_N = 1.7071067811865475;
    private static final double CAP_M = Math.sqrt(0.6443650813895955);
    private static final double CSUBX = 0.5 * CAP_M / 1.5;
    private static final double INV_CSUBX = 1.0 / CSUBX;
    private static final double CSUBY = 2.0 * CAP_M;
    private static final double INV_CSUBY = 1.0 / CSUBY;
    private static final double MAX_X_OVER_RS = 3.0 * CSUBX * Math.PI;
    private static final double MAX_Y_OVER_RS = CSUBY / 1.4142135623730951;
    private double xFactor0_;

    public McBrydeThomas4(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeThomas4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.xFactor0_ = this.invRS_ * INV_CSUBX / 3.0;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double phiRad = Math.toRadians(lat);
        if (Math.abs(phiRad) < 1.0E-5) {
            x = CSUBX * this.lonToLambdaRad(lon) * 3.0;
            y = 0.0;
        } else {
            double halfAlphaRad;
            double nSinPhi = 1.7071067811865475 * Math.sin(phiRad);
            double alphaRad = phiRad;
            for (int iter = 0; iter < 33; ++iter) {
                halfAlphaRad = 0.5 * alphaRad;
                double func = Math.sin(halfAlphaRad) + Math.sin(alphaRad) - nSinPhi;
                double dfunc = 0.5 * Math.cos(halfAlphaRad) + Math.cos(alphaRad);
                double dalphaRad = -func / dfunc;
                alphaRad += dalphaRad;
                if (Math.abs(dalphaRad) < 1.0E-5) break;
            }
            halfAlphaRad = 0.5 * alphaRad;
            y = CSUBY * Math.sin(halfAlphaRad);
            double cosAlpha = Math.cos(alphaRad);
            double cosAlphaOver2 = Math.cos(halfAlphaRad);
            double alphaTerm = 1.0 + 2.0 * cosAlpha / cosAlphaOver2;
            if (this.isInterrupted()) {
                double[] gore = this.getGore(lon, lat);
                double nlon = MapUtils.normalizeMP180(lon);
                double dlon = nlon - gore[1];
                double dx = CSUBX * Math.toRadians(dlon) * alphaTerm;
                double cx = CSUBX * this.lonToLambdaRad(gore[1]) * 3.0;
                x = cx + dx;
            } else {
                x = CSUBX * this.lonToLambdaRad(lon) * alphaTerm;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double alphaRad = 2.0 * Math.asin(y * this.invRS_ * INV_CSUBY);
        double phiRad = Math.asin(2.0 * (Math.sin(alphaRad) + Math.sin(0.5 * alphaRad)) / 3.414213562373095);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.invRS_ * INV_CSUBX / (1.0 + 2.0 * Math.cos(alphaRad) / Math.cos(0.5 * alphaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeThomas4 mcBrydeThomas4 = this;
        synchronized (mcBrydeThomas4) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double alphaRad = 2.0 * Math.asin(yOverRS * INV_CSUBY);
                double phiRad = Math.asin(2.0 * (Math.sin(alphaRad) + Math.sin(0.5 * alphaRad)) / 3.414213562373095);
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * INV_CSUBX / (1.0 + 2.0 * Math.cos(alphaRad) / Math.cos(0.5 * alphaRad));
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        block2: {
            try {
                super.drawBorderLines(g2d);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }
}

