/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wagner6
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wagner VI";
    private ProjListParameter variantParam_ = new ProjListParameter("Variant", "Variant", Variant.class, 0);
    private Variant variant_;
    private double cx_;
    private double cy_;
    private double cphi2_;
    private double invCx_;
    private double invCy_;
    private double invCxRS_ = 1.0;
    private double invCyRS_ = 1.0;

    public Wagner6(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner6(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.variantParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.variantParam_)) {
            int varIndex = this.variantParam_.getIndex();
            this.variant_ = Variant.values()[varIndex];
            LOGGER.trace("variant {}", (Object)this.variant_);
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.cx_ = this.variant_.getCx();
        this.cy_ = this.variant_.getCy();
        this.cphi2_ = this.variant_.getCphi2();
        this.invCx_ = 1.0 / this.cx_;
        this.invCy_ = 1.0 / this.cy_;
        double wfactor = this.cx_ * Math.PI;
        double hfactor = this.cy_ * 1.5707963267948966;
        this.setMaxXYOverRS(wfactor, hfactor);
    }

    @Override
    protected final void finishScaling() {
        this.invCxRS_ = this.invCx_ * this.invRS_;
        this.invCyRS_ = this.invCy_ * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > Math.PI) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double sin2Psi = this.cphi2_ * phiRad * phiRad;
        double cosPsi = Math.sqrt(1.0 - sin2Psi);
        double x = this.cx_ * lambdaRad * cosPsi;
        double y = this.cy_ * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invCyRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double sin2Psi = this.cphi2_ * phiRad * phiRad;
        double cosPsi = Math.sqrt(1.0 - sin2Psi);
        double lambdaRad = x * this.invCxRS_ / cosPsi;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner6 wagner6 = this;
        synchronized (wagner6) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invCyRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double sin2Psi = this.cphi2_ * phiRad * phiRad;
                double cosPsi = Math.sqrt(1.0 - sin2Psi);
                double xFactor = this.invCxRS_ / cosPsi;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private static enum Variant implements ProjListEnum
    {
        WAGNER6("Wagner VI"),
        CANTERSW06("Canters W06"),
        FRANCULA2("Fran\u010dula II"),
        FRANCULA7("Fran\u010dula VII"),
        FRANCULA11("Fran\u010dula XI");

        private String text_;
        private double varCx_;
        private double varCy_;
        private double varCphi2_;

        private Variant(String text) {
            this.text_ = text;
            switch (text) {
                case "Wagner VI": {
                    double m = 0.5 * Math.sqrt(3.0);
                    double n2 = 0.5 * Math.sqrt(3.0);
                    double cphi = 2.0 * m * 0.3183098861837907;
                    this.varCx_ = n2 / Math.sqrt(n2 * m);
                    this.varCy_ = 1.5707963267948966 * cphi / Math.sqrt(n2 * m);
                    this.varCphi2_ = cphi * cphi;
                    break;
                }
                case "Canters W06": {
                    double m = 0.7415;
                    double n3 = 0.7198;
                    double k1 = 0.8089;
                    double cphi = 0.47205356121056163;
                    this.varCx_ = 0.5822462199999999 / Math.sqrt(0.5337317);
                    this.varCy_ = 1.5707963267948966 / Math.sqrt(0.5337317) * 0.47205356121056163;
                    this.varCphi2_ = 0.22283456465157345;
                    break;
                }
                case "Fran\u010dula II": 
                case "Fran\u010dula VII": 
                case "Fran\u010dula XI": {
                    double phi0;
                    double ce;
                    double cp;
                    switch (text) {
                        case "Fran\u010dula II": {
                            cp = 2.05;
                            ce = 2.6;
                            phi0 = 61.0;
                            break;
                        }
                        case "Fran\u010dula VII": {
                            cp = 2.07;
                            ce = 2.8;
                            phi0 = 40.0;
                            break;
                        }
                        case "Fran\u010dula XI": {
                            cp = 1.95;
                            ce = 1.55;
                            phi0 = 43.0;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Somehow got 'default' Francula variant case");
                        }
                    }
                    double phi0Rad = Math.toRadians(phi0);
                    double cm = Math.sqrt(1.0 - 1.0 / (ce * ce));
                    double cn = 0.5 * cp * cm;
                    double cm2 = cm * cm;
                    this.varCphi2_ = 4.0 * cm2 / (Math.PI * Math.PI);
                    this.varCx_ = Math.cos(phi0Rad) / Math.sqrt(1.0 - this.varCphi2_ * phi0Rad * phi0Rad);
                    this.varCy_ = cm / Math.sqrt(cm * cn);
                    break;
                }
                default: {
                    throw new RuntimeException("Somehow got 'default' variant case");
                }
            }
        }

        double getCx() {
            return this.varCx_;
        }

        double getCy() {
            return this.varCy_;
        }

        double getCphi2() {
            return this.varCphi2_;
        }

        public String toString() {
            return this.text_;
        }

        @Override
        public boolean matches(String str) {
            return this.nameMatches(str) || this.textMatches(str);
        }

        public boolean nameMatches(String str) {
            return this.name().equalsIgnoreCase(str);
        }

        public boolean textMatches(String str) {
            return this.text_.equalsIgnoreCase(str);
        }
    }
}

