/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wagner8
extends ConcavePoleProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wagner VIII";
    public static final int PROPERTIES = 270368;
    private ProjListParameter variantParam_ = new ProjListParameter("Variant", "Variant", Variant.class, 0);
    private Variant variant_;
    private double m1_;
    private double m2_;
    private double cn_;
    private double ca_;
    private double cb_;
    private double invCn_;
    private double invCa_;
    private double invCb_;

    public Wagner8(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner8(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 270368, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(this.variantParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.variantParam_)) {
            int varIndex = this.variantParam_.getIndex();
            this.variant_ = Variant.values()[varIndex];
            LOGGER.trace("variant {}", (Object)this.variant_);
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double cosNLambda;
        this.m1_ = this.variant_.getM1();
        this.m2_ = this.variant_.getM2();
        this.cn_ = this.variant_.getN();
        this.ca_ = this.variant_.getCx();
        this.cb_ = this.variant_.getCy();
        this.invCn_ = 1.0 / this.cn_;
        this.invCa_ = 1.0 / this.ca_;
        this.invCb_ = 1.0 / this.cb_;
        double nLambdaRad = this.cn_ * Math.PI;
        double cosDelta = cosNLambda = Math.cos(nLambdaRad);
        double deltaRad = Math.acos(cosDelta);
        double d = Math.sin(0.5 * deltaRad);
        double wfactor = this.ca_ * d;
        nLambdaRad = this.cn_ * Math.PI;
        cosNLambda = Math.cos(nLambdaRad);
        double sinPsi = this.m1_ * Math.sin(this.m2_ * 1.5707963267948966);
        double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
        double cosDelta2 = cosPsi * cosNLambda;
        double sinDelta = Math.sqrt(1.0 - cosDelta2 * cosDelta2);
        double deltaRad2 = Math.acos(cosDelta2);
        double d2 = Math.sin(0.5 * deltaRad2);
        double cosAlpha = sinPsi / sinDelta;
        double hfactor = this.cb_ * d2 * cosAlpha;
        this.setMaxXYOverRS(wfactor, hfactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.abs(Math.toRadians(lat));
        if (Math.abs(lambdaRad) < 1.0E-10) {
            double cosPsi;
            double sinPsi = this.m1_ * Math.sin(this.m2_ * phiRad);
            double cosDelta = cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
            double deltaRad = Math.acos(cosDelta);
            double sinDeltaOver2 = Math.sin(0.5 * deltaRad);
            x = 0.0;
            y = this.cb_ * sinDeltaOver2;
        } else {
            double nLambdaRad = this.cn_ * lambdaRad;
            double cosNLambda = Math.cos(nLambdaRad);
            double sinPsi = this.m1_ * Math.sin(this.m2_ * phiRad);
            double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
            double cosDelta = cosNLambda * cosPsi;
            double sinDelta = Math.sqrt(1.0 - cosDelta * cosDelta);
            double deltaRad = Math.acos(cosDelta);
            double sinDeltaOver2 = Math.sin(0.5 * deltaRad);
            double cosAlpha = sinPsi / sinDelta;
            double sinAlpha = Math.sqrt(1.0 - cosAlpha * cosAlpha);
            x = this.ca_ * sinDeltaOver2 * sinAlpha;
            y = this.cb_ * sinDeltaOver2 * cosAlpha;
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverCx = x * this.invCa_;
        double yOverCy = y * this.invCb_;
        double d = Math.hypot(xOverCx, yOverCy) * this.invRS_;
        double phiRad = 0.0;
        double lambdaRad = 0.0;
        if (d > 1.0E-5) {
            if (Math.abs(phiRad) > this.m1_) {
                return null;
            }
            double delta = 2.0 * Math.asin(d);
            double sinPsi = yOverCy * this.invRS_ * Math.sin(delta) / d;
            phiRad = Math.asin(sinPsi / this.m1_) / this.m2_;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            if (Math.abs(phiRad) == 1.5707963267948966) {
                lambdaRad = 0.0;
            } else {
                double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
                lambdaRad = this.invCn_ * Math.acos(Math.cos(delta) / cosPsi);
                if (x < 0.0) {
                    lambdaRad = 0.0 - lambdaRad;
                }
            }
        }
        if (Double.isNaN(lambdaRad) || Double.isNaN(phiRad) || Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner8 wagner8 = this;
        synchronized (wagner8) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverCy = y * this.invCb_;
                double yOverCyRS = yOverCy * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverCx = x * this.invCa_;
                    double d = Math.hypot(xOverCx, yOverCy) * this.invRS_;
                    if (d > 1.0E-5) {
                        double delta = 2.0 * Math.asin(d);
                        double sinPsi = yOverCyRS * Math.sin(delta) / d;
                        if (sinPsi > this.m1_ || (phiRad = Math.asin(sinPsi / this.m1_) / this.m2_) > 1.5707963267948966) continue;
                        if (phiRad == 1.5707963267948966) {
                            lambdaRad = 0.0;
                        } else {
                            double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
                            lambdaRad = this.invCn_ * Math.acos(Math.cos(delta) / cosPsi);
                        }
                        if (lambdaRad > Math.PI) {
                            continue block3;
                        }
                    } else {
                        phiRad = 0.0;
                        lambdaRad = 0.0;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static enum Variant implements ProjListEnum
    {
        WAGNER8("Wagner VIII", 65.0, 60.0, 60.0, 1.2, 2.0),
        CANTERS_W08("Canters W08", 55.4366, 118.854, 60.0, 1.2, 1.9654),
        BOHM_V1("B\u00f6hm Variant 1", 65.0, 84.0, 60.0, 1.25, 2.0),
        BOHM_V2("B\u00f6hm Variant 2", 75.0, 108.0, 60.0, 1.0, 2.0),
        BOHM_V3("B\u00f6hm Variant 3", 57.0, 105.0, 60.0, 1.2, 2.0),
        BOHM_V4("B\u00f6hm Variant 4", 60.0, 132.0, 60.0, 1.0, 2.0);

        private String text_;
        private double m1_;
        private double m2_;
        private double n_;
        private double ca_;
        private double cb_;

        private Variant(String text, double psi1, double lambda1, double phi1, double s60, double p) {
            this.text_ = text;
            double psi1rad = Math.toRadians(psi1);
            double lambda1rad = Math.toRadians(lambda1);
            double phi1rad = Math.toRadians(phi1);
            this.m2_ = Math.acos(s60 * Math.cos(phi1rad)) / phi1rad;
            this.m1_ = Math.sin(psi1rad) / Math.sin(this.m2_ * 1.5707963267948966);
            this.n_ = lambda1 / 180.0;
            double varK = Math.sqrt(p * Math.sin(0.5 * psi1rad) / Math.sin(0.5 * lambda1rad));
            this.ca_ = 2.0 * varK / Math.sqrt(this.n_ * this.m1_ * this.m2_);
            this.cb_ = 2.0 / (varK * Math.sqrt(this.n_ * this.m1_ * this.m2_));
        }

        double getM1() {
            return this.m1_;
        }

        double getM2() {
            return this.m2_;
        }

        double getN() {
            return this.n_;
        }

        double getCx() {
            return this.ca_;
        }

        double getCy() {
            return this.cb_;
        }

        public String toString() {
            return this.text_;
        }

        @Override
        public boolean matches(String str) {
            return this.nameMatches(str) || this.textMatches(str);
        }

        public boolean nameMatches(String str) {
            return this.name().equalsIgnoreCase(str);
        }

        public boolean textMatches(String str) {
            return this.text_.equalsIgnoreCase(str);
        }
    }
}

