/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayFeatureTypeTrajectory;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCartesian;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereCAMSE;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatUgrid;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.plotui.table.PanArray1DTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArray2DAverageTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArray2DTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayCubedSphereCAMSETableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayCubedSphereGMAOTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayDataTable;
import gov.nasa.giss.panoply.plotui.table.PanArrayLLReducedTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayLonLatTrajectoryTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayLonLatUgridTableModel;
import gov.nasa.giss.panoply.plotui.table.PanArrayTableModel;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.StringComboBox;
import gov.nasa.giss.ui.label.VerticalLabel;
import gov.nasa.giss.ui.table.TableRowHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanArrayDataPanel
extends JPanel
implements PanDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotType ptype_;
    private final NcArray array_;
    private NcAxis xAxis_;
    private NcAxis yAxis_;
    private PanArrayDataTable table1_;
    private PanArrayDataTable table2_;
    private PanArrayTableModel tmodel1_;
    private PanArrayTableModel tmodel2_;
    private JScrollPane spane1_;
    private JScrollPane spane2_;
    private TableRowHeader table1RowHeader_;
    private JLabel[] sliceLabels_;
    private JLabel xAxisLabel_;
    private VerticalLabel yAxisLabel_;
    private StringComboBox valFormatCombo_;
    private StringComboBox hdrFormatCombo_;
    private boolean changeableHeaders_;
    private JCheckBox flipbtCB_;
    private JCheckBox fliplrCB_;
    private JCheckBox showIndicesCB_;

    public PanArrayDataPanel(PanPlotType type, PanData data, int vindex) {
        this.ptype_ = type;
        this.array_ = data.getArray(vindex);
        if (this.array_ == null) {
            throw new IllegalArgumentException("Array " + vindex + " is null");
        }
        if (this.array_ instanceof NcArray2D) {
            this.xAxis_ = ((NcArray2D)this.array_).getXAxis();
            this.yAxis_ = ((NcArray2D)this.array_).getYAxis();
        } else if (this.array_ instanceof NcArray1D) {
            this.yAxis_ = ((NcArray1D)this.array_).getAxis();
        } else if (!(this.array_ instanceof NcArrayLonLatUgrid || this.array_ instanceof NcArrayLonLatReduced || this.array_ instanceof NcArrayLonLatReduced2D || this.array_ instanceof NcArrayLonLatCubedSphereCAMSE || this.array_ instanceof NcArrayFeatureTypeTrajectory)) {
            LOGGER.debug("Not a recognized NcArray");
        }
        this.setLayout(new BorderLayout());
        this.setBorder(PanGuiUtils.STD_BORDER);
        this.setOpaque(false);
        JPanel topPanel = this.constructTopPanel();
        JPanel tablePanel = this.constructTablePanel();
        Box widgetPanel = this.constructWidgetPanel();
        this.add((Component)topPanel, "North");
        this.add((Component)tablePanel, "Center");
        this.add((Component)widgetPanel, "South");
        this.attachListeners();
        data.addDataListener(this);
    }

    private JPanel constructTopPanel() {
        NcDimension[] freeDims = this.array_.getFreeDimensions();
        int scount = freeDims.length;
        this.sliceLabels_ = new JLabel[scount];
        for (int i = 0; i < scount; ++i) {
            this.sliceLabels_[i] = freeDims[i] == null ? null : new JLabel("");
        }
        this.updateLabels();
        int rows = this.array_ instanceof NcArray1D ? Math.max(5, scount - 1) : Math.max(5, scount - 2);
        FlexingGridLayout fglTop = new FlexingGridLayout(2, rows, 2, 1);
        fglTop.setRigidWidth(false);
        fglTop.setRigidHeight(true);
        JPanel panel = new JPanel(fglTop);
        JLabel datasetLabel = new JLabel("Dataset:\u2009" + this.array_.getDataset().getName());
        StringBuilder sb = new StringBuilder("Variable:\u2009").append(this.array_.getShortName());
        if (this.array_.getLongName() != null) {
            sb.append(", ").append(this.array_.getLongName());
        }
        JLabel varLabel = new JLabel(sb.toString());
        panel.add((Component)datasetLabel, new FGConstraint(0, 0));
        panel.add((Component)varLabel, new FGConstraint(0, 1));
        String unitsStr = this.array_.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            JLabel unitsLabel = new JLabel("Units:\u2009" + unitsStr);
            panel.add((Component)unitsLabel, new FGConstraint(0, 2));
        }
        if (this.sliceLabels_ != null) {
            int row = 0;
            for (JLabel label : this.sliceLabels_) {
                if (label == null) continue;
                panel.add((Component)label, new FGConstraint(1, row));
                ++row;
            }
        }
        panel.setOpaque(false);
        return panel;
    }

    private JPanel constructTablePanel() {
        StringBuilder sb;
        String uu;
        String nn;
        if (this.array_ instanceof NcArray1D) {
            this.tmodel1_ = new PanArray1DTableModel((NcArray1D)this.array_, PanArray1DTableModel.Direction.VERTICAL);
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
            this.changeableHeaders_ = true;
        } else if (this.array_ instanceof NcArrayLonLatReduced || this.array_ instanceof NcArrayLonLatCubedSphereCAMSE || this.array_ instanceof NcArrayLonLatCubedSphereGMAO || this.array_ instanceof NcArray2D || this.array_ instanceof NcArrayLonLatUgrid || this.array_ instanceof NcArrayFeatureTypeTrajectory) {
            this.tmodel1_ = this.array_ instanceof NcArrayLonLatReduced ? new PanArrayLLReducedTableModel(this.array_) : (this.array_ instanceof NcArrayLonLatCubedSphereCAMSE ? new PanArrayCubedSphereCAMSETableModel(this.array_) : (this.array_ instanceof NcArrayLonLatCubedSphereGMAO ? new PanArrayCubedSphereGMAOTableModel((NcArrayLonLatCubedSphereGMAO)this.array_) : (this.array_ instanceof NcArray2D ? new PanArray2DTableModel((NcArray2D)this.array_) : (this.array_ instanceof NcArrayLonLatUgrid ? new PanArrayLonLatUgridTableModel(this.array_) : new PanArrayLonLatTrajectoryTableModel(this.array_)))));
            this.table1_ = new PanArrayDataTable(this.tmodel1_);
            this.table1RowHeader_ = new TableRowHeader((JTable)this.table1_, this.getRowHeaders(this.tmodel1_));
            if (this.array_ instanceof NcArray2D) {
                if (this.array_ instanceof NcArrayLonLatCartesian) {
                    this.tmodel2_ = new PanArray2DAverageTableModel((NcArray2D)this.array_);
                    this.table2_ = new PanArrayDataTable(this.tmodel2_);
                }
                this.changeableHeaders_ = true;
            } else if (this.array_ instanceof NcArrayLonLatUgrid || this.array_ instanceof NcArrayFeatureTypeTrajectory) {
                for (int i = 0; i < this.tmodel1_.getColumnCount(); ++i) {
                    TableColumnModel tcm = this.table1_.getColumnModel();
                    TableColumn column = tcm.getColumn(i);
                    TableCellRenderer tcr = this.table1_.getCellRenderer(0, i);
                    Object value = this.table1_.getValueAt(0, i);
                    Component c = tcr.getTableCellRendererComponent(this.table1_, value, false, false, 0, i);
                    int ww = c.getPreferredSize().width + 24;
                    column.setPreferredWidth(ww);
                }
            }
        } else {
            LOGGER.debug("Apaprently I don't know how to create a table model for this array type.");
        }
        this.spane1_ = new JScrollPane(this.table1_);
        if (this.table1RowHeader_ != null) {
            this.spane1_.setRowHeaderView(this.table1RowHeader_);
        }
        this.spane2_ = null;
        if (this.table2_ != null) {
            this.spane2_ = new JScrollPane(this.table2_);
            this.spane2_.setVerticalScrollBarPolicy(this.spane1_.getVerticalScrollBarPolicy());
            JScrollBar vbar = this.spane1_.getVerticalScrollBar();
            this.spane2_.setVerticalScrollBar(vbar);
            this.spane2_.updateUI();
            this.spane1_.updateUI();
            int xWidth = this.spane2_.getInsets().left + this.table2_.getPreferredSize().width + vbar.getPreferredSize().width + this.spane2_.getInsets().right;
            this.spane2_.setPreferredSize(new Dimension(xWidth, this.spane2_.getPreferredSize().height));
            this.spane2_.setMaximumSize(new Dimension(xWidth, this.spane2_.getMaximumSize().height));
            this.spane2_.setMinimumSize(new Dimension(xWidth, this.spane2_.getMinimumSize().height));
        }
        FlexingGridLayout fglbottom = new FlexingGridLayout(3, 3, 2, 2);
        fglbottom.setColumnWeight(1, 9999.0f);
        fglbottom.setRowWeight(1, 9999.0f);
        JPanel panel = new JPanel(fglbottom);
        panel.setOpaque(false);
        if (this.xAxis_ != null) {
            nn = this.xAxis_.getLongName();
            uu = this.xAxis_.getUnitsStr();
            sb = new StringBuilder("X Axis");
            if (nn != null && !nn.isEmpty() || uu != null && !uu.isEmpty()) {
                sb.append(':');
                if (nn != null && !nn.isEmpty()) {
                    sb.append(' ').append(nn);
                }
                if (uu != null && !uu.isEmpty()) {
                    sb.append(" (").append(uu).append(')');
                }
            }
            this.xAxisLabel_ = new JLabel(sb.toString());
            panel.add((Component)this.xAxisLabel_, new FGConstraint(0, 0, 3, 1, 0.5, 0.5));
        }
        if (this.yAxis_ != null) {
            nn = this.yAxis_.getLongName();
            uu = this.yAxis_.getUnitsStr();
            sb = new StringBuilder("");
            if (this.ptype_ == PanPlotType.HORZ_LINE) {
                sb.append('X');
            } else {
                sb.append('Y');
            }
            sb.append(" Axis");
            if (nn != null && !nn.isEmpty() || uu != null && !uu.isEmpty()) {
                sb.append(':');
                if (nn != null && !nn.isEmpty()) {
                    sb.append(' ').append(nn);
                }
                if (uu != null && !uu.isEmpty()) {
                    sb.append(" (").append(uu).append(')');
                }
            }
            this.yAxisLabel_ = new VerticalLabel(sb.toString());
            panel.add((Component)this.yAxisLabel_, new FGConstraint(0, 1));
        }
        if (this.table2_ != null) {
            panel.add((Component)this.spane1_, new FGConstraint(1, 1, 1, 1, true));
            panel.add((Component)this.spane2_, new FGConstraint(2, 1, 1, 1, true));
        } else {
            panel.add((Component)this.spane1_, new FGConstraint(1, 1, 2, 1, 1.0, 1.0, true));
        }
        return panel;
    }

    private Box constructWidgetPanel() {
        String headerFormat = this.array_ instanceof NcArray1D ? "%.4f" : "%.7G";
        String pfFormat = PanPreferences.getSharedInstance().getString("plot:scale.tick.format");
        this.valFormatCombo_ = StringComboBox.createNumberPformat();
        this.hdrFormatCombo_ = StringComboBox.createNumberPformat();
        this.valFormatCombo_.setSelectedItem(pfFormat);
        this.valFormatCombo_.setMaximumSize(this.valFormatCombo_.getPreferredSize());
        this.hdrFormatCombo_.setSelectedItem(headerFormat);
        this.hdrFormatCombo_.setMaximumSize(this.hdrFormatCombo_.getPreferredSize());
        this.hdrFormatCombo_.setEnabled(this.changeableHeaders_);
        if (this.table1_ != null) {
            PrintfFormat formatter = new PrintfFormat(pfFormat);
            this.table1_.setDataFormatter(formatter);
            this.table1_.setHeaderFormatter(new PrintfFormat(headerFormat));
            if (this.table2_ != null) {
                this.table2_.setDataFormatter(formatter);
            }
        }
        GuiUtils.applyComboBoxUI(this.valFormatCombo_);
        GuiUtils.applyComboBoxUI(this.hdrFormatCombo_);
        this.flipbtCB_ = new JCheckBox("Flip table B/T");
        this.fliplrCB_ = new JCheckBox("Flip table L/R");
        this.showIndicesCB_ = new JCheckBox("Show cell indices");
        this.fliplrCB_.setEnabled(this.tmodel1_.canFlipLR());
        this.showIndicesCB_.setEnabled(this.tmodel1_.canFlipLR());
        QuickBox formatBox = QuickBox.createCenterBox(new JLabel("Data Format:\u2009"), this.valFormatCombo_, Box.createHorizontalGlue(), new JLabel(" \u2014 "), Box.createHorizontalGlue(), this.flipbtCB_, Box.createHorizontalGlue(), new JLabel(" \u2014 "), Box.createHorizontalGlue(), this.fliplrCB_, Box.createHorizontalGlue(), new JLabel(" \u2014 "), Box.createHorizontalGlue(), this.showIndicesCB_, Box.createHorizontalGlue(), new JLabel(" \u2014 "), Box.createHorizontalGlue(), new JLabel("Row/Col Header Format:\u2009"), this.hdrFormatCombo_);
        GuiUtils.setSizeSmall(formatBox);
        return formatBox;
    }

    private void attachListeners() {
        this.valFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PrintfFormat formatter = new PrintfFormat(this.valFormatCombo_.getSelectedString());
            if (this.table1_ != null) {
                this.table1_.setDataFormatter(formatter);
            }
            if (this.table2_ != null) {
                this.table2_.setDataFormatter(formatter);
            }
        });
        this.hdrFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PrintfFormat formatter = new PrintfFormat(this.hdrFormatCombo_.getSelectedString());
            if (this.table1_ != null) {
                this.table1_.setHeaderFormatter(formatter);
            }
            if (this.table1RowHeader_ != null) {
                this.table1RowHeader_.setValues(this.getRowHeaders(this.tmodel1_));
            }
        });
        this.flipbtCB_.addItemListener(e -> {
            boolean flipBT = this.flipbtCB_.isSelected();
            if (this.tmodel1_ != null) {
                this.tmodel1_.setFlipBT(flipBT);
            }
            if (this.tmodel2_ != null) {
                this.tmodel2_.setFlipBT(flipBT);
            }
            if (this.table1RowHeader_ != null) {
                this.table1RowHeader_.setValues(this.getRowHeaders(this.tmodel1_));
            }
        });
        this.fliplrCB_.addItemListener(e -> {
            boolean flipLR = this.fliplrCB_.isSelected();
            if (this.tmodel1_ != null) {
                this.tmodel1_.setFlipLR(flipLR);
            }
            if (this.tmodel2_ != null) {
                this.tmodel2_.setFlipLR(flipLR);
            }
        });
        this.showIndicesCB_.addItemListener(e -> {
            boolean showIdx = this.showIndicesCB_.isSelected();
            if (this.tmodel1_ != null) {
                this.tmodel1_.setShowCellIndices(showIdx);
            }
            if (this.tmodel2_ != null) {
                this.tmodel2_.setShowCellIndices(showIdx);
            }
            if (this.table1RowHeader_ != null) {
                this.table1RowHeader_.setValues(this.getRowHeaders(this.tmodel1_));
            }
            if (showIdx) {
                this.hdrFormatCombo_.setEnabled(false);
                if (this.xAxis_ != null) {
                    this.xAxisLabel_.setText("X Axis:\u2009" + this.xAxis_.getLongName() + " - Cell Index");
                }
                if (this.yAxis_ != null) {
                    StringBuilder sb = new StringBuilder("");
                    if (this.ptype_ == PanPlotType.HORZ_LINE) {
                        sb.append('X');
                    } else {
                        sb.append('Y');
                    }
                    sb.append(" Axis:\u2009").append(this.yAxis_.getLongName()).append(" - Cell Index");
                    this.yAxisLabel_.setText(sb.toString());
                }
            } else {
                this.hdrFormatCombo_.setEnabled(this.changeableHeaders_);
                if (this.xAxis_ != null) {
                    String ustr = this.xAxis_.getUnitsStr();
                    StringBuilder sb = new StringBuilder("X Axis:\u2009").append(this.xAxis_.getLongName());
                    if (ustr != null && !ustr.isEmpty()) {
                        sb.append(" (").append(ustr).append(')');
                    }
                    this.xAxisLabel_.setText(sb.toString());
                }
                if (this.yAxis_ != null) {
                    StringBuilder sb = new StringBuilder();
                    if (this.ptype_ == PanPlotType.HORZ_LINE) {
                        sb.append('X');
                    } else {
                        sb.append('Y');
                    }
                    sb.append(" Axis:\u2009").append(this.yAxis_.getLongName());
                    String ustr = this.yAxis_.getUnitsStr();
                    if (ustr != null && !ustr.isEmpty()) {
                        sb.append(" (").append(ustr).append(')');
                    }
                    this.yAxisLabel_.setText(sb.toString());
                }
            }
            this.invalidate();
            this.validate();
        });
    }

    public void refresh() {
        if (this.spane2_ != null) {
            if (this.spane1_.getHorizontalScrollBar().isVisible()) {
                this.spane2_.setHorizontalScrollBarPolicy(32);
            } else {
                this.spane2_.setHorizontalScrollBarPolicy(31);
            }
        }
        if (this.table1_ != null) {
            this.table1_.repaint();
        }
        if (this.table2_ != null) {
            this.table2_.repaint();
        }
    }

    private String[] getRowHeaders(PanArrayTableModel model) {
        int irows = model.getRowCount();
        String[] headers = new String[irows];
        for (int j = 0; j < irows; ++j) {
            headers[j] = model.getRowName(j);
        }
        return headers;
    }

    public final void updateLabels() {
        NcDimension[] freeDims = this.array_.getFreeDimensions();
        for (int i = 0; i < freeDims.length; ++i) {
            if (this.sliceLabels_[i] == null) continue;
            int numIndices = freeDims[i].getLength();
            int index = this.array_.getSliceIndex(i);
            if (index > numIndices) {
                this.sliceLabels_[i].setText("Zonal Average");
            } else {
                StringBuilder sb = new StringBuilder("Slice:\u2009").append(freeDims[i].getLongName()).append(' ');
                if (index == -1) {
                    sb.append(", Average over ").append(numIndices).append(" indices in dimension");
                } else if (index < numIndices) {
                    sb.append('[').append(index + 1).append(" of ").append(numIndices).append("] = ");
                    if (freeDims[i].hasBounds()) {
                        sb.append(freeDims[i].formattedBoundsAt(index));
                    } else {
                        sb.append(freeDims[i].formattedValueAt(index));
                    }
                    String us = freeDims[i].getUnitsStr();
                    if (us != null && us.length() > 0) {
                        sb.append(' ').append(us);
                    }
                } else {
                    LOGGER.warn("Weird value for 'index'");
                }
                this.sliceLabels_[i].setText(sb.toString() + "  ");
            }
            this.sliceLabels_[i].repaint();
        }
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        if (e == null) {
            LOGGER.trace("null PanDataEvent");
            return;
        }
        LOGGER.trace("{}", (Object)e);
        EventQueue.invokeLater(() -> {
            this.updateLabels();
            this.refresh();
        });
        LOGGER.trace("done");
    }
}

