/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.action.PanPlotZoomResetAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanCommonXAxisControls;
import gov.nasa.giss.panoply.plotui.PanCommonYAxisControls;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.plotui.PanScaleControls1D;
import gov.nasa.giss.panoply.plotui.PanZoomableAxisControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.panel.PanelSection;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanGridControls1D
extends PanGridControls {
    private DescribedEnumComboBox gridStyleCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanIntSpinner tickWeightSpinner_;
    private PanZoomableAxisControls xaxisControls_;
    private PanZoomableAxisControls yaxisControls_;
    private PanScaleControls1D scaleControls_;
    private boolean refreshing_;

    public PanGridControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout(mbar);
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        AbstractAction a = new PanPlotZoomResetAction(this);
        this.pmeta_.putAction("reset-bounds", a);
        plotMenu.getItemForName("reset-bounds").setAction(a);
        a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemForName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemForName("zoom-plot-out").setAction(a);
    }

    private void createLayout(PanMenuBar mbar) {
        JPanel topBox = this.createTopBox();
        this.scaleControls_ = new PanScaleControls1D(this.pmeta_, mbar);
        this.setLayout(new BoxLayout(this, 1));
        this.add(topBox);
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_.isLonLatZonal()) {
            this.xaxisControls_ = new PanCommonXAxisControls(this.pmeta_, mbar);
            PanelSection xws = new PanelSection("X Axis", this.xaxisControls_);
            PanelSection yws = new PanelSection("Y Axis / Scale", this.scaleControls_);
            this.add(xws);
            this.add(yws);
        } else {
            this.yaxisControls_ = new PanCommonYAxisControls(this.pmeta_, mbar);
            PanelSection xws = new PanelSection("X Axis / Scale", this.scaleControls_);
            PanelSection yws = new PanelSection("Y Axis", this.yaxisControls_);
            this.add(xws);
            this.add(yws);
        }
    }

    private JPanel createTopBox() {
        JLabel label11 = new JLabel("Stroke:\u2009");
        this.gridStyleCombo_ = new DescribedEnumComboBox(PanStrokePattern.class);
        this.gridStyleCombo_.setName("grid.style");
        this.gridStyleCombo_.setSelItemMatching(this.pmeta_.getString("grid.style"));
        JLabel gWeightLabel = new JLabel("\u2014 Weight:\u2009");
        this.gridWeightSpinner_ = PanIntSpinner.smallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 0, 200);
        JLabel gPctLabel = new JLabel("%");
        QuickBox line1 = QuickBox.createLeftBox(label11, this.gridStyleCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel);
        JLabel label21 = new JLabel(" ");
        this.axesOffsetCB_ = PanCheckBox.small("axes.offset", "Offset axes from grid edges", this.pmeta_.getBoolean("axes.offset"));
        QuickBox line2 = QuickBox.createLeftBox(label21, this.axesOffsetCB_);
        JLabel label31 = new JLabel("Ticks: ");
        JLabel aWeightLabel = new JLabel("Weight:\u2009");
        this.tickWeightSpinner_ = PanIntSpinner.smallWeight("axes.tickmark.weight", this.pmeta_.getInt("axes.tickmark.weight"), 25, 200);
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        JLabel aPctLabel = new JLabel("%");
        QuickBox line3 = QuickBox.createLeftBox(label31, aWeightLabel, this.tickWeightSpinner_, aPctLabel);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        jp.setOpaque(false);
        jp.add(line1);
        jp.add(Box.createVerticalStrut(1));
        jp.add(line2);
        jp.add(Box.createVerticalStrut(1));
        jp.add(line3);
        GuiUtils.setSizeSmall(jp);
        GuiUtils.matchLabelWidths(label11, label21, label31);
        return jp;
    }

    private void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getEnumName());
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.axesOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean checked = this.axesOffsetCB_.isSelected();
            this.pmeta_.setBoolean("axes.offset", checked);
            this.tickWeightSpinner_.setEnabled(!checked);
        });
        this.tickWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("axes.tickmark.weight", this.tickWeightSpinner_.getIntValue());
        });
    }

    @Override
    public void refreshZoomEnabling() {
    }

    @Override
    public void recenter(double x, double y) {
        this.zoom(1.0, x, y);
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double centerx, double centery) {
        this.zoom(1.5, centerx, centery);
    }

    @Override
    public void zoomOut(double centerx, double centery) {
        this.zoom(0.6666666666666666, centerx, centery);
    }

    @Override
    public void zoom(double factor) {
        if (this.xaxisControls_ != null) {
            this.xaxisControls_.zoom(factor);
        } else if (this.yaxisControls_ != null) {
            this.yaxisControls_.zoom(factor);
        }
        this.scaleControls_.zoom(factor);
    }

    @Override
    public void zoom(double factor, double centerx, double centery) {
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_.isLonLatZonal()) {
            this.xaxisControls_.zoom(factor, centerx);
            this.scaleControls_.zoom(factor, centery);
        } else {
            this.scaleControls_.zoom(factor, centerx);
            this.yaxisControls_.zoom(factor, centery);
        }
    }

    @Override
    public void dragZoom(double centerx, double centery, double leftx, double topy, double rightx, double bottomy) {
        if (this.ptype_ == PanPlotType.HORZ_LINE || this.ptype_.isLonLatZonal()) {
            this.xaxisControls_.setAxisBounds(leftx, rightx);
            this.scaleControls_.setScaleRange(bottomy, topy);
        } else {
            this.scaleControls_.setScaleRange(leftx, rightx);
            this.yaxisControls_.setAxisBounds(bottomy, topy);
        }
    }

    @Override
    public void resetGridBounds() {
        if (this.xaxisControls_ != null) {
            this.xaxisControls_.resetAxisBounds();
        } else if (this.yaxisControls_ != null) {
            this.yaxisControls_.resetAxisBounds();
        }
        this.pmeta_.getAction("fit-scale-to-data").actionPerformed(null);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelItemMatching(this.pmeta_.getString("grid.style"));
        this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        this.axesOffsetCB_.setSelected(this.pmeta_.getBoolean("axes.offset"));
        this.tickWeightSpinner_.setValue(this.pmeta_.getInt("axes.tickmark.weight"));
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        this.refreshing_ = false;
    }
}

