/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.action.PanChangePlotControlsAction;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.ArrowButton;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotUnifiedPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotFrame pframe_;
    private Hashtable<PanPlotControlsID, PanControlsPanel> cPanels_;
    private PanPlotControlsID activeCID_ = PanPlotControlsID.ARRAYS;
    private DescribedEnumComboBox cidCombo_;
    private JPanel topPanel_;
    private JPanel bottomPanel_;

    public PanPlotUnifiedPanel(PanPlotFrame pframe, Hashtable<PanPlotControlsID, PanControlsPanel> cPanels) {
        this.pframe_ = pframe;
        this.cPanels_ = cPanels;
        this.createLayout();
        this.addListeners();
    }

    private void createLayout() {
        this.cidCombo_ = new DescribedEnumComboBox(PanPlotControlsID.class);
        int icount = this.cidCombo_.getItemCount();
        for (int i = icount - 1; i >= 0; --i) {
            PanPlotControlsID xid = (PanPlotControlsID)this.cidCombo_.getItemAt(i);
            PanControlsPanel panel = this.cPanels_.get(xid);
            if (panel != null) continue;
            this.cidCombo_.removeItemAt(i);
        }
        PanChangePlotControlsAction aan = new PanChangePlotControlsAction(this.pframe_, PanProperties.MENU_PROPS.getString("show-next-plot-controls"), true);
        PanChangePlotControlsAction aap = new PanChangePlotControlsAction(this.pframe_, PanProperties.MENU_PROPS.getString("show-prev-plot-controls"), false);
        GissMenu viewMenu = this.pframe_.getPanMenuBar().getMenuForName("view-menu");
        viewMenu.getItemForName("show-next-plot-controls").setAction(aan);
        viewMenu.getItemForName("show-prev-plot-controls").setAction(aap);
        aan.setEnabled(true);
        aap.setEnabled(true);
        ArrowButton nextBtn = new ArrowButton(ArrowButton.Direction.EAST, "show-next-plot-controls", aan);
        ArrowButton prevBtn = new ArrowButton(ArrowButton.Direction.WEST, "show-prev-plot-controls", aap);
        QuickBox topBox = QuickBox.createLeftBox(new JLabel("Show: "), this.cidCombo_, new JLabel(" "), prevBtn, nextBtn);
        topBox.setOpaque(false);
        this.topPanel_ = new JPanel();
        this.topPanel_.setOpaque(false);
        FlexingGridLayout fgl1 = new FlexingGridLayout(2, 1, 0, 0);
        this.topPanel_.setLayout(fgl1);
        fgl1.setColumnWeight(1, 9999.0f);
        this.topPanel_.add((Component)topBox, new FGConstraint(0, 0));
        GuiUtils.setSizeSmall(this.topPanel_);
        this.topPanel_.setMaximumSize(null);
        Color darkColor = new Color(86, 86, 86);
        Color lightColor = new Color(255, 255, 255, 153);
        MatteBorder bottom1 = BorderFactory.createMatteBorder(0, 0, 1, 0, darkColor);
        MatteBorder bottom2 = BorderFactory.createMatteBorder(0, 0, 1, 0, lightColor);
        CompoundBorder groove = BorderFactory.createCompoundBorder(bottom2, bottom1);
        Border space = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.topPanel_.setBorder(BorderFactory.createCompoundBorder(groove, space));
        this.bottomPanel_ = new JPanel();
        this.bottomPanel_.setOpaque(false);
        FlexingGridLayout fgl2 = new FlexingGridLayout(2, 2, 0, 0);
        this.bottomPanel_.setLayout(fgl2);
        fgl2.setColumnWeight(1, 9999.0f);
        fgl2.setRowWeight(1, 9999.0f);
        PanControlsPanel cpanel = this.cPanels_.get(this.activeCID_);
        this.bottomPanel_.add((Component)cpanel, new FGConstraint(0, 0));
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.add(this.topPanel_);
        this.add(Box.createVerticalStrut(4));
        this.add(this.bottomPanel_);
        this.setActiveControls(PanPlotControlsID.ARRAYS);
    }

    private void addListeners() {
        this.cidCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanPlotControlsID cid = (PanPlotControlsID)this.cidCombo_.getSelectedItem();
            this.setActiveControls(cid);
        });
    }

    public void setActiveControls(PanPlotControlsID cid) {
        if (this.bottomPanel_ == null) {
            LOGGER.error("Bottom panel is null!");
            return;
        }
        PanControlsPanel cpanel = this.cPanels_.get(cid);
        if (cpanel == null) {
            LOGGER.error("No panel matches ID {}!", (Object)cid);
            return;
        }
        this.activeCID_ = cid;
        this.bottomPanel_.removeAll();
        this.bottomPanel_.add((Component)cpanel, new FGConstraint(0, 0));
        this.bottomPanel_.invalidate();
        cpanel.setPreferredSize(null);
        this.bottomPanel_.setPreferredSize(null);
        Dimension tsize = this.topPanel_.getPreferredSize();
        Dimension bsize = this.bottomPanel_.getPreferredSize();
        Dimension upref = new Dimension(Math.max(tsize.width, bsize.width), tsize.height + 4 + bsize.height);
        this.setMinimumSize(upref);
        this.setPreferredSize(upref);
        cpanel.setMinimumSize(cpanel.getPreferredSize());
        this.bottomPanel_.setMinimumSize(cpanel.getPreferredSize());
        Container parent = this.getParent();
        if (parent != null) {
            parent.setPreferredSize(null);
            parent.setSize(parent.getPreferredSize());
            parent.revalidate();
            parent.repaint();
        } else {
            this.revalidate();
        }
    }

    public void next() {
        int nextIdx = this.cidCombo_.getSelectedIndex() + 1;
        if (nextIdx >= this.cidCombo_.getItemCount()) {
            nextIdx = 0;
        }
        PanPlotControlsID nextCID = (PanPlotControlsID)this.cidCombo_.getItemAt(nextIdx);
        this.cidCombo_.setSelectedItem(nextCID);
    }

    public void previous() {
        int prevIdx = this.cidCombo_.getSelectedIndex() - 1;
        if (prevIdx < 0) {
            prevIdx = this.cidCombo_.getItemCount() - 1;
        }
        PanPlotControlsID prevCID = (PanPlotControlsID)this.cidCombo_.getItemAt(prevIdx);
        this.cidCombo_.setSelectedItem(prevCID);
    }
}

