/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanFitScaleToDataAction;
import gov.nasa.giss.panoply.action.PanLogScaleAction;
import gov.nasa.giss.panoply.action.PanToggleAutoscaleAction;
import gov.nasa.giss.panoply.action.PanZeroCenterScaleAction;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanScaleMethodComboBox;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GEditableComboBox;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.ui.StringComboBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanScaleControls
extends PanControlsPanel
implements PanDataListener,
PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected GTextField val1TF_;
    protected GTextField val2TF_;
    protected PanScaleMethodComboBox methodCombo_;
    protected PanButton fitToDataBtn_;
    protected GTextField coeffTF_;
    protected PanIntSpinner expSpinner_;
    protected GEditableComboBox unitsCombo_;
    protected PanIntSpinner majorDivSpinner_;
    protected PanIntSpinner minorDivSpinner_;
    protected StringComboBox tickFormatCombo_;
    protected FloatComboBox tickSizeCombo_;
    protected JRadioButton dfltCapBtn_;
    protected JRadioButton customCapBtn_;
    protected GTextField captionTF_;
    protected FloatComboBox captionSizeCombo_;
    private boolean refreshing_;

    public PanScaleControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("scale-controls", pmeta, mbar);
        this.createCommonActions(mbar);
        this.createCommonComponents();
        this.refreshPrivate();
        this.attachCommonListeners();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private void createCommonActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        PanToggleAutoscaleAction autoScaleAction = new PanToggleAutoscaleAction(this.pmeta_);
        PanFitScaleToDataAction fitScaleToDataAction = new PanFitScaleToDataAction(this.pmeta_, this);
        PanZeroCenterScaleAction zeroScaleAction = new PanZeroCenterScaleAction(this.pmeta_, this);
        PanLogScaleAction logScaleAction = new PanLogScaleAction(this.pmeta_);
        plotMenu.getItemForName("autofit-scale").setAction(autoScaleAction);
        plotMenu.getItemForName("fit-scale-to-data").setAction(fitScaleToDataAction);
        plotMenu.getItemForName("center-on-zero").setAction(zeroScaleAction);
        plotMenu.getItemForName("log-scale").setAction(logScaleAction);
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        boolean islog10 = smethod == PanScaleMethod.LOG10;
        plotMenu.getItemForName("autofit-scale").setSelected(this.pmeta_.getBoolean("scale.autofit"));
        plotMenu.getItemForName("log-scale").setSelected(islog10);
        this.pmeta_.putAction("autofit-scale", autoScaleAction);
        this.pmeta_.putAction("fit-scale-to-data", fitScaleToDataAction);
        this.pmeta_.putAction("center-on-zero", zeroScaleAction);
        this.pmeta_.putAction("log-scale", logScaleAction);
        plotMenu.getItemForName("autofit-scale").setEnabled(true);
        plotMenu.getItemForName("fit-scale-to-data").setEnabled(true);
        plotMenu.getItemForName("log-scale").setEnabled(true);
        plotMenu.getItemForName("center-on-zero").setEnabled(true);
    }

    private void createCommonComponents() {
        double min = this.pmeta_.getDouble("scale.min");
        double max = this.pmeta_.getDouble("scale.max");
        if (Double.isNaN(min)) {
            min = -0.1;
            max = 0.1;
        }
        this.val1TF_ = GTextField.create(this.tinyNumberFormat(min), 9);
        this.val2TF_ = GTextField.create(this.tinyNumberFormat(max), 9);
        this.val1TF_.setName("scale.min");
        this.val2TF_.setName("scale.max");
        this.val1TF_.setHorizontalAlignment(4);
        this.val2TF_.setHorizontalAlignment(4);
        this.fitToDataBtn_ = PanButton.small(this.pmeta_.getAction("fit-scale-to-data"), "Fit to Data");
        this.methodCombo_ = PanScaleMethodComboBox.small("scale.method");
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        this.methodCombo_.setSelectedItem(smethod);
        this.dfltCapBtn_ = new JRadioButton("Default", !this.pmeta_.getBoolean("scale.label.custom"));
        this.customCapBtn_ = new JRadioButton("Custom:", this.pmeta_.getBoolean("scale.label.custom"));
        this.dfltCapBtn_.setName("scale.label.custom");
        this.customCapBtn_.setName("scale.label.custom");
        this.captionTF_ = GTextField.create(this.pmeta_.getString("scale.label.text"), 20);
        this.captionSizeCombo_ = FloatComboBox.create(5.0f, 32.0f);
        this.captionTF_.setName("scale.label.text");
        this.captionSizeCombo_.setName("scale.label.size");
        this.captionSizeCombo_.setValue(this.pmeta_.getFloat("scale.label.size"));
        ButtonGroup scaleChoices = new ButtonGroup();
        scaleChoices.add(this.dfltCapBtn_);
        scaleChoices.add(this.customCapBtn_);
        this.unitsCombo_ = new GEditableComboBox(SizeVariant.SMALL, this.data_.getUnitsChoices());
        this.unitsCombo_.setName("scale.units");
        this.unitsCombo_.setPreferredSize(null);
        Dimension ucsize = this.unitsCombo_.getPreferredSize();
        ucsize.width = Math.max(108, ucsize.width);
        this.unitsCombo_.setPreferredSize(ucsize);
        this.unitsCombo_.setSelectedIndex(0);
        this.unitsCombo_.setMaximumSize(this.unitsCombo_.getPreferredSize());
        this.coeffTF_ = GTextField.createDoubleField(this.pmeta_.getDouble("scale.coefficient"), 4);
        this.coeffTF_.setName("scale.coefficient");
        this.expSpinner_ = PanIntSpinner.small("scale.exponent", this.pmeta_.getInt("scale.exponent"), -50, 50, 1);
        this.majorDivSpinner_ = PanIntSpinner.small("scale.div.major", this.pmeta_.getInt("scale.div.major"), 1, 20, 1);
        this.minorDivSpinner_ = PanIntSpinner.small("scale.div.minor", this.pmeta_.getInt("scale.div.minor"), 1, 20, 1);
        this.majorDivSpinner_.setName("scale.div.major");
        this.minorDivSpinner_.setName("scale.div.minor");
        this.tickFormatCombo_ = StringComboBox.createNumberPformat();
        this.tickFormatCombo_.setSelectedItem(this.pmeta_.getString("scale.tick.format"));
        this.tickFormatCombo_.setMaximumRowCount(32);
        this.tickSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.tickSizeCombo_.setName("scale.tick.size");
        this.tickSizeCombo_.setValue(this.pmeta_.getFloat("scale.tick.size"));
    }

    private void attachCommonListeners() {
        this.methodCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("scale.method", (Object)this.methodCombo_.getStringValue());
        });
        FocusAdapter rangeFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanScaleControls.this.validateRange();
            }
        };
        this.val1TF_.addFocusListener(rangeFL);
        this.val2TF_.addFocusListener(rangeFL);
        this.val1TF_.addActionListener(e -> this.validateRange());
        this.val2TF_.addActionListener(e -> this.validateRange());
        this.unitsCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            String unitsStr = this.unitsCombo_.getSelectedItem().toString();
            this.pmeta_.setString("scale.units", unitsStr);
        });
        FocusAdapter coeffFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanScaleControls.this.validateCoeff();
            }
        };
        this.coeffTF_.addFocusListener(coeffFL);
        this.coeffTF_.addActionListener(e -> this.validateCoeff());
        this.expSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("scale.exponent", this.expSpinner_.getIntValue());
        });
        this.majorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("scale.div.major", this.majorDivSpinner_.getIntValue());
        });
        this.minorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("scale.div.minor", this.minorDivSpinner_.getIntValue());
        });
        this.tickFormatCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            String format = this.tickFormatCombo_.getSelectedString();
            this.pmeta_.setString("scale.tick.format", format);
            this.data_.setScaleFormat(format);
        });
        this.tickSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            float value = this.tickSizeCombo_.getValue();
            this.pmeta_.setFloat("scale.tick.size", value);
        });
        this.dfltCapBtn_.addActionListener(e -> this.pmeta_.setBoolean("scale.label.custom", !this.dfltCapBtn_.isSelected()));
        this.customCapBtn_.addActionListener(e -> this.pmeta_.setBoolean("scale.label.custom", this.customCapBtn_.isSelected()));
        this.captionTF_.getDocument().addDocumentListener(new PanCaptionListener(this.captionTF_, this.pmeta_, "scale.label.text"));
        if (this.captionSizeCombo_ != null) {
            this.captionSizeCombo_.addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                float value = this.captionSizeCombo_.getValue();
                this.pmeta_.setFloat("scale.label.size", value);
            });
        }
    }

    public void setScaleRange(double val1, double val2) {
        LOGGER.trace("{}, {}", (Object)val1, (Object)val2);
        if (!Double.isNaN(val1) && !Double.isNaN(val1)) {
            this.val1TF_.setText(this.tinyNumberFormat(val1));
            this.val2TF_.setText(this.tinyNumberFormat(val2));
        }
        this.validateRange();
    }

    public void setScaleLogarithmicXXX(boolean islog10) {
        if (islog10) {
            this.methodCombo_.setSelectedItem(PanScaleMethod.LOG10);
        } else {
            this.methodCombo_.setSelectedItem(PanScaleMethod.SCALAR);
        }
        if (islog10) {
            this.validateRange();
        }
    }

    private synchronized void validateCoeff() {
        double oldcoeff;
        if (this.coeffTF_ == null || this.pmeta_ == null) {
            return;
        }
        double coeff = oldcoeff = this.pmeta_.getDouble("scale.coefficient");
        boolean fixit = false;
        try {
            coeff = StringUtils.parseDouble(this.coeffTF_.getText());
        }
        catch (Exception exc) {
            coeff = oldcoeff;
            fixit = true;
        }
        if (Double.isNaN(coeff) || Math.abs(coeff) == 0.0) {
            coeff = 1.0;
            fixit = true;
        } else if (Math.abs(coeff) > 1000.0) {
            coeff = 1000.0 * Math.signum(coeff);
            fixit = true;
        }
        if (fixit) {
            PrintfFormat pformat = new PrintfFormat("%.0f");
            this.coeffTF_.setText(pformat.sprintfx(coeff));
        }
        this.pmeta_.setDouble("scale.coefficient", coeff);
    }

    private synchronized void validateRange() {
        if (this.val1TF_ == null || this.val2TF_ == null || this.pmeta_ == null) {
            return;
        }
        if (this.pmeta_.getBoolean("scale.autofit")) {
            return;
        }
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double val1 = oldval1;
        double val2 = oldval2;
        try {
            val1 = StringUtils.parseDouble(this.val1TF_.getText());
        }
        catch (Exception exc) {
            val1 = this.pmeta_.getDouble("scale.min");
            if (Double.isNaN(val1)) {
                val1 = -0.1;
            }
            this.val1TF_.setText(this.tinyNumberFormat(val1));
        }
        try {
            val2 = StringUtils.parseDouble(this.val2TF_.getText());
        }
        catch (Exception exc) {
            val2 = this.pmeta_.getDouble("scale.max");
            if (Double.isNaN(val2)) {
                val2 = -0.1;
            }
            this.val2TF_.setText(this.tinyNumberFormat(val2));
        }
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                if (val1 <= 0.0) {
                    double fval1 = val1 = 1.0E-50;
                    EventQueue.invokeLater(() -> this.val1TF_.setText(this.tinyNumberFormat(fval1)));
                }
                if (!(val2 <= 1.0E-50)) break;
                double fval2 = val2 = 1.0E-25;
                EventQueue.invokeLater(() -> this.val2TF_.setText(this.tinyNumberFormat(fval2)));
                break;
            }
        }
        if (val1 == oldval1 && val2 == oldval2) {
            LOGGER.trace("no change");
            return;
        }
        this.pmeta_.setGroup({"scale.min", val1}, {"scale.max", val2});
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        boolean logScaleOn;
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        boolean autoScaleOn = this.pmeta_.getBoolean("scale.autofit");
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        boolean bl = logScaleOn = smethod == PanScaleMethod.LOG10 || smethod == PanScaleMethod.LOG_E;
        if (logScaleOn) {
            this.validateRange();
        }
        this.val1TF_.setEnabled(!autoScaleOn);
        this.val2TF_.setEnabled(!autoScaleOn);
        if (this.val1TF_.isEnabled()) {
            double val1 = this.pmeta_.getDouble("scale.min");
            double val2 = this.pmeta_.getDouble("scale.max");
            this.val1TF_.setText(this.tinyNumberFormat(val1));
            this.val2TF_.setText(this.tinyNumberFormat(val2));
        }
        this.majorDivSpinner_.setEnabled(!logScaleOn);
        this.minorDivSpinner_.setEnabled(!logScaleOn);
        this.pmeta_.getAction("fit-scale-to-data").setEnabled(!autoScaleOn);
        this.pmeta_.getAction("center-on-zero").setEnabled(!autoScaleOn && !logScaleOn);
        this.refreshing_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanScaleControls panScaleControls = this;
        synchronized (panScaleControls) {
            if (this.pmeta_ != null) {
                this.pmeta_.removePlotPropertyListener(this);
                this.pmeta_ = null;
            }
            super.flush();
        }
    }

    protected String tinyNumberFormat(double value) {
        PrintfFormat format7G = new PrintfFormat("%.7g");
        String result = format7G.sprintfx(value);
        if (result.equals("0") && value != 0.0) {
            PrintfFormat format2e = new PrintfFormat("%.2E");
            result = format2e.sprintfx(value);
        }
        return result;
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        if (e == null) {
            LOGGER.trace("null PanDataEvent");
            return;
        }
        LOGGER.trace("{}", (Object)e);
        PanDataEvent.EType eid = e.getID();
        if (eid != PanDataEvent.EType.UNITS_CHANGED && (eid == PanDataEvent.EType.VARIABLE_CHANGED || eid == PanDataEvent.EType.COMBINATION_CHANGED)) {
            LOGGER.trace("var/combo changed: {}", (Object)eid);
            Object oldItem = this.unitsCombo_.getSelectedItem();
            String oldChoice = oldItem == null ? "" : oldItem.toString();
            boolean isReset = false;
            this.unitsCombo_.removeAllItems();
            for (String choice : this.data_.getUnitsChoices()) {
                this.unitsCombo_.addItem(choice);
                if (!choice.equals(oldChoice)) continue;
                this.unitsCombo_.setSelectedItem(choice);
                isReset = true;
            }
            if (!isReset) {
                this.unitsCombo_.setSelectedIndex(0);
                String unitsStr = this.unitsCombo_.getSelectedItem().toString();
                this.pmeta_.setString("scale.units", unitsStr);
            }
            GuiUtils.restrictSize(this.unitsCombo_);
        }
        LOGGER.trace("done");
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll) {
            this.refresh();
        }
        if (changeAll || pname.contains("scale.method")) {
            PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
            LOGGER.trace("smethod {}", (Object)smethod);
            if (smethod.equals(PanScaleMethod.LOG10)) {
                this.methodCombo_.setSelectedItem(PanScaleMethod.LOG10);
            } else {
                this.methodCombo_.setSelectedItem(PanScaleMethod.SCALAR);
            }
            this.validateRange();
            this.refresh();
        }
        if (changeAll || pname.contains("scale.autofit")) {
            this.refreshPrivate();
        }
        this.repaint();
    }
}

