/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import java.awt.BasicStroke;
import java.awt.Font;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanGraphicUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Font getFont(String fname, float size) {
        return PanGraphicUtils.getFont(fname, 0, size);
    }

    public static Font getFont(String fname, int style, float size) {
        Font ff;
        try {
            ff = new Font(fname, style, 10);
        }
        catch (Exception exc) {
            ff = new Font("SansSerif", style, 10);
        }
        ff = ff.deriveFont(size);
        return ff;
    }

    public static BasicStroke tickStroke(int sfactor) {
        return GraphicUtils.buttMiterStroke(sfactor);
    }

    public static BasicStroke solidStroke(int weight, int sfactor) {
        return PanGraphicUtils.buttMiterStroke(PanStrokePattern.SOLID, weight, sfactor);
    }

    public static BasicStroke buttMiterStroke(String style, int weight, int sfactor) {
        PanStrokePattern gs = PanStrokePattern.matching(style);
        if (gs == null) {
            return null;
        }
        return PanGraphicUtils.buttMiterStroke(gs, weight, sfactor);
    }

    public static BasicStroke buttMiterStroke(PanStrokePattern style, int weight, int scaling) {
        if (style == null || style == PanStrokePattern.NONE || weight <= 0 || scaling <= 0) {
            return null;
        }
        if (weight > 500) {
            throw new IllegalArgumentException("Weight setting too heavy.");
        }
        float sqs = (float)Math.sqrt(0.01f * (float)scaling);
        int ww = (int)((float)weight * sqs);
        float[] pattern = style.getPattern();
        if (pattern == null) {
            return GraphicUtils.buttMiterStroke(ww);
        }
        int i = 0;
        while (i < pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] * sqs;
        }
        return GraphicUtils.buttMiterStroke(ww, pattern);
    }

    public static BasicStroke roundStroke(String style, int weight, int sfactor) {
        PanStrokePattern gs = PanStrokePattern.matching(style);
        if (gs == null) {
            return null;
        }
        return PanGraphicUtils.roundStroke(gs, weight, sfactor);
    }

    public static BasicStroke roundStroke(PanStrokePattern style, int weight, int scaling) {
        if (style == null || style == PanStrokePattern.NONE || weight <= 0 || scaling <= 0) {
            return null;
        }
        if (weight > 500) {
            throw new IllegalArgumentException("Weight setting too heavy.");
        }
        float sqs = (float)Math.sqrt(0.01f * (float)scaling);
        int ww = (int)((float)weight * sqs);
        float[] pattern = style.getPattern();
        if (pattern == null) {
            return GraphicUtils.roundStroke(ww);
        }
        int i = 0;
        while (i < pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] * sqs;
        }
        return GraphicUtils.roundStroke(ww, pattern);
    }

    public static BasicStroke squareMiterStroke(String style, int weight, int sfactor) {
        PanStrokePattern gs = PanStrokePattern.matching(style);
        if (gs == null) {
            return null;
        }
        return PanGraphicUtils.squareMiterStroke(gs, weight, sfactor);
    }

    public static BasicStroke squareMiterStroke(PanStrokePattern style, int weight, int scaling) {
        if (style == null || style == PanStrokePattern.NONE || weight <= 0 || scaling <= 0) {
            return null;
        }
        if (weight > 500) {
            throw new IllegalArgumentException("Weight setting too heavy.");
        }
        float sqs = (float)Math.sqrt(0.01f * (float)scaling);
        int ww = (int)((float)weight * sqs);
        float[] pattern = style.getPattern();
        if (pattern == null) {
            return GraphicUtils.squareMiterStroke(ww);
        }
        int i = 0;
        while (i < pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] * sqs;
        }
        return GraphicUtils.squareMiterStroke(ww, pattern);
    }

    private PanGraphicUtils() {
    }
}

