/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.lang.invoke.MethodHandles;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String UNICODE_REGEX = "\\\\u[a-zA-Z0-9]{4}";
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u[a-zA-Z0-9]{4}", 2);

    public static String ucfirst(String instr) {
        if (instr == null || instr.isEmpty()) {
            return instr;
        }
        if (instr.length() == 1) {
            return instr.toUpperCase();
        }
        return instr.substring(0, 1).toUpperCase() + instr.substring(1);
    }

    public static String getMinusSign() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        return Character.toString(symbols.getMinusSign());
    }

    public static String getDecimalSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        return Character.toString(symbols.getDecimalSeparator());
    }

    public static String getGroupSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        return Character.toString(symbols.getGroupingSeparator());
    }

    public static String unescapeUnicode(String s) {
        if (s == null || s.length() < 6) {
            return s;
        }
        String pvalue = s;
        Matcher matcher;
        while ((matcher = UNICODE_PATTERN.matcher(pvalue)).find()) {
            String ucode = matcher.group(0);
            String uhex = ucode.substring(2);
            try {
                String ustr = Character.toString((char)Integer.parseInt(uhex, 16));
                pvalue = matcher.replaceFirst(ustr);
            }
            catch (Exception exc) {
                LOGGER.debug("Exception {} parsing apparent Unicode {}", (Object)exc.toString(), (Object)uhex);
                LOGGER.debug("Returning current string");
                return pvalue;
            }
        }
        return pvalue;
    }

    public static String[] breakLines(StringBuilder sb, int maxLen) {
        if (sb == null || sb.length() == 0) {
            return new String[0];
        }
        return StringUtils.breakLines(sb.toString(), maxLen);
    }

    public static String[] breakLines(String inStr, int maxLen) {
        if (inStr == null || inStr.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> lineArray = new ArrayList<String>(20);
        String inStr1 = inStr.replaceAll("\n", " ").replaceAll("  *", " ");
        if (inStr1.length() <= maxLen) {
            return new String[]{inStr1};
        }
        String[] words = inStr1.split("\\s+");
        StringBuilder sb = new StringBuilder(maxLen + 10);
        int currentLineLen = 0;
        for (String word : words) {
            int wordLen = word.length();
            if (currentLineLen == 0 && wordLen > maxLen) {
                lineArray.add(word);
                continue;
            }
            if (currentLineLen + wordLen >= maxLen) {
                int lastIdx = sb.length() - 1;
                if (sb.charAt(lastIdx) == ' ') {
                    sb.deleteCharAt(lastIdx);
                }
                lineArray.add(sb.toString());
                sb.delete(0, sb.length());
                currentLineLen = 0;
            }
            sb.append(word).append(' ');
            currentLineLen += wordLen + 1;
        }
        lineArray.add(sb.toString());
        return lineArray.toArray(new String[0]);
    }

    public static String breakAndReassemble(String inStr, int maxLen) {
        String[] strs = StringUtils.breakLines(inStr, maxLen);
        if (strs.length == 0) {
            return "";
        }
        if (strs.length == 1) {
            return strs[0];
        }
        StringBuilder sb = new StringBuilder(inStr.length());
        for (String oneLine : strs) {
            sb.append(oneLine).append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static float parseFloat(String fs) throws NumberFormatException {
        return (float)StringUtils.parseDouble(fs);
    }

    public static double parseDouble(String d) throws NumberFormatException {
        String groupSep = StringUtils.getGroupSeparator();
        String dd = d.replaceAll("\\s", "");
        String ddd = dd.replaceAll("\\" + groupSep, "");
        if (ddd.length() == 0) {
            throw new NumberFormatException("String does not look like a numeric text value");
        }
        LOGGER.trace("Trying to parse {} : {} : {}", d, dd, ddd);
        int eindex = ddd.toLowerCase().indexOf(101);
        if (eindex > -1) {
            int eindex0 = eindex++;
            if (eindex == 1 || eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            if (ddd.substring(eindex, eindex + 1).equals("+")) {
                ++eindex;
            }
            if (eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            LOGGER.trace("Trying to parse as exponential");
            double exponent = 0.0;
            try {
                exponent = Integer.parseInt(ddd.substring(eindex));
            }
            catch (Exception exc) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Integer failed to exponent {}", (Object)ddd.substring(eindex));
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                }
                throw new NumberFormatException("Could not parse apparent exponent " + d + " - " + ddd);
            }
            double base = StringUtils.parseDouble(ddd.substring(0, eindex0));
            double result = base * Math.pow(10.0, exponent);
            LOGGER.trace("Exponential result is {}", (Object)result);
            return result;
        }
        try {
            LOGGER.trace("Trying to parse with NumberFormat");
            NumberFormat nfi = NumberFormat.getNumberInstance();
            double result = nfi.parse(dd).doubleValue();
            LOGGER.trace("NumberFormat result is {}", (Object)result);
            return result;
        }
        catch (Exception nfi) {
            try {
                LOGGER.trace("Trying to parse with Double");
                double result = Double.parseDouble(ddd);
                LOGGER.trace("Double result is ", (Object)result);
                return result;
            }
            catch (Exception exception) {
                throw new NumberFormatException("String does not look like a numeric text value");
            }
        }
    }

    public static String escapeHtmlSimplistic(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return StringUtils.escapeHtmlSimplistic(new StringBuilder(s));
    }

    public static String escapeHtmlSimplistic(StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        int isize = sb.length();
        if (isize == 0) {
            return "";
        }
        block8: for (int i = isize - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            switch (c) {
                case '&': {
                    sb.replace(i, i + 1, "&amp;");
                    continue block8;
                }
                case '<': {
                    sb.replace(i, i + 1, "&lt;");
                    continue block8;
                }
                case '>': {
                    sb.replace(i, i + 1, "&gt;");
                    continue block8;
                }
                case '\"': {
                    sb.replace(i, i + 1, "&quot;");
                    continue block8;
                }
                case '\'': {
                    sb.replace(i, i + 1, "&#39;");
                    continue block8;
                }
                case '/': {
                    sb.replace(i, i + 1, "&#47;");
                    continue block8;
                }
            }
        }
        return sb.toString();
    }

    public static int romanOfString(String str) {
        int result = 0;
        int isize = str.length();
        for (int i = 0; i < isize; ++i) {
            int s1 = StringUtils.romanOfChar(str.charAt(i));
            int ip1 = i + 1;
            if (ip1 < isize) {
                int s2 = StringUtils.romanOfChar(str.charAt(ip1));
                if (s1 >= s2) {
                    result += s1;
                    continue;
                }
                result += s2 - s1;
                ++i;
                continue;
            }
            result += s1;
        }
        return result;
    }

    private static int romanOfChar(char c) {
        switch (c) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new IllegalArgumentException("Char is not a Roman number.");
    }

    public static int length(AttributedString astr) {
        AttributedCharacterIterator aci = astr.getIterator();
        int count = 0;
        char c = aci.first();
        while (c != '\uffff') {
            ++count;
            c = aci.next();
        }
        return count;
    }

    public static AttributedString concatenate(AttributedString ... astrs) {
        StringBuilder sb = new StringBuilder(50);
        AttributedCharacterIterator[] iters = new AttributedCharacterIterator[astrs.length];
        for (int i = 0; i < iters.length; ++i) {
            iters[i] = astrs[i].getIterator();
            char c = iters[i].first();
            while (c != '\uffff') {
                sb.append(c);
                c = iters[i].next();
            }
        }
        AttributedString result = new AttributedString(sb.toString());
        int ii = 0;
        for (int i = 0; i < iters.length; ++i) {
            char c = iters[i].first();
            while (c != '\uffff') {
                Map<AttributedCharacterIterator.Attribute, Object> attrs = iters[i].getAttributes();
                result.addAttributes(attrs, ii, ii + 1);
                ++ii;
                c = iters[i].next();
            }
        }
        return result;
    }

    private StringUtils() {
    }
}

