/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.ui.table.GissTable;
import gov.nasa.giss.ui.table.RowHeaderRenderer;
import gov.nasa.giss.ui.table.TableHeaderTheme;
import gov.nasa.giss.ui.table.TableRowHeaderModel;
import gov.nasa.giss.ui.table.TableTheme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.table.TableModel;

public class TableRowHeader
extends JTable {
    private TableRowHeaderModel model_;

    public TableRowHeader(JTable table, String[] values) {
        this(table, new TableRowHeaderModel(values));
    }

    public TableRowHeader(JTable table, TableModel model) {
        super(model);
        this.model_ = (TableRowHeaderModel)model;
        LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        Dimension d = this.getPreferredScrollableViewportSize();
        d.width = this.getPreferredSize().width + 15;
        this.setPreferredScrollableViewportSize(d);
        this.setRowHeight(table.getRowHeight());
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        RowHeaderRenderer thr = new RowHeaderRenderer(this);
        thr.setHorizontalAlignment(0);
        this.setDefaultRenderer(Object.class, thr);
        if (table instanceof GissTable) {
            GissTable gt = (GissTable)table;
            TableTheme theme = gt.getTheme();
            TableHeaderTheme htheme = theme.getHeaderTheme();
            gt.setTableRowHeader(this);
            thr.setTheme(htheme);
        }
    }

    public void setValues(String[] newvals) {
        this.model_.setValues(newvals);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        int rowCount = this.getRowCount();
        if (rowCount * this.rowHeight < height) {
            RowHeaderRenderer tcr1 = new RowHeaderRenderer(this);
            Component c = tcr1.getTableCellRendererComponent(this, "", false, false, 0, 0);
            int rows = height / this.rowHeight;
            for (int i = rowCount; i <= rows; ++i) {
                g.translate(0, i * this.rowHeight);
                c.setSize(clip.width, this.rowHeight);
                c.paint(g);
                g.translate(0, -i * this.rowHeight);
            }
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this.getParent();
            return vp.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

