/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarUtils {
    public static String[] getResourceListing(Class<?> c, String path) throws IOException {
        URL url = c.getResource(path);
        if (url == null) {
            return null;
        }
        if (!url.getProtocol().equals("jar")) {
            return null;
        }
        String dpath = url.getPath();
        dpath = dpath.replaceFirst("file:", "");
        dpath = dpath.replaceFirst("\\!.*", "");
        JarFile jar = new JarFile(URLDecoder.decode(dpath, "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        Object xpath = path;
        if (((String)xpath).charAt(0) == '/') {
            xpath = ((String)xpath).substring(1);
        } else {
            String cpath = c.getName();
            int dot = cpath.lastIndexOf(46);
            cpath = cpath.substring(0, dot).replace(".", "/");
            xpath = cpath + "/" + path;
        }
        if (!((String)xpath).endsWith("/")) {
            xpath = (String)xpath + "/";
        }
        int xlength = ((String)xpath).length();
        HashSet<String> result = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String entry;
            String name = entries.nextElement().getName();
            if (!name.startsWith((String)xpath) || (entry = name.substring(xlength)).equals("")) continue;
            result.add(entry);
        }
        return result.toArray(new String[result.size()]);
    }

    private JarUtils() {
    }
}

