/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.impl;

import java.awt.color.ICC_Profile;
import java.nio.charset.StandardCharsets;

public class CodecUtil {
    public static final float[] SRGB_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};

    private CodecUtil() {
    }

    private static boolean arrayStartsWith(byte[] expect, byte[] checkMe, int fromIndex) {
        if (checkMe.length - fromIndex < expect.length) {
            return false;
        }
        for (int i = 0; i < expect.length; ++i) {
            if (expect[i] == checkMe[fromIndex + i]) continue;
            return false;
        }
        return true;
    }

    private static int uInt32Number(byte[] bytes, int offset) {
        long value = (long)(bytes[offset + 3] & 0xFF | (bytes[offset + 2] & 0xFF) << 8 | (bytes[offset + 1] & 0xFF) << 16) | (long)(bytes[offset] & 0xFF) << 24;
        return (int)value;
    }

    public static String getProfileName(ICC_Profile profile) {
        int numrec;
        byte[] bdesc = profile.getData(1684370275);
        byte[] mluc = new byte[]{109, 108, 117, 99};
        if (bdesc != null && CodecUtil.arrayStartsWith(mluc, bdesc, 0) && (numrec = CodecUtil.uInt32Number(bdesc, 8)) > 0) {
            int len = CodecUtil.uInt32Number(bdesc, 20);
            int offset = CodecUtil.uInt32Number(bdesc, 24);
            int maxlen = bdesc.length - offset;
            if (maxlen > 0) {
                len = Math.min(len, maxlen);
                return new String(bdesc, offset, len, StandardCharsets.UTF_16BE).trim();
            }
        }
        return null;
    }
}

