/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.png;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGDecodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImage;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;

public class PNGRed
extends AbstractRed {
    private final PNGImage pngImage;

    public PNGRed(InputStream stream) throws IOException {
        this(stream, null);
    }

    public PNGRed(InputStream stream, PNGDecodeParam decodeParam) throws IOException {
        this.pngImage = new MyPNGImage(stream, decodeParam);
    }

    @Override
    public WritableRaster copyData(WritableRaster wr) {
        GraphicsUtil.copyData(this.pngImage.theTile, wr);
        return wr;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.pngImage.getTile(tileX, tileY);
    }

    class MyPNGImage
    extends PNGImage {
        public MyPNGImage(InputStream input, PNGDecodeParam param) throws IOException {
            super(input, param);
        }

        @Override
        protected void onIEnd() {
            Rectangle bounds = new Rectangle(0, 0, this.width, this.height);
            PNGRed.this.init(null, bounds, this.colorModel, this.sampleModel, 0, 0, this.properties);
        }
    }
}

