/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.platform.Platform;

public class UrlBox
extends FullBox {
    private String url;

    public static String fourcc() {
        return "url ";
    }

    public static UrlBox createUrlBox(String url) {
        UrlBox urlBox = new UrlBox(new Header(UrlBox.fourcc()));
        urlBox.url = url;
        return urlBox;
    }

    public UrlBox(Header atom) {
        super(atom);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        if ((this.flags & 1) != 0) {
            return;
        }
        Charset utf8 = Charset.forName("utf-8");
        this.url = NIOUtils.readNullTermStringCharset(input, utf8);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        Charset utf8 = Charset.forName("utf-8");
        if (this.url != null) {
            NIOUtils.write(out, ByteBuffer.wrap(Platform.getBytesForCharset(this.url, utf8)));
            out.put((byte)0);
        }
    }

    @Override
    public int estimateSize() {
        int sz = 13;
        Charset utf8 = Charset.forName("utf-8");
        if (this.url != null) {
            sz += Platform.getBytesForCharset(this.url, utf8).length;
        }
        return sz;
    }

    public String getUrl() {
        return this.url;
    }
}

