/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.node.DexDebugNode;
import com.googlecode.d2j.reader.InstructionFormat;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.smali.BaksmaliDumper;
import com.googlecode.d2j.util.Out;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class BaksmaliCodeDumper
extends DexCodeVisitor {
    private boolean useParameterRegisters;
    private boolean useLocals;
    private int nextLabelNumber;
    private Out out;
    final int startParamR;
    final Set<DexLabel> usedLabel;
    final Map<DexLabel, List<DexDebugNode.DexDebugOpNode>> debugLabelMap;
    List<Map.Entry<DexLabel, Object>> appendLast = new ArrayList<Map.Entry<DexLabel, Object>>();
    DexDebugVisitor debugDumper = new DexDebugVisitor(){

        public void visitStartLocal(int reg, DexLabel label, String name, String type, String signature) {
            super.visitStartLocal(reg, label, name, type, signature);
            if (signature == null) {
                BaksmaliCodeDumper.this.out.s(".local %s, %s:%s", new Object[]{BaksmaliCodeDumper.this.reg(reg), name, type});
            } else {
                BaksmaliCodeDumper.this.out.s(".local %s, %s:%s, %s", new Object[]{BaksmaliCodeDumper.this.reg(reg), name, type, BaksmaliDumper.escapeValue(signature)});
            }
        }

        public void visitPrologue(DexLabel dexLabel) {
            BaksmaliCodeDumper.this.out.s(".prologue");
        }

        public void visitEpiogue(DexLabel dexLabel) {
            BaksmaliCodeDumper.this.out.s(".epiogue");
        }

        public void visitLineNumber(int line, DexLabel label) {
            BaksmaliCodeDumper.this.out.s(".line %d", new Object[]{line});
        }

        public void visitEndLocal(int reg, DexLabel label) {
            BaksmaliCodeDumper.this.out.s(".end local %s", new Object[]{BaksmaliCodeDumper.this.reg(reg)});
        }

        public void visitRestartLocal(int reg, DexLabel label) {
            BaksmaliCodeDumper.this.out.s(".restart local %s", new Object[]{BaksmaliCodeDumper.this.reg(reg)});
        }
    };

    public BaksmaliCodeDumper(Out out, boolean useParameterRegisters, boolean useLocals, int nextLabelNumber, int startParamR, Set<DexLabel> usedLabel, Map<DexLabel, List<DexDebugNode.DexDebugOpNode>> debugLabelMap) {
        this.out = out;
        this.useParameterRegisters = useParameterRegisters;
        this.useLocals = useLocals;
        this.nextLabelNumber = nextLabelNumber;
        this.startParamR = startParamR;
        this.usedLabel = usedLabel;
        this.debugLabelMap = debugLabelMap;
    }

    String reg(int rdx) {
        if (this.useParameterRegisters && rdx >= this.startParamR) {
            return "p" + (rdx - this.startParamR);
        }
        return "v" + rdx;
    }

    public void visitFillArrayDataStmt(Op op, int ra, Object array) {
        DexLabel dx = new DexLabel();
        dx.displayName = "L" + this.nextLabelNumber++;
        this.usedLabel.add(dx);
        this.out.s("%s %s, %s", new Object[]{op.displayName, this.reg(ra), this.xLabel(dx)});
        this.appendLast.add(new AbstractMap.SimpleEntry<DexLabel, Object>(dx, array));
    }

    public void visitConstStmt(Op op, int ra, Object value) {
        switch (op) {
            case CONST_WIDE_16: {
                Long v = (Long)value;
                value = (int)v.shortValue();
                break;
            }
            case CONST_WIDE_HIGH16: {
                Long v = (Long)value;
                value = (int)((short)(v >> 48));
                break;
            }
            case CONST_WIDE_32: {
                Long v = (Long)value;
                value = v.intValue();
                break;
            }
            case CONST_HIGH16: {
                Integer v = (Integer)value;
                value = v >> 16;
            }
        }
        this.out.s("%s %s, %s", new Object[]{op.displayName, this.reg(ra), BaksmaliDumper.escapeValue(value)});
        super.visitConstStmt(op, ra, value);
    }

    public void visitEnd() {
        for (Map.Entry<DexLabel, Object> e : this.appendLast) {
            int b;
            int a;
            int i;
            this.visitLabel(e.getKey());
            Object v = e.getValue();
            if (v instanceof SparseSwitchStmt) {
                SparseSwitchStmt ss = (SparseSwitchStmt)v;
                this.out.s(".sparse-switch");
                this.out.push();
                int i2 = 0;
                while (i2 < ss.cases.length) {
                    this.out.s("%d -> %s", new Object[]{ss.cases[i2], this.xLabel(ss.labels[i2])});
                    ++i2;
                }
                this.out.pop();
                this.out.s(".end sparse-switch");
                continue;
            }
            if (v instanceof PackedSwitchStmt) {
                PackedSwitchStmt ps = (PackedSwitchStmt)v;
                this.out.s(".packed-switch %d", new Object[]{ps.first_case});
                this.out.push();
                DexLabel[] dexLabelArray = ps.labels;
                int n = ps.labels.length;
                int n2 = 0;
                while (n2 < n) {
                    DexLabel label = dexLabelArray[n2];
                    this.out.s(this.xLabel(label));
                    ++n2;
                }
                this.out.pop();
                this.out.s(".end packed-switch");
                continue;
            }
            Object array = e.getValue();
            if (array instanceof byte[]) {
                this.out.s(".array-data 1");
                this.out.push();
                byte[] vs = (byte[])array;
                i = 0;
                while (i < vs.length) {
                    this.out.s(BaksmaliDumper.escapeValue(vs[i]));
                    ++i;
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof short[]) {
                this.out.s(".array-data 2");
                this.out.push();
                short[] vs = (short[])array;
                i = 0;
                while (i < vs.length) {
                    short a2 = vs[i];
                    this.out.s("%s %s", new Object[]{BaksmaliDumper.escapeValue((byte)(a2 & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a2 >> 8))});
                    ++i;
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof int[]) {
                this.out.s(".array-data 4");
                this.out.push();
                int[] vs = (int[])array;
                i = 0;
                while (i < vs.length) {
                    int a3 = vs[i];
                    this.out.s("%s %s %s %s", new Object[]{BaksmaliDumper.escapeValue((byte)(a3 & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a3 >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a3 >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a3 >> 24))});
                    ++i;
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof float[]) {
                this.out.s(".array-data 4");
                this.out.push();
                float[] vs = (float[])array;
                i = 0;
                while (i < vs.length) {
                    int a4 = Float.floatToIntBits(vs[i]);
                    this.out.s("%s %s %s %s", new Object[]{BaksmaliDumper.escapeValue((byte)(a4 & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a4 >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a4 >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a4 >> 24))});
                    ++i;
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (array instanceof long[]) {
                this.out.s(".array-data 8");
                this.out.push();
                long[] vs = (long[])array;
                i = 0;
                while (i < vs.length) {
                    long ttt = vs[i];
                    a = (int)ttt;
                    b = (int)(ttt >>> 32);
                    this.out.s("%s %s %s %s %s %s %s %s", new Object[]{BaksmaliDumper.escapeValue((byte)(a & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 24)), BaksmaliDumper.escapeValue((byte)(b & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 24))});
                    ++i;
                }
                this.out.pop();
                this.out.s(".end array-data");
                continue;
            }
            if (!(array instanceof double[])) continue;
            this.out.s(".array-data 8");
            this.out.push();
            double[] vs = (double[])array;
            i = 0;
            while (i < vs.length) {
                long ttt = Double.doubleToLongBits(vs[i]);
                a = (int)ttt;
                b = (int)(ttt >>> 32);
                this.out.s("%s %s %s %s %s %s %s %s", new Object[]{BaksmaliDumper.escapeValue((byte)(a & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & a >> 24)), BaksmaliDumper.escapeValue((byte)(b & 0xFF)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 8)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 16)), BaksmaliDumper.escapeValue((byte)(0xFF & b >> 24))});
                ++i;
            }
            this.out.pop();
            this.out.s(".end array-data");
        }
    }

    public void visitFieldStmt(Op op, int a, int b, Field field) {
        if (op.format == InstructionFormat.kFmt22c) {
            this.out.s("%s %s, %s, %s->%s:%s", new Object[]{op.displayName, this.reg(a), this.reg(b), BaksmaliDumper.escapeType(field.getOwner()), BaksmaliDumper.escapeId(field.getName()), BaksmaliDumper.escapeType(field.getType())});
        } else {
            this.out.s("%s %s, %s->%s:%s", new Object[]{op.displayName, this.reg(a), BaksmaliDumper.escapeType(field.getOwner()), BaksmaliDumper.escapeId(field.getName()), BaksmaliDumper.escapeType(field.getType())});
        }
    }

    public void visitFilledNewArrayStmt(Op op, int[] args, String type) {
        if (args.length > 0) {
            if (op.format == InstructionFormat.kFmt3rc) {
                this.out.s("%s { %d .. %d }, %s", new Object[]{op.displayName, this.reg(args[0]), this.reg(args[args.length - 1]), BaksmaliDumper.escapeType(type)});
            } else {
                StringBuilder buff = new StringBuilder();
                boolean first = true;
                int[] nArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        buff.append(", ");
                    }
                    buff.append(this.reg(i));
                    ++n2;
                }
                this.out.s("%s { %s }, %s", new Object[]{op.displayName, buff, BaksmaliDumper.escapeType(type)});
            }
        } else {
            this.out.s("%s { }, %s", new Object[]{op.displayName, BaksmaliDumper.escapeType(type)});
        }
    }

    public void visitJumpStmt(Op op, int a, int b, DexLabel label) {
        if (op.format == InstructionFormat.kFmt21t || op.format == InstructionFormat.kFmt31t) {
            this.out.s(String.valueOf(op.displayName) + " " + this.reg(a) + ", " + this.xLabel(label));
        } else if (op.format == InstructionFormat.kFmt22t) {
            this.out.s(String.valueOf(op.displayName) + " " + this.reg(a) + ", " + this.reg(b) + ", " + this.xLabel(label));
        } else {
            this.out.s(String.valueOf(op.displayName) + " " + this.xLabel(label));
        }
    }

    public void visitLabel(DexLabel label) {
        List<DexDebugNode.DexDebugOpNode> dOps;
        if (this.usedLabel.contains(label)) {
            this.out.s(this.xLabel(label));
        }
        if ((dOps = this.debugLabelMap.get(label)) != null) {
            for (DexDebugNode.DexDebugOpNode dOp : dOps) {
                dOp.accept(this.debugDumper);
            }
        }
    }

    public final DexDebugVisitor visitDebug() {
        return null;
    }

    public void visitMethodStmt(Op op, int[] args, Method method) {
        if (args.length > 0) {
            if (op.format == InstructionFormat.kFmt3rc) {
                this.out.s("%s { %s .. %s }, %s->%s%s", new Object[]{op.displayName, this.reg(args[0]), this.reg(args[args.length - 1]), BaksmaliDumper.escapeType(method.getOwner()), BaksmaliDumper.escapeId(method.getName()), BaksmaliDumper.escapeMethodDesc(method)});
            } else {
                boolean first = true;
                StringBuilder buff = new StringBuilder();
                int[] nArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        buff.append(", ");
                    }
                    buff.append(this.reg(i));
                    ++n2;
                }
                this.out.s("%s { %s }, %s->%s%s", new Object[]{op.displayName, buff, BaksmaliDumper.escapeType(method.getOwner()), BaksmaliDumper.escapeId(method.getName()), BaksmaliDumper.escapeMethodDesc(method)});
            }
        } else {
            this.out.s("%s { }, %s->%s%s", new Object[]{op.displayName, BaksmaliDumper.escapeType(method.getOwner()), BaksmaliDumper.escapeId(method.getName()), BaksmaliDumper.escapeMethodDesc(method)});
        }
    }

    public void visitPackedSwitchStmt(Op op, int ra, int first_case, DexLabel[] labels) {
        DexLabel dx = new DexLabel();
        dx.displayName = "L" + this.nextLabelNumber++;
        this.usedLabel.add(dx);
        this.out.s(String.valueOf(op.displayName) + " " + this.reg(ra) + ", " + this.xLabel(dx));
        this.appendLast.add(new AbstractMap.SimpleEntry<DexLabel, PackedSwitchStmt>(dx, new PackedSwitchStmt(first_case, labels)));
    }

    public void visitRegister(int total) {
        if (this.useLocals) {
            this.out.s(".locals %d", new Object[]{this.startParamR});
        } else {
            this.out.s(".registers %d", new Object[]{total});
        }
    }

    public void visitSparseSwitchStmt(Op op, int ra, int[] cases, DexLabel[] labels) {
        DexLabel dx = new DexLabel();
        dx.displayName = "L" + this.nextLabelNumber++;
        this.usedLabel.add(dx);
        this.out.s(String.valueOf(op.displayName) + " " + this.reg(ra) + ", " + this.xLabel(dx));
        this.appendLast.add(new AbstractMap.SimpleEntry<DexLabel, SparseSwitchStmt>(dx, new SparseSwitchStmt(cases, labels)));
    }

    public void visitStmt0R(Op op) {
        if (op == Op.BAD_OP) {
            this.out.s("%s # bad op", new Object[]{Op.NOP.displayName});
        } else {
            this.out.s(op.displayName);
        }
    }

    public void visitStmt1R(Op op, int a) {
        this.out.s(String.valueOf(op.displayName) + " " + this.reg(a));
    }

    public void visitStmt2R(Op op, int a, int b) {
        this.out.s(String.valueOf(op.displayName) + " " + this.reg(a) + ", " + this.reg(b));
    }

    public void visitStmt2R1N(Op op, int a, int b, int content) {
        this.out.s("%s %s, %s, %s", new Object[]{op.displayName, this.reg(a), this.reg(b), content});
    }

    public void visitStmt3R(Op op, int a, int b, int c) {
        this.out.s("%s %s, %s, %s", new Object[]{op.displayName, this.reg(a), this.reg(b), this.reg(c)});
    }

    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handler, String[] type) {
        int i = 0;
        while (i < type.length) {
            String t = type[i];
            if (t == null) {
                this.out.s(".catchall { %s .. %s } %s", new Object[]{this.xLabel(start), this.xLabel(end), this.xLabel(handler[i])});
            } else {
                this.out.s(".catch %s { %s .. %s } %s", new Object[]{t, this.xLabel(start), this.xLabel(end), this.xLabel(handler[i])});
            }
            ++i;
        }
    }

    public void visitTypeStmt(Op op, int a, int b, String type) {
        if (op.format == InstructionFormat.kFmt21c) {
            this.out.s("%s %s, %s", new Object[]{op.displayName, this.reg(a), BaksmaliDumper.escapeType(type)});
        } else {
            this.out.s("%s %s, %s, %s", new Object[]{op.displayName, this.reg(a), this.reg(b), BaksmaliDumper.escapeType(type)});
        }
    }

    String xLabel(DexLabel d) {
        return ":" + d.displayName;
    }

    class PackedSwitchStmt {
        int first_case;
        DexLabel[] labels;

        public PackedSwitchStmt(int first_case, DexLabel[] labels) {
            this.first_case = first_case;
            this.labels = labels;
        }
    }

    class SparseSwitchStmt {
        int[] cases;
        DexLabel[] labels;

        public SparseSwitchStmt(int[] cases, DexLabel[] labels) {
            this.cases = cases;
            this.labels = labels;
        }
    }
}

