/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.BtnExceptionRule;
import com.ghostchu.peerbanhelper.btn.BtnExceptionRuleParsed;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.event.btn.BtnExceptionRuleUpdateEvent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.rule.Rule;
import com.ghostchu.peerbanhelper.util.rule.RuleMatchResult;
import com.ghostchu.peerbanhelper.util.rule.RuleParser;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import inet.ipaddr.IPAddress;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityException
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityException.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final File btnCacheFile = new File(Main.getDataDirectory(), "btn-exception.cache");
    private BtnExceptionRuleParsed btnExceptionRule;

    public BtnAbilityException(BtnNetwork btnNetwork, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
    }

    private void loadCacheFile() throws IOException {
        if (!this.btnCacheFile.exists()) {
            if (!this.btnCacheFile.getParentFile().exists()) {
                this.btnCacheFile.getParentFile().mkdirs();
            }
            this.btnCacheFile.createNewFile();
        } else {
            try {
                BtnExceptionRule btnRule = (BtnExceptionRule)JsonUtil.getGson().fromJson(Files.readString(this.btnCacheFile.toPath()), BtnExceptionRule.class);
                this.btnExceptionRule = new BtnExceptionRuleParsed(btnRule);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return "BtnAbilityException";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_EXCEPTION);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_EXCEPTION_DESCRIPTION);
    }

    @Override
    public void load() {
        try {
            this.loadCacheFile();
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_EXCEPTION_LOADED_FROM_CACHE));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.BTN_ABILITY_EXCEPTION_LOADED_FROM_CACHE_FAILED, new Object[0]));
            this.setLastStatus(false, new TranslationComponent(e.getClass().getName() + ": " + e.getMessage()));
        }
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::updateRule, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void updateRule() {
        block15: {
            String version = this.btnExceptionRule == null || this.btnExceptionRule.getVersion() == null ? "initial" : this.btnExceptionRule.getVersion();
            Request request = new Request.Builder().url(URLUtil.appendUrl(this.endpoint, Map.of("rev", version))).get().build();
            try (Response response = this.btnNetwork.getHttpClient().newCall(request).execute();){
                if (response.code() == 204) {
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_EXCEPTION_LOADED_FROM_REMOTE, this.btnExceptionRule.getVersion()));
                    return;
                }
                if (!response.isSuccessful()) {
                    String body = response.body().string();
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + body));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), body));
                    break block15;
                }
                try {
                    String body = response.body().string();
                    BtnExceptionRule btr = (BtnExceptionRule)JsonUtil.getGson().fromJson(body, BtnExceptionRule.class);
                    this.btnExceptionRule = new BtnExceptionRuleParsed(btr);
                    Main.getEventBus().post((Object)new BtnExceptionRuleUpdateEvent());
                    try {
                        Files.writeString(this.btnCacheFile.toPath(), (CharSequence)body, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    log.info(TextManager.tlUI(Lang.BTN_ABILITY_EXCEPTION_UPDATE_RULES_SUCCESSES, this.btnExceptionRule.getVersion()));
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_EXCEPTION_LOADED_FROM_REMOTE, this.btnExceptionRule.getVersion()));
                    this.unbanPeers(this.btnExceptionRule);
                    this.btnNetwork.getModuleMatchCache().invalidateAll();
                }
                catch (JsonSyntaxException e) {
                    String body = response.body().string();
                    this.setLastStatus(false, new TranslationComponent("JsonSyntaxException: " + response.code() + " - " + body));
                    log.error("Unable to parse BtnExceptionRule as a valid Json object: {}-{}", new Object[]{response.code(), body, e});
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, new Object[0]), (Throwable)e);
                this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
            }
        }
    }

    private void unbanPeers(BtnExceptionRuleParsed btr) {
        List<Rule> ipList = btr.getIpRules().values().stream().flatMap(Collection::stream).toList();
        List<Rule> clientNameList = btr.getClientNameRules().values().stream().flatMap(Collection::stream).toList();
        List<Rule> peerIdList = btr.getPeerIdRules().values().stream().flatMap(Collection::stream).toList();
        List<Rule> portList = btr.getPortRules().values().stream().flatMap(Collection::stream).toList();
        int ct = 0;
        ct += this.unbanIps(ipList);
        ct += this.unbanClientName(clientNameList);
        ct += this.unbanPeerId(peerIdList);
        log.info(TextManager.tlUI(Lang.BTN_ABILITY_EXCEPTION_UNBANNED_PEERS, ct += this.unbanPort(portList)));
    }

    private int unbanIps(List<Rule> rules) {
        ArrayList list = new ArrayList();
        this.btnNetwork.getServer().getBanList().forEach((addr, meta) -> {
            RuleMatchResult matchResult = RuleParser.matchRule(rules, addr.toNormalizedString());
            if (matchResult.hit()) {
                list.add(addr);
            }
        });
        list.forEach(addr -> this.btnNetwork.getServer().scheduleUnBanPeer((IPAddress)addr));
        return list.size();
    }

    private int unbanClientName(List<Rule> rules) {
        ArrayList list = new ArrayList();
        this.btnNetwork.getServer().getBanList().forEach((addr, meta) -> {
            RuleMatchResult matchResult = RuleParser.matchRule(rules, meta.getPeer().getClientName());
            if (matchResult.hit()) {
                list.add(addr);
            }
        });
        list.forEach(addr -> this.btnNetwork.getServer().scheduleUnBanPeer((IPAddress)addr));
        return list.size();
    }

    private int unbanPeerId(List<Rule> rules) {
        ArrayList list = new ArrayList();
        this.btnNetwork.getServer().getBanList().forEach((addr, meta) -> {
            RuleMatchResult matchResult = RuleParser.matchRule(rules, meta.getPeer().getId());
            if (matchResult.hit()) {
                list.add(addr);
            }
        });
        list.forEach(addr -> this.btnNetwork.getServer().scheduleUnBanPeer((IPAddress)addr));
        return list.size();
    }

    private int unbanPort(List<Rule> rules) {
        ArrayList list = new ArrayList();
        this.btnNetwork.getServer().getBanList().forEach((addr, meta) -> {
            RuleMatchResult matchResult = RuleParser.matchRule(rules, Integer.toString(meta.getPeer().getAddress().getPort()));
            if (matchResult.hit()) {
                list.add(addr);
            }
        });
        list.forEach(addr -> this.btnNetwork.getServer().scheduleUnBanPeer((IPAddress)addr));
        return list.size();
    }

    @Override
    public void unload() {
    }

    @Generated
    public BtnExceptionRuleParsed getBtnExceptionRule() {
        return this.btnExceptionRule;
    }
}

