/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.gui.impl.swing.mainwindow.component.swtembed;

import com.ghostchu.peerbanhelper.Main;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwtBrowserCanvas
extends Canvas {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwtBrowserCanvas.class);
    private final Thread swtEventLoop;
    private Display display;
    private Shell shell;
    private Browser browser;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private double dpiScaleFactor = 1.0;
    private boolean browserInitialized = false;

    public SwtBrowserCanvas() {
        this.setupHiDPISupport();
        this.swtEventLoop = this.createEventLoop();
        this.swtEventLoop.start();
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ SwtBrowserCanvas this$0;
            {
                SwtBrowserCanvas swtBrowserCanvas = this$0;
                Objects.requireNonNull(swtBrowserCanvas);
                this.this$0 = swtBrowserCanvas;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                EventQueue.invokeLater(() -> {
                    if (this.this$0.browserInitialized && this.this$0.display != null && !this.this$0.display.isDisposed()) {
                        this.this$0.display.asyncExec(() -> this.this$0.updateBrowserSize());
                    }
                });
            }
        });
    }

    private void setupHiDPISupport() {
        System.setProperty("swt.autoScale", "exact");
        System.setProperty("swt.autoScale.method", "nearest");
        System.setProperty("org.eclipse.swt.browser.DefaultType", "edge");
    }

    public void initBrowser() throws InterruptedException {
        this.countDownLatch.await();
        this.display.syncExec(() -> {
            this.display.setData("org.eclipse.swt.internal.win32.Edge.useDarkPreferedColorScheme", (Object)Main.getGuiManager().isDarkMode());
            this.calculateDPIScaleFactor();
            this.shell = SWT_AWT.new_Shell((Display)this.display, (Canvas)this);
            try {
                this.browser = new Browser((Composite)this.shell, 0);
                this.browser.setVisible(true);
                try (InputStream input = Main.class.getResourceAsStream("/placeholder.html");){
                    if (input != null) {
                        this.browser.setText(new String(input.readAllBytes(), StandardCharsets.UTF_8));
                    }
                }
                catch (Exception e) {
                    log.debug("Cannot load placeholder.html", (Throwable)e);
                }
                this.browserInitialized = true;
                this.updateBrowserSize();
            }
            catch (SWTError e) {
                this.browserInitialized = false;
                log.debug("Cannot init SWT Browser", (Throwable)e);
            }
        });
    }

    public void setUrl(String url) {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.display.asyncExec(() -> this.browser.setUrl(url));
        }
    }

    private void calculateDPIScaleFactor() {
        int dpi = this.display.getDPI().x;
        int standardDPI = 96;
        this.dpiScaleFactor = (double)dpi / (double)standardDPI;
    }

    private void updateBrowserSize() {
        if (this.browser != null && !this.browser.isDisposed() && this.browserInitialized) {
            Dimension canvasSize = this.getSize();
            if (canvasSize.width > 0 && canvasSize.height > 0) {
                int scaledWidth = (int)((double)canvasSize.width / this.dpiScaleFactor);
                int scaledHeight = (int)((double)canvasSize.height / this.dpiScaleFactor);
                this.browser.setSize(scaledWidth, scaledHeight);
                this.shell.setSize(scaledWidth, scaledHeight);
                this.shell.layout(true, true);
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.browserInitialized && this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(this::updateBrowserSize);
        }
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        if (this.browserInitialized && this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(this::updateBrowserSize);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.browserInitialized && this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(this::updateBrowserSize);
        }
    }

    private Thread createEventLoop() {
        Thread thread = new Thread(this){
            final /* synthetic */ SwtBrowserCanvas this$0;
            {
                SwtBrowserCanvas swtBrowserCanvas = this$0;
                Objects.requireNonNull(swtBrowserCanvas);
                this.this$0 = swtBrowserCanvas;
            }

            @Override
            public void run() {
                this.this$0.display = new Display();
                this.this$0.countDownLatch.countDown();
                while (!this.isInterrupted()) {
                    if (this.this$0.display.readAndDispatch()) continue;
                    this.this$0.display.sleep();
                }
            }
        };
        thread.setDaemon(true);
        thread.setName("SwtBrowserEventLoop");
        return thread;
    }

    @Override
    public void removeNotify() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(() -> {
                if (this.browser != null && !this.browser.isDisposed()) {
                    this.browser.dispose();
                }
                if (this.shell != null && !this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            });
        }
        this.swtEventLoop.interrupt();
        super.removeNotify();
    }

    @Override
    public boolean isValid() {
        if (this.display != null && !this.display.isDisposed() && this.shell != null && !this.shell.isDisposed()) {
            return this.browser != null && !this.browser.isDisposed();
        }
        return false;
    }

    public void refresh() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.display.asyncExec(() -> ((Browser)this.browser).refresh());
        }
    }
}

