/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.btn.BtnExceptionRuleParsed;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.BtnRulesetParsed;
import com.ghostchu.peerbanhelper.btn.ability.BtnAbility;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityException;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityRules;
import com.ghostchu.peerbanhelper.database.dao.impl.ScriptStorageDao;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.NullUtil;
import com.ghostchu.peerbanhelper.util.SharedObject;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.Rule;
import com.ghostchu.peerbanhelper.util.rule.RuleMatchResult;
import com.ghostchu.peerbanhelper.util.rule.RuleParser;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import com.ghostchu.peerbanhelper.util.scriptengine.CompiledScript;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.ghostchu.simplereloadlib.Reloadable;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.exception.TimeoutException;
import inet.ipaddr.IPAddress;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class BtnNetworkOnline
extends AbstractRuleFeatureModule
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnNetworkOnline.class);
    private final CheckResult BTN_MANAGER_NOT_INITIALIZED = new CheckResult(this.getClass(), PeerAction.NO_ACTION, 0L, new TranslationComponent(Lang.GENERAL_NA), new TranslationComponent("BtnManager not initialized"), StructuredData.create().add("status", "btn_manager_not_initialized"));
    private long banDuration;
    @Autowired
    private JavalinWebContainer javalinWebContainer;
    @Autowired(required=false)
    private BtnNetwork btnNetwork;
    @Autowired
    private ScriptEngine scriptEngine;
    @Autowired
    private ScriptStorageDao scriptStorageDao;
    private boolean allowScript;
    private final ExecutorService parallelService = Executors.newWorkStealingPool();

    @Override
    @NotNull
    public String getName() {
        return "BTN Network Online Rules";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "btn";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        Main.getReloadManager().register((Reloadable)this);
        this.javalinWebContainer.javalin().get("/api/modules/btn", this::status, new RouteRole[]{Role.USER_READ});
    }

    private void status(Context context) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (this.btnNetwork == null) {
            info.put("configSuccess", false);
            info.put("appId", "N/A");
            info.put("appSecret", "N/A");
            info.put("abilities", Collections.emptyList());
            info.put("configUrl", TextManager.tl(this.locale(context), Lang.BTN_SERVICES_NEED_RESTART, new Object[0]));
            context.json((Object)new StdResp(false, TextManager.tl(this.locale(context), Lang.BTN_NOT_ENABLE_AND_REQUIRE_RESTART, new Object[0]), null));
            return;
        }
        info.put("configSuccess", this.btnNetwork.getConfigSuccess());
        info.put("configResult", this.btnNetwork.getConfigResult() == null ? null : TextManager.tl(this.locale(context), this.btnNetwork.getConfigResult()));
        ArrayList abilities = new ArrayList();
        for (Map.Entry<Class<? extends BtnAbility>, BtnAbility> entry : this.btnNetwork.getAbilities().entrySet()) {
            HashMap<String, Object> abilityStatus = new HashMap<String, Object>();
            abilityStatus.put("name", entry.getValue().getName());
            abilityStatus.put("displayName", TextManager.tl(this.locale(context), entry.getValue().getDisplayName()));
            abilityStatus.put("description", TextManager.tl(this.locale(context), entry.getValue().getDescription()));
            abilityStatus.put("lastSuccess", entry.getValue().lastStatus());
            abilityStatus.put("lastMessage", TextManager.tl(this.locale(context), entry.getValue().lastMessage()));
            abilityStatus.put("lastUpdateAt", entry.getValue().lastStatusAt());
            abilities.add(abilityStatus);
        }
        info.put("abilities", abilities);
        info.put("appId", this.btnNetwork.getAppId());
        Object appSecret = this.btnNetwork.getAppSecret().length() > 5 ? this.btnNetwork.getAppSecret().substring(0, 5) + "*******" : "******";
        info.put("appSecret", appSecret);
        info.put("configUrl", this.btnNetwork.getConfigUrl());
        context.json((Object)new StdResp(true, null, info));
    }

    @Override
    public boolean isModuleEnabled() {
        if (super.isModuleEnabled()) {
            return this.btnNetwork != null;
        }
        return false;
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() {
        boolean configLoaded;
        boolean actualLoaded = this.btnNetwork != null;
        if (actualLoaded != (configLoaded = Main.getMainConfig().getBoolean("btn.enabled"))) {
            return ReloadResult.builder().status(ReloadStatus.REQUIRE_RESTART).build();
        }
        this.reloadConfig();
        return ReloadResult.builder().status(ReloadStatus.SUCCESS).build();
    }

    public void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.allowScript = this.getConfig().getBoolean("allow-script-execute");
        this.getCache().invalidateAll();
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        CheckResult scriptResult;
        if (this.btnNetwork == null) {
            return this.BTN_MANAGER_NOT_INITIALIZED;
        }
        CheckResult checkExceptionResult = this.checkShouldSkip(torrent, peer, downloader);
        if (checkExceptionResult.action() == PeerAction.SKIP) {
            return checkExceptionResult;
        }
        if (this.allowScript && (scriptResult = this.checkScript(torrent, peer, downloader, this.parallelService)).action() != PeerAction.NO_ACTION) {
            return scriptResult;
        }
        return this.checkShouldBan(torrent, peer, downloader);
    }

    @NotNull
    private CheckResult checkScript(Torrent torrent, Peer peer, Downloader downloader, ExecutorService ruleExecuteExecutor) {
        BtnAbility abilityObject = this.btnNetwork.getAbilities().get(BtnAbilityRules.class);
        if (abilityObject == null) {
            return this.pass();
        }
        BtnAbilityRules exception = (BtnAbilityRules)abilityObject;
        BtnRulesetParsed rule = exception.getBtnRule();
        if (rule == null) {
            return this.pass();
        }
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        ArrayList<CompletableFuture<CheckResult>> futures = new ArrayList<CompletableFuture<CheckResult>>();
        for (Map.Entry<String, CompiledScript> kvPair : rule.getScriptRules().entrySet()) {
            futures.add(CompletableFuture.supplyAsync(() -> this.runExpression((CompiledScript)kvPair.getValue(), torrent, peer, downloader), ruleExecuteExecutor));
        }
        CheckResult finalResult = this.pass();
        for (CompletableFuture completableFuture : futures) {
            CheckResult result = (CheckResult)completableFuture.join();
            if (result.action() == PeerAction.SKIP) {
                return result;
            }
            if (result.action() != PeerAction.BAN) continue;
            finalResult = result;
        }
        return finalResult;
    }

    @NotNull
    public CheckResult runExpression(CompiledScript script, @NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        return this.getCache().readCacheButWritePassOnly(this, script.hashCode() + peer.getCacheKey(), () -> {
            CheckResult result;
            try {
                Object returns;
                Map env = script.expression().newEnv(new Object[0]);
                env.put("torrent", torrent);
                env.put("peer", peer);
                env.put("downloader", downloader);
                env.put("cacheable", new AtomicBoolean(false));
                env.put("server", this.getServer());
                env.put("moduleInstance", this);
                env.put("btnNetwork", this.btnNetwork);
                env.put("banDuration", this.banDuration);
                env.put("kvStorage", SharedObject.SCRIPT_THREAD_SAFE_MAP);
                env.put("persistStorage", this.scriptStorageDao);
                if (script.threadSafe()) {
                    returns = script.expression().execute(env);
                } else {
                    Expression expression = script.expression();
                    synchronized (expression) {
                        returns = script.expression().execute(env);
                    }
                }
                result = this.scriptEngine.handleResult(script, this.banDuration, returns);
            }
            catch (TimeoutException timeoutException) {
                return this.pass();
            }
            catch (Exception ex) {
                log.error(TextManager.tlUI(Lang.RULE_ENGINE_ERROR, script.name()), (Throwable)ex);
                return this.pass();
            }
            if (result != null && result.action() != PeerAction.NO_ACTION) {
                return result;
            }
            return this.pass();
        }, script.cacheable());
    }

    @NotNull
    private CheckResult checkShouldSkip(Torrent torrent, Peer peer, Downloader downloader) {
        BtnAbility abilityObject = this.btnNetwork.getAbilities().get(BtnAbilityException.class);
        if (abilityObject == null) {
            return this.pass();
        }
        BtnAbilityException exception = (BtnAbilityException)abilityObject;
        BtnExceptionRuleParsed rule = exception.getBtnExceptionRule();
        if (rule == null) {
            return this.pass();
        }
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        return this.getCache().readCacheButWritePassOnly(this, "btn-exception-peer-" + peer.getCacheKey(), () -> {
            CheckResult r = null;
            if (rule.getPeerIdRules() != null) {
                r = NullUtil.anyNotNull(r, this.checkPeerIdRuleException(rule, torrent, peer));
            }
            if (rule.getClientNameRules() != null) {
                r = NullUtil.anyNotNull(r, this.checkClientNameRuleException(rule, torrent, peer));
            }
            if (rule.getIpRules() != null) {
                r = NullUtil.anyNotNull(r, this.checkIpRuleException(rule, torrent, peer));
            }
            if (rule.getPortRules() != null) {
                r = NullUtil.anyNotNull(r, this.checkPortRuleException(rule, torrent, peer));
            }
            if (r == null) {
                return this.pass();
            }
            return r;
        }, true);
    }

    @NotNull
    private CheckResult checkShouldBan(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        BtnAbility abilityObject = this.btnNetwork.getAbilities().get(BtnAbilityRules.class);
        if (abilityObject == null) {
            return this.pass();
        }
        BtnAbilityRules ruleAbility = (BtnAbilityRules)abilityObject;
        BtnRulesetParsed rule = ruleAbility.getBtnRule();
        if (rule == null) {
            return this.pass();
        }
        if (this.isHandShaking(peer)) {
            return this.handshaking();
        }
        return this.getCache().readCacheButWritePassOnly(this, "btn-ban-peer-" + peer.getCacheKey(), () -> {
            ArrayList<CheckResult> results = new ArrayList<CheckResult>();
            if (rule.getPeerIdRules() != null) {
                results.add(this.checkPeerIdRule(rule, torrent, peer));
            }
            if (rule.getClientNameRules() != null) {
                results.add(this.checkClientNameRule(rule, torrent, peer));
            }
            if (rule.getIpRules() != null) {
                results.add(this.checkIpRule(rule, torrent, peer));
            }
            if (rule.getPortRules() != null) {
                results.add(this.checkPortRule(rule, torrent, peer));
            }
            CheckResult finalResult = this.pass();
            for (CheckResult result : results) {
                if (result != null && result.action() == PeerAction.SKIP) {
                    return result;
                }
                if (result == null || result.action() != PeerAction.BAN) continue;
                finalResult = result;
            }
            return finalResult;
        }, true);
    }

    private CheckResult checkPortRule(BtnRulesetParsed rule, Torrent torrent, Peer peer) {
        for (String category : rule.getPortRules().keySet()) {
            RuleMatchResult matchResult = RuleParser.matchRule(rule.getPortRules().get(category), Integer.toString(peer.getPeerAddress().getPort()));
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherName()), new TranslationComponent(Lang.MODULE_BTN_BAN, "Port", category, matchResult.rule().matcherName()), StructuredData.create().add("type", "port").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }

    private CheckResult checkPortRuleException(BtnExceptionRuleParsed rule, Torrent torrent, Peer peer) {
        for (String category : rule.getPortRules().keySet()) {
            RuleMatchResult matchResult = RuleParser.matchRule(rule.getPortRules().get(category), Integer.toString(peer.getPeerAddress().getPort()));
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.SKIP, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherName()), new TranslationComponent(Lang.MODULE_BTN_BAN, "Port", category, matchResult.rule().matcherName()), StructuredData.create().add("type", "portException").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }

    @Nullable
    private CheckResult checkClientNameRule(BtnRulesetParsed rule, Torrent torrent, Peer peer) {
        for (String category : rule.getClientNameRules().keySet()) {
            List<Rule> rules = rule.getClientNameRules().get(category);
            RuleMatchResult matchResult = RuleParser.matchRule(rules, peer.getClientName());
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherName()), new TranslationComponent(Lang.MODULE_BTN_BAN, "ClientName", category, matchResult.rule().matcherName()), StructuredData.create().add("type", "clientName").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }

    @Nullable
    private CheckResult checkClientNameRuleException(BtnExceptionRuleParsed rule, Torrent torrent, Peer peer) {
        for (String category : rule.getClientNameRules().keySet()) {
            List<Rule> rules = rule.getClientNameRules().get(category);
            RuleMatchResult matchResult = RuleParser.matchRule(rules, peer.getClientName());
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.SKIP, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherName()), new TranslationComponent(Lang.MODULE_BTN_BAN, "ClientName", category, matchResult.rule().matcherName()), StructuredData.create().add("type", "clientNameException").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }

    @Nullable
    private CheckResult checkPeerIdRule(BtnRulesetParsed rule, Torrent torrent, Peer peer) {
        for (String category : rule.getPeerIdRules().keySet()) {
            List<Rule> rules = rule.getPeerIdRules().get(category);
            RuleMatchResult matchResult = RuleParser.matchRule(rules, peer.getPeerId());
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherName()), new TranslationComponent(Lang.MODULE_BTN_BAN, "PeerId", category, matchResult.rule().matcherName()), StructuredData.create().add("type", "peerId").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }

    @Nullable
    private CheckResult checkPeerIdRuleException(BtnExceptionRuleParsed rule, Torrent torrent, Peer peer) {
        for (String category : rule.getPeerIdRules().keySet()) {
            List<Rule> rules = rule.getPeerIdRules().get(category);
            RuleMatchResult matchResult = RuleParser.matchRule(rules, peer.getPeerId());
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.SKIP, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherName()), new TranslationComponent(Lang.MODULE_BTN_BAN, "PeerId", category, matchResult.rule().matcherName()), StructuredData.create().add("type", "peerIdException").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }

    @Nullable
    private CheckResult checkIpRule(BtnRulesetParsed rule, @NotNull Torrent torrent, @NotNull Peer peer) {
        IPAddress pa = peer.getPeerAddress().getAddress();
        if (pa == null) {
            return null;
        }
        if (pa.isIPv4Convertible()) {
            pa = pa.toIPv4();
        }
        for (String category : rule.getIpRules().keySet()) {
            IPMatcher ipMatcher = rule.getIpRules().get(category);
            MatchResult matchResult = ipMatcher.match(pa.toString());
            if (matchResult.result() != MatchResultEnum.TRUE) continue;
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, category), new TranslationComponent(Lang.MODULE_BTN_BAN, "IP", category, pa.toString()), StructuredData.create().add("type", "ip").add("category", category));
        }
        return null;
    }

    @Nullable
    private CheckResult checkIpRuleException(BtnExceptionRuleParsed rule, @NotNull Torrent torrent, @NotNull Peer peer) {
        IPAddress pa = peer.getPeerAddress().getAddress();
        if (pa == null) {
            return null;
        }
        if (pa.isIPv4Convertible()) {
            pa = pa.toIPv4();
        }
        for (String category : rule.getIpRules().keySet()) {
            RuleMatchResult matchResult = RuleParser.matchRule(rule.getIpRules().get(category), pa.toString());
            if (!matchResult.hit()) continue;
            return new CheckResult(this.getClass(), PeerAction.SKIP, this.banDuration, new TranslationComponent(Lang.BTN_BTN_RULE, category, matchResult.rule().matcherIdentifier()), new TranslationComponent(Lang.MODULE_BTN_BAN, "IP", category, pa.toString()), StructuredData.create().add("type", "ipException").add("category", category).add("rule", matchResult.rule().metadata()));
        }
        return null;
    }
}

