/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.DownloaderStatusDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.DownloaderWrapperDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PopulatedPeerDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.DownloaderDiscovery;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.dns.DNSLookup;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.PeerMetadata;
import com.ghostchu.peerbanhelper.wrapper.TorrentWrapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHDownloaderController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHDownloaderController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private Laboratory laboratory;
    @Autowired
    private DNSLookup dnsLookup;
    @Autowired
    private DownloaderManagerImpl downloaderManager;
    @Autowired
    private DownloaderServer downloaderServer;
    @Autowired
    private DownloaderDiscovery downloaderDiscovery;
    @Autowired
    private IPDBManager iPDBManager;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Downloader API";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-downloader";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/downloaders", this::handleDownloaderList, new RouteRole[]{Role.USER_READ})).get("/api/downloaders/scan", this::handleDownloaderScan, new RouteRole[]{Role.USER_READ})).put("/api/downloaders", this::handleDownloaderPut, new RouteRole[]{Role.USER_WRITE})).patch("/api/downloaders/{downloaderId}", ctx -> this.handleDownloaderPatch(ctx, ctx.pathParam("downloaderId")), new RouteRole[]{Role.USER_WRITE})).post("/api/downloaders/test", this::handleDownloaderTest, new RouteRole[]{Role.USER_WRITE})).delete("/api/downloaders/{downloaderId}", ctx -> this.handleDownloaderDelete(ctx, ctx.pathParam("downloaderId")), new RouteRole[]{Role.USER_WRITE})).get("/api/downloaders/{downloaderId}/status", ctx -> this.handleDownloaderStatus(ctx, ctx.pathParam("downloaderId")), new RouteRole[]{Role.USER_READ})).get("/api/downloaders/{downloaderId}/torrents", ctx -> this.handleDownloaderTorrents(ctx, ctx.pathParam("downloaderId")), new RouteRole[]{Role.USER_READ})).get("/api/downloaders/{downloaderId}/torrent/{torrentId}/peers", ctx -> this.handlePeersInTorrentOnDownloader(ctx, ctx.pathParam("downloaderId"), ctx.pathParam("torrentId")), new RouteRole[]{Role.USER_READ});
    }

    private void handleDownloaderScan(@NotNull Context ctx) {
        List<DownloaderDiscovery.DiscoveredDownloader> downloaders = this.downloaderDiscovery.scan().join();
        ctx.json((Object)new StdResp(true, null, downloaders));
    }

    private void handleDownloaderPut(Context ctx) {
        JsonObject config;
        JsonObject draftDownloader = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        String id = draftDownloader.get("id").getAsString();
        Downloader downloader = this.downloaderManager.createDownloader(id, config = draftDownloader.get("config").getAsJsonObject());
        if (downloader == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_ADD_FAILURE, new Object[0]), null));
            return;
        }
        if (!this.downloaderManager.registerDownloader(downloader)) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATION_FAILED_ALREADY_EXISTS, new Object[0]), null));
            return;
        }
        ctx.status(HttpStatus.CREATED);
        ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATED, new Object[0]), null));
        try {
            this.downloaderManager.saveDownloaders();
        }
        catch (IOException e) {
            log.error("Internal server error, unable to create downloader due an I/O exception", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATION_FAILED_IO_EXCEPTION, new Object[0]), null));
        }
    }

    private void handleDownloaderPatch(Context ctx, String downloaderId) {
        JsonObject draftDownloader = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        JsonObject config = draftDownloader.get("config").getAsJsonObject();
        Downloader downloader = this.downloaderManager.createDownloader(downloaderId, config);
        if (downloader == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_UPDATE_FAILURE, new Object[0]), null));
            return;
        }
        this.downloaderManager.stream().filter(d -> d.getId().equals(downloaderId)).forEach(d -> this.downloaderManager.unregisterDownloader((Downloader)d));
        if (this.downloaderManager.registerDownloader(downloader)) {
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_UPDATED, new Object[0]), null));
        } else {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_UPDATE_FAILURE_ALREADY_EXISTS, new Object[0]), null));
        }
        try {
            this.downloaderManager.saveDownloaders();
        }
        catch (IOException e) {
            log.error("Internal server error, unable to update downloader due an I/O exception", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_CREATION_FAILED_IO_EXCEPTION, new Object[0]), null));
        }
    }

    private void handleDownloaderTest(Context ctx) {
        JsonObject draftDownloader = JsonParser.parseString((String)ctx.body()).getAsJsonObject();
        JsonObject config = draftDownloader.get("config").getAsJsonObject();
        String id = draftDownloader.get("id").getAsString();
        Downloader downloader = this.downloaderManager.createDownloader(id, config);
        if (downloader == null) {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_ADD_FAILURE, new Object[0]), null));
            return;
        }
        try {
            if (!downloader.isPaused()) {
                DownloaderLoginResult testResult = downloader.login();
                if (testResult.success()) {
                    ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_TEST_OK, new Object[0]), null));
                } else {
                    ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), testResult.message()), null));
                }
                downloader.close();
            } else {
                ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_TEST_BYPASS_PAUSED, new Object[0]), null));
            }
        }
        catch (Exception e) {
            log.error("Validate downloader failed", (Throwable)e);
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, e.getMessage(), null));
        }
    }

    private void handleDownloaderDelete(Context ctx, String downloaderId) {
        Optional<Downloader> selected = this.downloaderManager.stream().filter(d -> d.getId().equals(downloaderId)).findFirst();
        if (selected.isEmpty()) {
            ctx.status(HttpStatus.NOT_FOUND);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_REMOVE_NOT_EXISTS, new Object[0]), null));
            return;
        }
        Downloader downloader = selected.get();
        this.downloaderManager.unregisterDownloader(downloader);
        try {
            this.downloaderManager.saveDownloaders();
            ctx.json((Object)new StdResp(true, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_REMOVE_SAVED, new Object[0]), null));
        }
        catch (IOException e) {
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, e.getClass().getName() + ": " + e.getMessage(), null));
        }
    }

    private void handlePeersInTorrentOnDownloader(Context ctx, String downloaderId, String torrentId) {
        Optional<Downloader> selected = this.downloaderManager.stream().filter(d -> d.getId().equals(downloaderId)).findFirst();
        if (selected.isEmpty()) {
            ctx.status(HttpStatus.NOT_FOUND);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_DOWNLOADER_NOT_EXISTS, new Object[0]), null));
            return;
        }
        Downloader downloader = selected.get();
        boolean ptr = Main.getMainConfig().getBoolean("lookup.dns-reverse-lookup");
        List<PopulatedPeerDTO> peerWrappers = this.downloaderServer.getLivePeersSnapshot().values().stream().flatMap(Collection::parallelStream).filter(p -> p.getDownloader().id().equals(downloader.getId())).filter(p -> p.getTorrent().getId().equals(torrentId)).sorted((o1, o2) -> Long.compare(o2.getPeer().getUploadSpeed(), o1.getPeer().getUploadSpeed())).map(dat -> this.populatePeerDTO((PeerMetadata)dat, ptr)).toList();
        ctx.json((Object)new StdResp(true, null, peerWrappers));
    }

    private PopulatedPeerDTO populatePeerDTO(PeerMetadata p, boolean resolvePTR) {
        PopulatedPeerDTO dto = new PopulatedPeerDTO(p.getPeer(), null, null);
        IPDBManager.IPDBResponse response = this.iPDBManager.queryIPDB(p.getPeer().toPeerAddress().getAddress().toInetAddress());
        IPGeoData geoData = response.geoData().get();
        if (geoData != null) {
            dto.setGeo(geoData);
        }
        if (dto.getPtrRecord() == null && resolvePTR) {
            dto.setPtrRecord(this.dnsLookup.ptr(IPAddressUtil.getIPAddress(p.getPeer().getAddress().getIp()).toReverseDNSLookupString()).join().orElse(null));
        }
        return dto;
    }

    private void handleDownloaderTorrents(@NotNull Context ctx, String downloaderId) {
        Optional<Downloader> selected = this.downloaderManager.stream().filter(d -> d.getId().equals(downloaderId)).findFirst();
        if (selected.isEmpty()) {
            ctx.status(HttpStatus.NOT_FOUND);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_DOWNLOADER_NOT_EXISTS, new Object[0]), null));
            return;
        }
        Downloader downloader = selected.get();
        List<TorrentWrapper> torrentWrappers = this.downloaderServer.getLivePeersSnapshot().values().stream().flatMap(Collection::stream).filter(p -> p.getDownloader().id().equals(downloader.getId())).map(PeerMetadata::getTorrent).distinct().sorted((o1, o2) -> {
            int compare = Long.compare(o2.getRtUploadSpeed(), o1.getRtUploadSpeed());
            if (compare != 0) {
                return compare;
            }
            return Long.compare(o2.getRtDownloadSpeed(), o1.getRtDownloadSpeed());
        }).toList();
        ctx.json((Object)new StdResp(true, null, torrentWrappers));
    }

    private void handleDownloaderStatus(@NotNull Context ctx, String downloaderId) {
        String locale = this.locale(ctx);
        Optional<Downloader> selected = this.downloaderManager.stream().filter(d -> d.getId().equals(downloaderId)).findFirst();
        if (selected.isEmpty()) {
            ctx.status(HttpStatus.NOT_FOUND);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.DOWNLOADER_API_DOWNLOADER_NOT_EXISTS, new Object[0]), null));
            return;
        }
        Downloader downloader = selected.get();
        DownloaderLastStatus lastStatus = downloader.getLastStatus();
        long activeTorrents = this.downloaderServer.getLivePeersSnapshot().values().stream().flatMap(Collection::stream).filter(p -> p.getDownloader().id().equals(downloader.getId())).map(p -> p.getTorrent().getHash()).distinct().count();
        long activePeers = this.downloaderServer.getLivePeersSnapshot().values().stream().flatMap(Collection::stream).filter(p -> p.getDownloader().id().equals(downloader.getId())).count();
        JsonObject config = downloader.saveDownloaderJson();
        if (ExternalSwitch.parseBoolean("pbh.demoMode")) {
            config.addProperty("endpoint", "REDACTED_IN_DEMO_MODE");
            config.addProperty("username", "REDACTED_IN_DEMO_MODE");
            config.addProperty("password", "REDACTED_IN_DEMO_MODE");
            JsonObject bAuth = config.getAsJsonObject("basicAuth");
            if (bAuth != null) {
                bAuth.addProperty("user", "REDACTED_IN_DEMO_MODE");
                bAuth.addProperty("pass", "REDACTED_IN_DEMO_MODE");
                config.add("basicAuth", (JsonElement)bAuth);
            }
        }
        ctx.json((Object)new StdResp(true, null, new DownloaderStatusDTO(lastStatus, TextManager.tl(locale, downloader.getLastStatusMessage() == null ? new TranslationComponent(Lang.STATUS_TEXT_UNKNOWN) : downloader.getLastStatusMessage()), activeTorrents, activePeers, config, downloader.isPaused())));
    }

    private void handleDownloaderList(@NotNull Context ctx) {
        List<DownloaderWrapperDTO> downloaders = this.downloaderManager.stream().map(d -> new DownloaderWrapperDTO(d.getId(), d.getName(), ExternalSwitch.parseBoolean("pbh.demoMode") ? "REDACTED_IN_DEMO_MODE" : d.getEndpoint(), d.getType().toLowerCase(), d.isPaused())).toList();
        ctx.json((Object)new StdResp(true, null, downloaders));
    }

    @Override
    public void onDisable() {
    }

    record DraftDownloader(String id, String name, JsonObject config) {
    }
}

