/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.compression.CompressionStrategy;
import io.javalin.compression.CompressionStrategyKt;
import io.javalin.compression.Compressor;
import io.javalin.http.Context;
import io.javalin.util.JavalinLogger;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002J&\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/javalin/jetty/JettyPrecompressingResourceHandler;", "", "()V", "compressedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getCompressedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "resourceMaxSize", "", "clearCache", "", "excludedMimeType", "", "mimeType", "compressionStrategy", "Lio/javalin/compression/CompressionStrategy;", "findMatchingCompressor", "Lio/javalin/compression/Compressor;", "contentTypeHeader", "getCompressedByteArray", "resource", "Lorg/eclipse/jetty/util/resource/Resource;", "compressor", "getStaticResourceByteArray", "target", "handle", "ctx", "Lio/javalin/http/Context;", "compStrat", "javalin"})
@SourceDebugExtension(value={"SMAP\nJettyPrecompressingResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyPrecompressingResourceHandler.kt\nio/javalin/jetty/JettyPrecompressingResourceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1747#2,3:89\n1549#2:92\n1620#2,3:93\n1#3:96\n*S KotlinDebug\n*F\n+ 1 JettyPrecompressingResourceHandler.kt\nio/javalin/jetty/JettyPrecompressingResourceHandler\n*L\n76#1:89,3\n85#1:92\n85#1:93,3\n*E\n"})
public final class JettyPrecompressingResourceHandler {
    @NotNull
    public static final JettyPrecompressingResourceHandler INSTANCE = new JettyPrecompressingResourceHandler();
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> compressedFiles = new ConcurrentHashMap();
    @JvmField
    public static int resourceMaxSize = 0x200000;

    private JettyPrecompressingResourceHandler() {
    }

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getCompressedFiles() {
        return compressedFiles;
    }

    @JvmStatic
    public static final void clearCache() {
        compressedFiles.clear();
    }

    public final boolean handle(@NotNull String target, @NotNull Resource resource, @NotNull Context ctx, @NotNull CompressionStrategy compStrat) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)compStrat, (String)"compStrat");
        String string = ctx.header("Accept-Encoding");
        if (string == null) {
            string = "";
        }
        Compressor compressor = this.findMatchingCompressor(string, compStrat);
        String contentType = MimeTypes.getDefaultMimeByExtension((String)target);
        if (contentType == null || this.excludedMimeType(contentType, compStrat)) {
            compressor = null;
        }
        byte[] byArray = this.getStaticResourceByteArray(resource, target, compressor);
        if (byArray == null) {
            return false;
        }
        byte[] resultByteArray = byArray;
        if (compressor != null) {
            ctx.header("Content-Encoding", compressor.encoding());
        }
        ctx.header("Content-Length", String.valueOf(resultByteArray.length));
        String string2 = contentType;
        if (string2 == null) {
            string2 = "";
        }
        ctx.header("Content-Type", string2);
        String string3 = ctx.header("If-None-Match");
        if (string3 != null) {
            String requestEtag = string3;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)requestEtag, (Object)resource.getWeakETag())) {
                ctx.status(304);
                return true;
            }
        }
        String string4 = resource.getWeakETag();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getWeakETag(...)");
        ctx.header("ETag", string4);
        ctx.result(resultByteArray);
        return true;
    }

    private final byte[] getStaticResourceByteArray(Resource resource, String target, Compressor compressor) {
        if (resource.length() > (long)resourceMaxSize) {
            JavalinLogger.warn$default("Static file '" + target + "' is larger than configured max size for pre-compression (" + resourceMaxSize + " bytes).\nYou can configure the max size with `JettyPrecompressingResourceHandler.resourceMaxSize = newMaxSize`.", null, 2, null);
            return null;
        }
        Object object = compressor;
        if (object == null || (object = object.extension()) == null) {
            object = "";
        }
        Object ext = object;
        return compressedFiles.computeIfAbsent(target + (String)ext, arg_0 -> JettyPrecompressingResourceHandler.getStaticResourceByteArray$lambda$1((Function1)new Function1<String, byte[]>(resource, compressor){
            final /* synthetic */ Resource $resource;
            final /* synthetic */ Compressor $compressor;
            {
                this.$resource = $resource;
                this.$compressor = $compressor;
                super(1);
            }

            @NotNull
            public final byte[] invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JettyPrecompressingResourceHandler.access$getCompressedByteArray(JettyPrecompressingResourceHandler.INSTANCE, this.$resource, this.$compressor);
            }
        }, arg_0));
    }

    private final byte[] getCompressedByteArray(Resource resource, Compressor compressor) {
        InputStream fileInput = resource.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = compressor;
        if (object == null || (object = object.compress(byteArrayOutputStream)) == null) {
            object = byteArrayOutputStream;
        }
        Object outputStream = object;
        Intrinsics.checkNotNull((Object)fileInput);
        ByteStreamsKt.copyTo$default((InputStream)fileInput, (OutputStream)outputStream, (int)0, (int)2, null);
        fileInput.close();
        ((OutputStream)outputStream).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final boolean excludedMimeType(String mimeType, CompressionStrategy compressionStrategy) {
        boolean bl;
        block7: {
            if (Intrinsics.areEqual((Object)mimeType, (Object)"")) {
                bl = false;
            } else if (compressionStrategy.getAllowedMimeTypes().contains(mimeType)) {
                bl = false;
            } else {
                Iterable $this$any$iv = compressionStrategy.getExcludedMimeTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String excluded = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)mimeType, (CharSequence)excluded, (boolean)true)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Compressor findMatchingCompressor(String contentTypeHeader, CompressionStrategy compressionStrategy) {
        Object object;
        block2: {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)contentTypeHeader, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            for (String it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                object2 = CompressionStrategyKt.forType(compressionStrategy.getCompressors(), it);
                if (object2 == null) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        return object;
    }

    private static final byte[] getStaticResourceByteArray$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (byte[])$tmp0.invoke(p0);
    }

    public static final /* synthetic */ byte[] access$getCompressedByteArray(JettyPrecompressingResourceHandler $this, Resource resource, Compressor compressor) {
        return $this.getCompressedByteArray(resource, compressor);
    }
}

