/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.bittorrent.tracker;

import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class TrackerImpl
implements Tracker {
    private final List<String> trackers;

    public TrackerImpl(String string) {
        Objects.requireNonNull(string, "tracker string cannot be null");
        this.trackers = Stream.of(string.split("\n")).map(String::trim).filter(s -> !s.isEmpty()).sorted().toList();
    }

    public TrackerImpl(List<String> string) {
        Objects.requireNonNull(string, "tracker list cannot be null");
        this.trackers = string;
    }

    @Override
    public List<String> getTrackersInGroup() {
        return this.trackers;
    }

    @Override
    public String getLeadingTracker() {
        if (this.trackers.isEmpty()) {
            throw new IllegalStateException("No trackers available");
        }
        return this.trackers.getFirst();
    }

    public static List<Tracker> parseFromTrackerList(String trackerList) {
        if (trackerList == null) {
            return Collections.emptyList();
        }
        return Stream.of(trackerList.split("\n\n")).filter(str -> !str.isBlank()).map(TrackerImpl::new).collect(Collectors.toUnmodifiableList());
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.trackers);
    }

    @Override
    public int compareTo(@NotNull Tracker o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackerImpl tracker = (TrackerImpl)o;
        return Objects.equals(this.trackers, tracker.trackers);
    }

    public int hashCode() {
        return Objects.hashCode(this.trackers);
    }
}

