/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.pow;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class PoWClient
implements AutoCloseable {
    private final int threadCount = Runtime.getRuntime().availableProcessors();
    private final ExecutorService executor = Executors.newWorkStealingPool(this.threadCount);

    public byte[] solve(byte[] challenge, int difficultyBits, String algorithm) throws Exception {
        AtomicBoolean found = new AtomicBoolean(false);
        CompletableFuture resultFuture = new CompletableFuture();
        int t = 0;
        while (t < this.threadCount) {
            int threadId = t++;
            this.executor.submit(() -> {
                try {
                    MessageDigest digest = MessageDigest.getInstance(algorithm);
                    ByteBuffer buffer = ByteBuffer.allocate(8);
                    long nonce = new SecureRandom().nextLong() + (long)threadId;
                    while (!found.get()) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        digest.reset();
                        digest.update(challenge);
                        buffer.clear();
                        buffer.putLong(nonce);
                        byte[] nonceBytes = buffer.array();
                        digest.update(nonceBytes);
                        byte[] hash = digest.digest();
                        if (this.hasLeadingZeroBits(hash, difficultyBits)) {
                            if (found.compareAndSet(false, true)) {
                                resultFuture.complete((byte[])nonceBytes.clone());
                            }
                            break;
                        }
                        nonce += (long)this.threadCount;
                    }
                }
                catch (Exception e) {
                    resultFuture.completeExceptionally(e);
                }
            });
        }
        return (byte[])resultFuture.get();
    }

    private boolean hasLeadingZeroBits(byte[] hash, int bits) {
        int fullBytes = bits / 8;
        int remainingBits = bits % 8;
        for (int i = 0; i < fullBytes; ++i) {
            if (hash[i] == 0) continue;
            return false;
        }
        if (remainingBits > 0) {
            int mask = 255 << 8 - remainingBits;
            return (hash[fullBytes] & mask) == 0;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.executor.close();
    }
}

