/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge;

import org.json.JSONException;
import org.json.JSONObject;

public final class Statistics {
    private final int m_dhtNodes;
    private final int m_downloadProtocolRate;
    private final int m_downloadRate;
    private final int m_freeSpace;
    private final boolean m_incomingConnections;
    private final double m_maxDownload;
    private final int m_maxNumConnections;
    private final double m_maxUpload;
    private final int m_numConnections;
    private final int m_uploadProtocolRate;
    private final int m_uploadRate;

    public Statistics(JSONObject stats) {
        this.m_dhtNodes = stats.optInt("dht_nodes");
        this.m_downloadProtocolRate = stats.optInt("download_protocol_rate");
        this.m_downloadRate = stats.optInt("download_rate");
        this.m_freeSpace = stats.optInt("free_space");
        this.m_incomingConnections = stats.optBoolean("has_incoming_connections");
        this.m_maxDownload = stats.optDouble("max_download");
        this.m_maxNumConnections = stats.optInt("max_num_connections");
        this.m_maxUpload = stats.optDouble("max_upload");
        this.m_numConnections = stats.optInt("num_connections");
        this.m_uploadProtocolRate = stats.optInt("upload_protocol_rate");
        this.m_uploadRate = stats.optInt("upload_rate");
    }

    public int getDHTNodes() {
        return this.m_dhtNodes;
    }

    public int getDownloadProtocolRate() {
        return this.m_downloadProtocolRate;
    }

    public int getDownloadRate() {
        return this.m_downloadRate;
    }

    public int getFreeSpace() {
        return this.m_freeSpace;
    }

    public boolean hasIncomingConnections() {
        return this.m_incomingConnections;
    }

    public double getMaxDownload() {
        return this.m_maxDownload;
    }

    public int getMaxNumConnections() {
        return this.m_maxNumConnections;
    }

    public double getMaxUpload() {
        return this.m_maxUpload;
    }

    public int getNumConnections() {
        return this.m_numConnections;
    }

    public int getUploadProtocolRate() {
        return this.m_uploadProtocolRate;
    }

    public int getUploadRate() {
        return this.m_uploadRate;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject ret = new JSONObject();
        ret.put("dht_nodes", this.m_dhtNodes);
        ret.put("download_protocol_rate", this.m_downloadProtocolRate);
        ret.put("download_rate", this.m_downloadRate);
        ret.put("free_space", this.m_freeSpace);
        ret.put("incoming_connections", this.m_incomingConnections);
        ret.put("max_download", this.m_maxDownload);
        ret.put("max_num_connections", this.m_maxNumConnections);
        ret.put("max_upload", this.m_maxUpload);
        ret.put("num_connections", this.m_numConnections);
        ret.put("upload_protocol_rate", this.m_uploadProtocolRate);
        ret.put("upload_rate", this.m_uploadRate);
        return ret;
    }
}

