/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.DohResolverCommon;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.TimeoutCompletableFuture;
import org.xbill.DNS.Type;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DohResolver
extends DohResolverCommon {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DohResolver.class);
    private final SSLSocketFactory sslSocketFactory;

    public DohResolver(String uriTemplate) {
        this(uriTemplate, 100, Duration.ZERO);
    }

    public DohResolver(String uriTemplate, int maxConcurrentRequests, Duration idleConnectionTimeout) {
        super(uriTemplate, maxConcurrentRequests);
        log.debug("Using Java 8 implementation");
        try {
            this.sslSocketFactory = SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setEDNS(int version, int payloadSize, int flags, List<EDNSOption> options) {
        super.setEDNS(version, payloadSize, flags, options);
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query) {
        return this.sendAsync(query, this.defaultExecutor);
    }

    @Override
    public CompletionStage<Message> sendAsync(Message query, Executor executor) {
        byte[] queryBytes = this.prepareQuery(query).toWire();
        String url = this.getUrl(queryBytes);
        long startTime = this.getNanoTime();
        int queryId = query.getHeader().getID();
        CompletableFuture f = this.maxConcurrentRequests.acquire(this.timeout, queryId, executor).handleAsync((permit, ex) -> {
            if (ex != null) {
                return this.timeoutFailedFuture(query, "could not acquire lock to send request", (Throwable)ex);
            }
            try {
                Message response;
                SendAndGetMessageBytesResponse result = this.sendAndGetMessageBytes(url, queryBytes, startTime);
                if (result.rc == 0) {
                    response = new Message(result.responseBytes);
                    this.verifyTSIG(query, response, result.responseBytes, this.tsig);
                } else {
                    response = new Message(0);
                    response.getHeader().setRcode(result.rc);
                }
                response.setResolver(this);
                CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(response);
                return completableFuture;
            }
            catch (SocketTimeoutException e) {
                CompletableFuture completableFuture = this.timeoutFailedFuture(query, e);
                return completableFuture;
            }
            catch (IOException | URISyntaxException e) {
                CompletableFuture completableFuture = this.failedFuture(e);
                return completableFuture;
            }
            finally {
                permit.release(queryId, executor);
            }
        }, executor).thenCompose(Function.identity()).toCompletableFuture();
        Duration remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS);
        return TimeoutCompletableFuture.compatTimeout(f, remainingTimeout.toMillis(), TimeUnit.MILLISECONDS).exceptionally(ex -> {
            if (ex instanceof TimeoutException) {
                throw new CompletionException(new TimeoutException("Query " + queryId + " for " + query.getQuestion().getName() + "/" + Type.string(query.getQuestion().getType()) + " timed out in remaining " + remainingTimeout.toMillis() + "ms"));
            }
            if (ex instanceof CompletionException) {
                throw (CompletionException)ex;
            }
            throw new CompletionException((Throwable)ex);
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private SendAndGetMessageBytesResponse sendAndGetMessageBytes(String url, byte[] queryBytes, long startTime) throws IOException, URISyntaxException {
        int rc;
        HttpURLConnection conn = (HttpURLConnection)new URI(url).toURL().openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
        }
        conn.setRequestMethod(this.usePost ? "POST" : "GET");
        conn.setRequestProperty("Content-Type", "application/dns-message");
        conn.setRequestProperty("Accept", "application/dns-message");
        Duration remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS);
        if (remainingTimeout.toMillis() <= 0L) {
            throw new SocketTimeoutException("No time left to connect");
        }
        conn.setConnectTimeout((int)remainingTimeout.toMillis());
        if (this.usePost) {
            conn.setDoOutput(true);
        }
        conn.connect();
        remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS);
        if (remainingTimeout.toMillis() <= 0L) {
            throw new SocketTimeoutException("No time left to request data");
        }
        conn.setReadTimeout((int)remainingTimeout.toMillis());
        if (this.usePost) {
            conn.getOutputStream().write(queryBytes);
        }
        if ((rc = conn.getResponseCode()) < 200 || rc >= 300) {
            this.discardStream(conn.getInputStream());
            this.discardStream(conn.getErrorStream());
            return new SendAndGetMessageBytesResponse(2, null);
        }
        try (InputStream is = conn.getInputStream();){
            SendAndGetMessageBytesResponse sendAndGetMessageBytesResponse;
            int length = conn.getContentLength();
            if (length > -1) {
                int r;
                byte[] responseBytes = new byte[conn.getContentLength()];
                int offset = 0;
                while ((r = is.read(responseBytes, offset, responseBytes.length - offset)) > 0) {
                    remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS);
                    if ((offset += r) == responseBytes.length || !remainingTimeout.isNegative() && !remainingTimeout.isZero()) continue;
                    throw new SocketTimeoutException("Timed out waiting for response data, got " + offset + " of " + responseBytes.length + " expected bytes");
                }
                if (offset < responseBytes.length) {
                    throw new EOFException("Could not read expected content length");
                }
                SendAndGetMessageBytesResponse sendAndGetMessageBytesResponse2 = new SendAndGetMessageBytesResponse(0, responseBytes);
                return sendAndGetMessageBytesResponse2;
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int r;
                byte[] buffer = new byte[4096];
                while ((r = is.read(buffer, 0, buffer.length)) > 0) {
                    remainingTimeout = this.timeout.minus(this.getNanoTime() - startTime, ChronoUnit.NANOS);
                    if (remainingTimeout.isNegative() || remainingTimeout.isZero()) {
                        throw new SocketTimeoutException("Timed out waiting for response data, got " + bos.size() + " bytes so far");
                    }
                    bos.write(buffer, 0, r);
                }
                sendAndGetMessageBytesResponse = new SendAndGetMessageBytesResponse(0, bos.toByteArray());
            }
            return sendAndGetMessageBytesResponse;
        }
        catch (IOException ioe) {
            this.discardStream(conn.getErrorStream());
            throw ioe;
        }
    }

    private void discardStream(InputStream es) throws IOException {
        if (es != null) {
            try (InputStream in = es;){
                byte[] buf = new byte[4096];
                while (in.read(buf) > 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected <T> CompletableFuture<T> failedFuture(Throwable e) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(e);
        return f;
    }

    private static final class SendAndGetMessageBytesResponse {
        private final int rc;
        private final byte[] responseBytes;

        @Generated
        public SendAndGetMessageBytesResponse(int rc, byte[] responseBytes) {
            this.rc = rc;
            this.responseBytes = responseBytes;
        }

        @Generated
        public int getRc() {
            return this.rc;
        }

        @Generated
        public byte[] getResponseBytes() {
            return this.responseBytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendAndGetMessageBytesResponse)) {
                return false;
            }
            SendAndGetMessageBytesResponse other = (SendAndGetMessageBytesResponse)o;
            if (this.getRc() != other.getRc()) {
                return false;
            }
            return Arrays.equals(this.getResponseBytes(), other.getResponseBytes());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRc();
            result = result * 59 + Arrays.hashCode(this.getResponseBytes());
            return result;
        }

        @Generated
        public String toString() {
            return "DohResolver.SendAndGetMessageBytesResponse(rc=" + this.getRc() + ", responseBytes=" + Arrays.toString(this.getResponseBytes()) + ")";
        }
    }
}

