/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.stone.beecp.BeeConnectionFactory;
import org.stone.tools.CommonUtil;

public final class ConnectionFactoryByDriverDs
implements BeeConnectionFactory,
CommonDataSource {
    private final DataSource driverDataSource;
    private String username;
    private String password;
    private boolean useUsername;

    public ConnectionFactoryByDriverDs(DataSource driverDataSource, String username, String password) {
        this.driverDataSource = driverDataSource;
        this.username = username;
        this.password = password;
        this.useUsername = CommonUtil.isNotBlank(username);
    }

    @Override
    public Connection create() throws SQLException {
        return this.useUsername ? this.driverDataSource.getConnection(this.username, this.password) : this.driverDataSource.getConnection();
    }

    public void setUsername(String username) {
        this.username = username;
        this.useUsername = CommonUtil.isNotBlank(username);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.driverDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.driverDataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.driverDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.driverDataSource.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driverDataSource.getParentLogger();
    }
}

