/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import org.stone.beecp.BeeConnectionPool;
import org.stone.beecp.exception.BeeDataSourceConfigException;
import org.stone.beecp.exception.BeeDataSourcePoolHasClosedException;
import org.stone.beecp.exception.BeeDataSourcePoolLazyInitializationException;
import org.stone.beecp.exception.ConnectionTestSqlExecutedException;
import org.stone.beecp.pool.PooledConnection;
import org.stone.beecp.pool.ProxyResultSet;
import org.stone.beecp.pool.ProxyStatementBase;
import org.stone.tools.LogPrinter;

public final class ConnectionPoolStatics {
    public static final String CONFIG_TM_JNDI = "transactionManagerName";
    public static final String CONFIG_FACTORY_PROP = "connectionFactoryProperties";
    public static final String CONFIG_FACTORY_PROP_SIZE = "connectionFactoryProperties.size";
    public static final String CONFIG_FACTORY_PROP_KEY_PREFIX = "connectionFactoryProperties.";
    public static final String CONFIG_SQL_EXCEPTION_CODE = "sqlExceptionCodeList";
    public static final String CONFIG_SQL_EXCEPTION_STATE = "sqlExceptionStateList";
    public static final String CONFIG_EXCLUSION_LIST_OF_PRINT = "exclusionListOfPrint";
    public static final CommonDataSource Dummy_CommonDataSource = new CommonDataSource(){

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported");
        }
    };
    public static final int CON_CLOSED = 0;
    public static final int CON_IDLE = 1;
    public static final int CON_CREATING = 2;
    public static final int CON_BORROWED = 3;
    public static final int POOL_LAZY = -1;
    public static final int POOL_NEW = 0;
    public static final int POOL_STARTING = 1;
    public static final int POOL_READY = 2;
    public static final int POOL_CLOSING = 3;
    public static final int POOL_CLOSED = 4;
    public static final int POOL_RESTARTING = 5;
    public static final int POOL_RESTART_FAILED = 6;
    public static final int POOL_SUSPENDED = 7;
    public static final BeeConnectionPool LAZY_POOL = (BeeConnectionPool)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{BeeConnectionPool.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("isClosed".equals(methodName)) {
                return true;
            }
            if ("toString".equals(methodName)) {
                return ConnectionPoolStatics.getPoolStateDesc(-1);
            }
            throw new BeeDataSourcePoolLazyInitializationException("No operations allowed on lazy pool");
        }
    });
    public static final BeeConnectionPool CLOSED_POOL = (BeeConnectionPool)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{BeeConnectionPool.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("isClosed".equals(methodName)) {
                return true;
            }
            if ("toString".equals(methodName)) {
                return ConnectionPoolStatics.getPoolStateDesc(4);
            }
            throw new BeeDataSourcePoolHasClosedException("No operations allowed on closed pool");
        }
    });
    static final int THREAD_WORKING = 0;
    static final int THREAD_WAITING = 1;
    static final int THREAD_EXIT = 2;
    static final int PS_AUTO = 0;
    static final int PS_TRANS = 1;
    static final int PS_READONLY = 2;
    static final int PS_CATALOG = 3;
    static final int PS_SCHEMA = 4;
    static final int PS_NETWORK = 5;
    static final String DESC_RM_POOL_START = "pool_init";
    static final String DESC_RM_CON_BAD = "bad";
    static final String DESC_RM_CON_ABORT = "abort";
    static final String DESC_RM_CON_IDLE = "idle";
    static final String DESC_RM_POOL_RESTART = "pool_restart";
    static final String DESC_RM_POOL_SHUTDOWN = "pool_shutdown";
    static final Connection CLOSED_CON = (Connection)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "Connection has been closed";
            }
            throw new SQLException("No operations allowed on closed connection");
        }
    });
    static final CallableStatement CLOSED_CSTM = (CallableStatement)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{CallableStatement.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "Statement has been closed";
            }
            throw new SQLException("No operations allowed on closed statement");
        }
    });
    static final ResultSet CLOSED_RSLT = (ResultSet)Proxy.newProxyInstance(ConnectionPoolStatics.class.getClassLoader(), new Class[]{ResultSet.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "ResultSet has been closed";
            }
            throw new SQLException("No operations allowed on closed resultSet");
        }
    });

    static String getPoolStateDesc(int state) {
        switch (state) {
            case -1: {
                return "Pool is lazy and initialized by calling one of its methods:getObjectHandle or getXAConnection";
            }
            case 0: {
                return "Pool is new";
            }
            case 1: {
                return "Pool is starting";
            }
            case 2: {
                return "Pool is ready";
            }
            case 3: {
                return "Pool is closing";
            }
            case 4: {
                return "Pool has been closed";
            }
            case 5: {
                return "Pool is restarting";
            }
            case 6: {
                return "Pool has restarted failed";
            }
            case 7: {
                return "Pool has been suspended";
            }
        }
        return "Unknown state of pool";
    }

    public static void oclose(ResultSet r) {
        try {
            r.close();
        }
        catch (Throwable e) {
            LogPrinter.DefaultLogPrinter.warn("Warning:Error at closing resultSet", e);
        }
    }

    public static void oclose(Statement s) {
        try {
            s.close();
        }
        catch (Throwable e) {
            LogPrinter.DefaultLogPrinter.warn("Warning:Error at closing statement", e);
        }
    }

    public static void oclose(Connection c) {
        try {
            c.close();
        }
        catch (SQLRecoverableException e) {
            LogPrinter.DefaultLogPrinter.warn("Warning:Error at closing connection", e);
            ConnectionPoolStatics.oclose(c);
        }
        catch (Throwable e) {
            LogPrinter.DefaultLogPrinter.warn("Warning:Error at closing connection", e);
        }
    }

    public static void oclose(XAConnection c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            LogPrinter.DefaultLogPrinter.warn("Warning:Error at closing xaConnection", e);
        }
    }

    static ResultSet createProxyResultSet(ResultSet resultSet, ProxyStatementBase proxyStatementBase, PooledConnection pooledConnection) throws SQLException {
        return new ProxyResultSet(resultSet, proxyStatementBase, pooledConnection);
    }

    public static Driver loadDriver(String driverClassName) throws BeeDataSourceConfigException {
        try {
            return (Driver)Class.forName(driverClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to create jdbc driver by class:" + driverClassName, e);
        }
    }

    static void checkJdbcProxyClass() throws ClassNotFoundException {
        String[] classNames = new String[]{"org.stone.beecp.pool.ProxyConnection", "org.stone.beecp.pool.ProxyStatement", "org.stone.beecp.pool.ProxyPsStatement", "org.stone.beecp.pool.ProxyCsStatement", "org.stone.beecp.pool.ProxyResultSet", "org.stone.beecp.pool.ProxyDatabaseMetaData", "org.stone.beecp.pool.ProxyConnection4L", "org.stone.beecp.pool.ProxyStatement4L", "org.stone.beecp.pool.ProxyPsStatement4L", "org.stone.beecp.pool.ProxyCsStatement4L"};
        ClassLoader loader = ConnectionPoolStatics.class.getClassLoader();
        for (String className : classNames) {
            Class.forName(className, true, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateTestSQL(String poolName, Connection rawCon, String testSql, int validTestTimeout, boolean isDefaultAutoCommit) throws SQLException {
        Statement st = null;
        boolean changed = false;
        try {
            if (isDefaultAutoCommit) {
                try {
                    rawCon.setAutoCommit(false);
                    changed = true;
                }
                catch (Throwable e) {
                    throw new SQLException("Failed to setAutoCommit(false)", e);
                }
            }
            st = rawCon.createStatement();
            boolean supportQueryTimeout = true;
            try {
                st.setQueryTimeout(validTestTimeout);
            }
            catch (Throwable e) {
                supportQueryTimeout = false;
                LogPrinter.DefaultLogPrinter.warn("BeeCP({})-driver not support 'queryTimeout'", poolName, e);
            }
            try {
                st.execute(testSql);
            }
            catch (Throwable e) {
                throw new ConnectionTestSqlExecutedException("Invalid test sql:" + testSql, e);
            }
            finally {
                rawCon.rollback();
            }
            boolean bl = supportQueryTimeout;
            return bl;
        }
        finally {
            if (st != null) {
                ConnectionPoolStatics.oclose(st);
            }
            if (changed) {
                rawCon.setAutoCommit(true);
            }
        }
    }
}

