/*
 * Decompiled with CFR 0.152.
 */
package org.stone.beecp.pool;

import org.stone.beecp.BeeConnectionPoolMonitorVo;
import org.stone.beecp.pool.ConnectionPoolStatics;

public final class FastConnectionPoolMonitorVo
implements BeeConnectionPoolMonitorVo {
    private String poolName;
    private boolean isFairMode;
    private int maxSize;
    private int semaphoreSize;
    private boolean useThreadLocal;
    private int poolState;
    private int idleSize;
    private int borrowedSize;
    private int semaphoreRemainSize;
    private int semaphoreWaitingSize;
    private int transferWaitingSize;
    private int creatingSize;
    private int creatingTimeoutSize;
    private boolean enabledLogPrinter;
    private boolean enabledLogCache;

    public FastConnectionPoolMonitorVo(String poolName, boolean isFairMode, int maxSize, int semaphoreSize, boolean useThreadLocal, int poolState, int idleSize, int borrowedSize, int semaphoreRemainSize, int semaphoreWaitingSize, int transferWaitingSize, int creatingSize, int creatingTimeoutSize, boolean enabledLogPrint, boolean enabledLogCache) {
        this.poolName = poolName;
        this.isFairMode = isFairMode;
        this.maxSize = maxSize;
        this.semaphoreSize = semaphoreSize;
        this.useThreadLocal = useThreadLocal;
        this.poolState = poolState;
        this.idleSize = idleSize;
        this.borrowedSize = borrowedSize;
        this.semaphoreRemainSize = semaphoreRemainSize;
        this.semaphoreWaitingSize = semaphoreWaitingSize;
        this.transferWaitingSize = transferWaitingSize;
        this.creatingSize = creatingSize;
        this.creatingTimeoutSize = creatingTimeoutSize;
        this.enabledLogPrinter = enabledLogPrint;
        this.enabledLogCache = enabledLogCache;
    }

    FastConnectionPoolMonitorVo() {
    }

    void fillSimple(int idleSize, int borrowedSize, int semaphoreRemainSize, int semaphoreWaitingSize) {
        this.idleSize = idleSize;
        this.borrowedSize = borrowedSize;
        this.semaphoreRemainSize = semaphoreRemainSize;
        this.semaphoreWaitingSize = semaphoreWaitingSize;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public boolean isFairMode() {
        return this.isFairMode;
    }

    @Override
    public boolean useThreadLocal() {
        return this.useThreadLocal;
    }

    @Override
    public boolean isLazy() {
        return this.poolState == -1;
    }

    @Override
    public boolean isNew() {
        return this.poolState == 0;
    }

    @Override
    public boolean isClosing() {
        return this.poolState == 3;
    }

    @Override
    public boolean isReady() {
        return this.poolState == 2;
    }

    @Override
    public boolean isStarting() {
        return this.poolState == 1;
    }

    @Override
    public boolean isRestarting() {
        return this.poolState == 5;
    }

    @Override
    public boolean isRestartFailed() {
        return this.poolState == 6;
    }

    @Override
    public boolean isSuspended() {
        return this.poolState == 7;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getSemaphoreSize() {
        return this.semaphoreSize;
    }

    @Override
    public int getBorrowedSize() {
        return this.borrowedSize;
    }

    @Override
    public int getIdleSize() {
        return this.idleSize;
    }

    @Override
    public int getCreatingSize() {
        return this.creatingSize;
    }

    @Override
    public int getCreatingTimeoutSize() {
        return this.creatingTimeoutSize;
    }

    @Override
    public int getSemaphoreRemainSize() {
        return this.semaphoreRemainSize;
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.semaphoreWaitingSize;
    }

    @Override
    public int getTransferWaitingSize() {
        return this.transferWaitingSize;
    }

    @Override
    public boolean isEnabledLogPrinter() {
        return this.enabledLogPrinter;
    }

    @Override
    public boolean isEnabledLogCache() {
        return this.enabledLogCache;
    }

    public String toString() {
        return ConnectionPoolStatics.getPoolStateDesc(this.poolState);
    }
}

