/*
 * Decompiled with CFR 0.152.
 */
package org.stone.tools.atomic;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.stone.tools.UnsafeHolder;
import org.stone.tools.exception.ReflectionOperationException;
import sun.misc.Unsafe;

public final class ReferenceFieldUpdaterImpl<T, V>
extends AtomicReferenceFieldUpdater<T, V> {
    private static final Unsafe unsafe = UnsafeHolder.getUnsafe();
    private final long offset;
    private final Class<V> fieldType;

    private ReferenceFieldUpdaterImpl(long offset, Class<V> fieldType) {
        this.offset = offset;
        this.fieldType = fieldType;
    }

    public static <T, V> AtomicReferenceFieldUpdater<T, V> newUpdater(Class<T> beanClass, Class<V> fieldType, String fieldName) {
        try {
            return new ReferenceFieldUpdaterImpl<T, V>(unsafe.objectFieldOffset(beanClass.getDeclaredField(fieldName)), fieldType);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionOperationException(e);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            return AtomicReferenceFieldUpdater.newUpdater(beanClass, fieldType, fieldName);
        }
    }

    @Override
    public boolean compareAndSet(T bean, V expect, V update) {
        return unsafe.compareAndSwapObject(bean, this.offset, expect, update);
    }

    @Override
    public boolean weakCompareAndSet(T bean, V expect, V update) {
        return unsafe.compareAndSwapObject(bean, this.offset, expect, update);
    }

    @Override
    public void set(T bean, V newValue) {
        unsafe.putObjectVolatile(bean, this.offset, newValue);
    }

    @Override
    public void lazySet(T bean, V newValue) {
        unsafe.putOrderedObject(bean, this.offset, newValue);
    }

    @Override
    public V get(T bean) {
        return this.fieldType.cast(unsafe.getObjectVolatile(bean, this.offset));
    }
}

