/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressSeqRangeList;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressComponentRange;
import inet.ipaddr.format.IPAddressRange;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.util.AddressComponentRangeSpliterator;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.ipv4.IPv4AddressSeqRange;
import inet.ipaddr.ipv6.IPv6AddressSeqRange;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public abstract class IPAddressSeqRange
implements IPAddressRange {
    private static final long serialVersionUID = 1L;
    private static final IPAddressSeqRange[] EMPTY_RANGES = new IPAddressSeqRange[0];
    private static final IPAddressSeqRangeList[] EMPTY_RANGE_LISTS = new IPAddressSeqRangeList[0];
    public static final String DEFAULT_RANGE_SEPARATOR = " -> ";
    protected static final IPAddressConverter DEFAULT_ADDRESS_CONVERTER = IPAddress.DEFAULT_ADDRESS_CONVERTER;
    protected final IPAddress lower;
    protected final IPAddress upper;
    private transient BigInteger count;
    private transient Boolean isMultiple;
    private transient int hashCode;

    protected <T extends IPAddress> IPAddressSeqRange(T first, T second, boolean preSet) {
        this.lower = first;
        this.upper = second;
    }

    protected <T extends IPAddress> IPAddressSeqRange(T first, T other, UnaryOperator<T> getLower, UnaryOperator<T> getUpper, UnaryOperator<T> prefixLenRemover) {
        boolean f = first.contains(other);
        if (f || other.contains(first)) {
            IPAddress addr = f ? (IPAddress)prefixLenRemover.apply(first) : (IPAddress)prefixLenRemover.apply(other);
            this.lower = (IPAddress)getLower.apply(addr);
            this.upper = (IPAddress)getUpper.apply(addr);
        } else {
            IPAddress firstLower = (IPAddress)getLower.apply(first);
            IPAddress otherLower = (IPAddress)getLower.apply(other);
            IPAddress firstUpper = (IPAddress)getUpper.apply(first);
            IPAddress otherUpper = (IPAddress)getUpper.apply(other);
            IPAddress lower = IPAddressSeqRange.compareLowerValues(firstLower, otherLower) > 0 ? otherLower : firstLower;
            IPAddress upper = IPAddressSeqRange.compareLowerValues(firstUpper, otherUpper) < 0 ? otherUpper : firstUpper;
            this.lower = (IPAddress)prefixLenRemover.apply(lower);
            this.upper = (IPAddress)prefixLenRemover.apply(upper);
        }
    }

    protected <T extends IPAddress> IPAddressSeqRange(T first, T second) {
        this.lower = first;
        this.upper = second;
    }

    static boolean versionsMatch(IPAddress one, IPAddress two) {
        return one.matchesVersion(two);
    }

    private static int compareLowerValues(IPAddress one, IPAddress two) {
        return AddressComparator.compareSegmentValues(false, one.getSection(), two.getSection());
    }

    private static int compareUpperValues(IPAddress one, IPAddress two) {
        return AddressComparator.compareSegmentValues(true, one.getSection(), two.getSection());
    }

    static String getMessage(String key) {
        return HostIdentifierException.getMessage(key);
    }

    @Override
    public BigInteger getCount() {
        BigInteger result = this.count;
        if (result == null) {
            this.count = result = this.getCountImpl();
        }
        return result;
    }

    @Override
    public boolean isMultiple() {
        Boolean isMult = this.isMultiple;
        if (isMult == null) {
            BigInteger count = this.count;
            if (count == null) {
                IPAddress upper;
                IPAddress lower = this.getLower();
                isMult = lower != (upper = this.getUpper()) && IPAddressSeqRange.compareLowerValues(lower, upper) != 0;
            } else {
                this.isMultiple = isMult = Boolean.valueOf(!count.equals(BigInteger.ONE));
            }
        }
        return isMult;
    }

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public IPv4AddressSeqRange toIPv4() {
        return null;
    }

    public IPv6AddressSeqRange toIPv6() {
        return null;
    }

    @Deprecated
    public boolean isMore(IPAddressSeqRange other) {
        return this.compareCounts(other) > 0;
    }

    public int compareCounts(IPAddressSeqRange other) {
        IPAddress otherLower;
        IPAddress lower;
        if ((this.count == null || other.count == null) && IPAddressSeqRange.versionsMatch(lower = this.getLower(), otherLower = other.getLower())) {
            int lowerComp = IPAddressSeqRange.compareLowerValues(lower, otherLower);
            int upperComp = IPAddressSeqRange.compareLowerValues(this.getUpper(), other.getUpper());
            if (lowerComp > 0) {
                if (upperComp <= 0) {
                    return -1;
                }
            } else if (lowerComp < 0) {
                if (upperComp >= 0) {
                    return 1;
                }
            } else {
                if (upperComp < 0) {
                    return -1;
                }
                if (upperComp > 0) {
                    return 1;
                }
                return 0;
            }
        }
        return this.getCount().compareTo(other.getCount());
    }

    protected BigInteger getCountImpl() {
        return IPAddressRange.super.getCount();
    }

    @Override
    public abstract Iterable<? extends IPAddress> getIterable();

    protected static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        return ParsedAddressGrouping.getNetworkSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
    }

    protected static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        return ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
    }

    @Override
    public abstract Iterator<? extends IPAddress> prefixBlockIterator(int var1);

    public abstract AddressComponentRangeSpliterator<? extends IPAddressSeqRange, ? extends IPAddress> prefixBlockSpliterator(int var1);

    @Override
    public abstract Stream<? extends IPAddress> prefixBlockStream(int var1);

    protected static <S extends AddressComponentRange, T> AddressComponentRangeSpliterator<S, T> createSpliterator(S forIteration, Predicate<IPAddressSeqRangeSplitterSink<S, T>> splitter, IPAddressSeqRangeIteratorProvider<S, T> iteratorProvider, ToLongFunction<S> longSizer) {
        return new IPAddressSection.IPAddressSeqRangeSpliterator<S, T>(forIteration, splitter, iteratorProvider, longSizer);
    }

    protected static <S extends AddressComponentRange, T> AddressComponentRangeSpliterator<S, T> createSpliterator(S forIteration, Predicate<IPAddressSeqRangeSplitterSink<S, T>> splitter, IPAddressSeqRangeIteratorProvider<S, T> iteratorProvider, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
        return new IPAddressSection.IPAddressSeqRangeSpliterator<S, T>(forIteration, splitter, iteratorProvider, sizer, downSizer, longSizer);
    }

    protected static <S extends AddressComponentRange> AddressComponentSpliterator<S> createPrefixSpliterator(S forIteration, Predicate<IPAddressSeqRangeSplitterSink<S, S>> splitter, IPAddressSeqRangeIteratorProvider<S, S> iteratorProvider, ToLongFunction<S> longSizer) {
        return new IPAddressSection.IPAddressSeqRangePrefixSpliterator<S>(forIteration, splitter, iteratorProvider, longSizer);
    }

    protected static <S extends AddressComponentRange> AddressComponentSpliterator<S> createPrefixSpliterator(S forIteration, Predicate<IPAddressSeqRangeSplitterSink<S, S>> splitter, IPAddressSeqRangeIteratorProvider<S, S> iteratorProvider, Function<S, BigInteger> sizer, Predicate<S> downSizer, ToLongFunction<S> longSizer) {
        return new IPAddressSection.IPAddressSeqRangePrefixSpliterator<S>(forIteration, splitter, iteratorProvider, sizer, downSizer, longSizer);
    }

    protected static <R, A extends IPAddress> Iterator<R> rangedIterator(final Iterator<A> iter) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public R next() {
                return ((IPAddress)iter.next()).coverWithSequentialRange();
            }
        };
    }

    public Iterator<? extends IPAddressSeqRange> prefixIterator(final int prefixLength) {
        if (prefixLength < 0) {
            throw new PrefixLenException(prefixLength);
        }
        if (!this.isMultiple()) {
            return new Iterator<IPAddressSeqRange>(){
                IPAddressSeqRange orig;
                {
                    this.orig = IPAddressSeqRange.this;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                @Override
                public IPAddressSeqRange next() {
                    if (this.orig == null) {
                        throw new NoSuchElementException();
                    }
                    IPAddressSeqRange result = this.orig;
                    this.orig = null;
                    return result;
                }
            };
        }
        return new Iterator<IPAddressSeqRange>(){
            Iterator<? extends IPAddress> prefixBlockIterator;
            private boolean first;
            {
                this.prefixBlockIterator = IPAddressSeqRange.this.prefixBlockIterator(prefixLength);
                this.first = true;
            }

            @Override
            public boolean hasNext() {
                return this.prefixBlockIterator.hasNext();
            }

            @Override
            public IPAddressSeqRange next() {
                IPAddress upper;
                IPAddress next = this.prefixBlockIterator.next();
                if (this.first) {
                    this.first = false;
                    IPAddress lower = IPAddressSeqRange.this.getLower();
                    if (this.hasNext()) {
                        if (!lower.includesZeroHost(prefixLength)) {
                            return IPAddressSeqRange.this.create(lower, next.getUpper());
                        }
                    } else {
                        IPAddress upper2 = IPAddressSeqRange.this.getUpper();
                        if (!lower.includesZeroHost(prefixLength) || !upper2.includesMaxHost(prefixLength)) {
                            return IPAddressSeqRange.this.create(lower, upper2);
                        }
                    }
                } else if (!this.hasNext() && !(upper = IPAddressSeqRange.this.getUpper()).includesMaxHost(prefixLength)) {
                    return IPAddressSeqRange.this.create(next.getLower(), upper);
                }
                return next.coverWithSequentialRange();
            }
        };
    }

    public abstract AddressComponentSpliterator<? extends IPAddressSeqRange> prefixSpliterator(int var1);

    public abstract Stream<? extends IPAddressSeqRange> prefixStream(int var1);

    protected static <I extends IPAddressSeqRange, T extends IPAddressRange, S extends AddressSegment> boolean split(IPAddressSeqRangeSplitterSink<I, T> sink, BiFunction<S[], S[], I> transformer, AddressNetwork.AddressSegmentCreator<S> segmentCreator, S[] originalSegmentsLower, S[] originalSegmentsUpper, int networkSegmentIndex, int hostSegmentIndex, Integer prefixLength) {
        S segUpper;
        S segLower;
        int i;
        AddressSegment upperSeg = null;
        AddressSegment lowerSeg = null;
        boolean isSplit = false;
        for (i = 0; i < hostSegmentIndex; ++i) {
            int upper;
            segLower = originalSegmentsLower[i];
            segUpper = originalSegmentsUpper[i];
            int lower = segLower.getSegmentValue();
            if (lower == (upper = segUpper.getSegmentValue())) continue;
            isSplit = true;
            int size = upper - lower;
            int mid = lower + (size >>> 1);
            lowerSeg = (AddressSegment)segmentCreator.createSegment(mid);
            upperSeg = (AddressSegment)segmentCreator.createSegment(mid + 1);
            break;
        }
        if (i == networkSegmentIndex && !isSplit) {
            segLower = originalSegmentsLower[i];
            segUpper = originalSegmentsUpper[i];
            int segBitCount = segLower.getBitCount();
            Integer pref = IPAddressSection.getSegmentPrefixLength(segBitCount, prefixLength, i);
            int shiftAdjustment = segBitCount - pref;
            int lower = segLower.getSegmentValue();
            int upper = segUpper.getSegmentValue();
            if ((lower >>>= shiftAdjustment) != (upper >>>= shiftAdjustment)) {
                isSplit = true;
                int size = upper - lower;
                int mid = lower + (size >>> 1);
                int next = mid + 1;
                mid = mid << shiftAdjustment | ~(-1 << shiftAdjustment);
                lowerSeg = segmentCreator.createSegment(mid);
                upperSeg = segmentCreator.createSegment(next <<= shiftAdjustment);
            }
        }
        if (isSplit) {
            int len = originalSegmentsLower.length;
            Object[] lowerUpperSegs = segmentCreator.createSegmentArray(len);
            Object[] upperLowerSegs = segmentCreator.createSegmentArray(len);
            System.arraycopy(originalSegmentsLower, 0, lowerUpperSegs, 0, i);
            System.arraycopy(originalSegmentsLower, 0, upperLowerSegs, 0, i);
            int j = i + 1;
            lowerUpperSegs[i] = lowerSeg;
            upperLowerSegs[i] = upperSeg;
            Arrays.fill(lowerUpperSegs, j, lowerUpperSegs.length, segmentCreator.createSegment(lowerSeg.getMaxSegmentValue()));
            Arrays.fill(upperLowerSegs, j, upperLowerSegs.length, segmentCreator.createSegment(0));
            sink.setSplitValues((IPAddressSeqRange)transformer.apply(originalSegmentsLower, lowerUpperSegs), (IPAddressSeqRange)transformer.apply(upperLowerSegs, originalSegmentsUpper));
        }
        return isSplit;
    }

    @Override
    public abstract Iterator<? extends IPAddress> iterator();

    @Override
    public abstract AddressComponentRangeSpliterator<? extends IPAddressSeqRange, ? extends IPAddress> spliterator();

    @Override
    public abstract Stream<? extends IPAddress> stream();

    protected static <T extends Address, S extends AddressSegment> Iterator<T> iterator(T original, AddressCreator<T, ?, ?, S> creator) {
        return IPAddressSection.iterator(original, creator, null);
    }

    protected static <T extends IPAddress, S extends IPAddressSegment> Iterator<T> iterator(T lower, T upper, AddressCreator<T, ?, ?, S> creator, IPAddressSection.SegFunction<T, S> segProducer, IPAddressSection.SegFunction<S, Iterator<S>> segmentIteratorProducer, SegValueComparator<T> segValueComparator, int networkSegmentIndex, int hostSegmentIndex, IPAddressSection.SegFunction<S, Iterator<S>> prefixedSegIteratorProducer) {
        int divCount = lower.getSegmentCount();
        ArrayList<Supplier<Iterator>> segIteratorProducerList = new ArrayList<Supplier<Iterator>>(divCount);
        final boolean[] finalValue = new boolean[divCount + 1];
        boolean notDiffering = true;
        finalValue[0] = true;
        IPAddressSegment allSegShared = null;
        for (int i = 0; i < divCount; ++i) {
            IPAddressSection.SegFunction<Object, Iterator<Object>> segIteratorProducer = prefixedSegIteratorProducer != null && i >= networkSegmentIndex ? prefixedSegIteratorProducer : segmentIteratorProducer;
            IPAddressSegment lowerSeg = (IPAddressSegment)segProducer.apply(lower, i);
            final int indexi = i;
            if (notDiffering) {
                Iterator iterator;
                notDiffering = segValueComparator.apply(lower, upper, i);
                if (notDiffering) {
                    finalValue[i + 1] = true;
                    iterator = segIteratorProducer.apply(lowerSeg, i);
                    segIteratorProducerList.add(() -> iterator);
                    continue;
                }
                iterator = segIteratorProducer.apply((IPAddressSegment)creator.createSegment(lowerSeg.getSegmentValue(), ((IPAddressSegment)upper.getSegment(i)).getSegmentValue(), null), i);
                Iterator wrappedFinalIterator = new Iterator<S>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public S next() {
                        IPAddressSegment next = (IPAddressSegment)iterator.next();
                        if (!iterator.hasNext()) {
                            finalValue[indexi + 1] = true;
                        }
                        return next;
                    }
                };
                segIteratorProducerList.add(() -> wrappedFinalIterator);
                continue;
            }
            Iterator firstIterator = segIteratorProducer.apply((IPAddressSegment)creator.createSegment(lowerSeg.getSegmentValue(), lower.getMaxSegmentValue(), null), i);
            final Iterator<S> finalIterator = segIteratorProducer.apply((IPAddressSegment)creator.createSegment(0, ((IPAddressSegment)upper.getSegment(i)).getSegmentValue(), null), i);
            Iterator wrappedFinalIterator = new Iterator<S>(){

                @Override
                public boolean hasNext() {
                    return finalIterator.hasNext();
                }

                @Override
                public S next() {
                    IPAddressSegment next = (IPAddressSegment)finalIterator.next();
                    if (!finalIterator.hasNext()) {
                        finalValue[indexi + 1] = true;
                    }
                    return next;
                }
            };
            if (allSegShared == null) {
                allSegShared = (IPAddressSegment)creator.createSegment(0, lower.getMaxSegmentValue(), null);
            }
            IPAddressSegment allSeg = allSegShared;
            Supplier<Iterator> finalIteratorProducer = () -> finalValue[indexi] ? wrappedFinalIterator : (Iterator)segIteratorProducer.apply(allSeg, indexi);
            segIteratorProducerList.add(() -> {
                segIteratorProducerList.set(indexi, finalIteratorProducer);
                return firstIterator;
            });
        }
        IntFunction iteratorProducer = iteratorIndex -> (Iterator)((Supplier)segIteratorProducerList.get(iteratorIndex)).get();
        return IPAddressSection.iterator(null, creator, IPAddressSection.iterator(lower.getSegmentCount(), creator, iteratorProducer, networkSegmentIndex, hostSegmentIndex, iteratorProducer));
    }

    @Override
    public IPAddress getLower() {
        return this.lower;
    }

    @Override
    public IPAddress getUpper() {
        return this.upper;
    }

    public abstract IPAddress get(BigInteger var1);

    public abstract IPAddress get(long var1);

    public String toNormalizedString(String separator) {
        Function<IPAddress, String> stringer = Address::toNormalizedString;
        return this.toString(stringer, separator, stringer);
    }

    @Override
    public String toNormalizedString() {
        return this.toNormalizedString(DEFAULT_RANGE_SEPARATOR);
    }

    public String toCanonicalString(String separator) {
        Function<IPAddress, String> stringer = Address::toCanonicalString;
        return this.toString(stringer, separator, stringer);
    }

    @Override
    public String toCanonicalString() {
        return this.toCanonicalString(DEFAULT_RANGE_SEPARATOR);
    }

    public String toString(Function<? super IPAddress, String> lowerStringer, String separator, Function<? super IPAddress, String> upperStringer) {
        return IPAddressSeqRange.toString(this.getLower(), lowerStringer, separator, this.getUpper(), upperStringer);
    }

    static String toString(IPAddress lower, Function<? super IPAddress, String> lowerStringer, String separator, IPAddress upper, Function<? super IPAddress, String> upperStringer) {
        return lowerStringer.apply(lower) + separator + upperStringer.apply(upper);
    }

    public String toString() {
        return this.toCanonicalString();
    }

    @Override
    public abstract IPAddress coverWithPrefixBlock();

    @Override
    public abstract IPAddress[] spanWithPrefixBlocks();

    @Override
    public abstract IPAddress[] spanWithSequentialBlocks();

    public static IPAddressSeqRange[] join(IPAddressSeqRange ... ranges) {
        return IPAddressSeqRange.joinImpl(ranges, true);
    }

    private static IPAddressSeqRange[] joinImpl(IPAddressSeqRange[] ranges, boolean isFinal) {
        if (ranges.length == 0) {
            return EMPTY_RANGES;
        }
        ranges = (IPAddressSeqRange[])ranges.clone();
        int joinedCount = 0;
        int j = ranges.length - 1;
        for (int i = 0; i <= j; ++i) {
            if (ranges[i] != null) continue;
            ++joinedCount;
            while (ranges[j] == null && j > i) {
                --j;
                ++joinedCount;
            }
            if (j <= i) continue;
            ranges[i] = ranges[j];
            ranges[j] = null;
            --j;
        }
        int len = ranges.length - joinedCount;
        Arrays.sort(ranges, 0, len, Address.ADDRESS_LOW_VALUE_COMPARATOR);
        int i = 0;
        while (i < len) {
            IPAddressSeqRange range2;
            IPAddress nextLower;
            int j2;
            IPAddressSeqRange range = ranges[i];
            IPAddress currentLower = range.getLower();
            IPAddress currentUpper = range.getUpper();
            boolean didJoin = false;
            for (j2 = i + 1; j2 < len && IPAddressSeqRange.versionsMatch(nextLower = (range2 = ranges[j2]).getLower(), currentUpper) && (IPAddressSeqRange.compareLowerValues(currentUpper, nextLower) >= 0 || currentUpper.increment().equals(nextLower)); ++j2) {
                ++joinedCount;
                IPAddress nextUpper = range2.getUpper();
                if (IPAddressSeqRange.compareLowerValues(currentUpper, nextUpper) < 0) {
                    currentUpper = nextUpper;
                }
                ranges[j2] = null;
                didJoin = true;
            }
            if (didJoin) {
                ranges[i] = range.create(currentLower, currentUpper);
            }
            i = j2;
        }
        if (joinedCount == 0) {
            return ranges;
        }
        if (ranges.length == joinedCount) {
            return EMPTY_RANGES;
        }
        if (isFinal) {
            IPAddressSeqRange[] joined = new IPAddressSeqRange[ranges.length - joinedCount];
            if (joined.length > 0) {
                int i2 = 0;
                int j3 = 0;
                while (true) {
                    IPAddressSeqRange range;
                    if ((range = ranges[i2]) != null) {
                        joined[j3++] = range;
                        if (j3 >= joined.length) break;
                    }
                    ++i2;
                }
            }
            ranges = joined;
        }
        return ranges;
    }

    public static IPAddressSeqRangeList[] joinIntoList(IPAddressSeqRange ... ranges) {
        IPAddressSeqRange[] res = IPAddressSeqRange.joinImpl(ranges, false);
        if (res.length == 0) {
            return EMPTY_RANGE_LISTS;
        }
        int twiceSize = res.length << 1;
        int capacity = 10;
        if (twiceSize > capacity) {
            capacity = twiceSize;
        }
        IPAddress previousAddress = null;
        ArrayList<IPAddressSeqRangeList> multipleLists = null;
        IPAddressSeqRangeList previousList = null;
        IPAddressSeqRangeList list = new IPAddressSeqRangeList(capacity);
        for (int i = 0; i < res.length; ++i) {
            IPAddressSeqRange rng = res[i];
            if (rng == null) continue;
            IPAddress next = rng.getLower();
            if (previousAddress != null && !IPAddressSeqRange.versionsMatch(previousAddress, next)) {
                if (previousList != null) {
                    multipleLists = new ArrayList<IPAddressSeqRangeList>();
                    multipleLists.add(previousList);
                    multipleLists.add(list);
                    previousList = null;
                } else if (multipleLists != null) {
                    multipleLists.add(list);
                } else {
                    previousList = list;
                }
                list = new IPAddressSeqRangeList(capacity);
            }
            previousAddress = next;
            list.ranges.add(rng);
        }
        if (multipleLists != null) {
            multipleLists.add(list);
            return multipleLists.toArray(new IPAddressSeqRangeList[multipleLists.size()]);
        }
        if (previousList != null) {
            return new IPAddressSeqRangeList[]{previousList, list};
        }
        return new IPAddressSeqRangeList[]{list};
    }

    boolean isContainedBy(IPAddress other) {
        IPAddress lower = this.getLower();
        IPAddress upper = this.getUpper();
        if (!IPAddressSeqRange.versionsMatch(lower, other)) {
            return false;
        }
        int segCount = lower.getSegmentCount();
        for (int i = 0; i < segCount; ++i) {
            AddressSegment lowerSeg = lower.getSegment(i);
            AddressSegment upperSeg = upper.getSegment(i);
            int lowerSegValue = ((IPAddressSegment)lowerSeg).getSegmentValue();
            int upperSegValue = ((IPAddressSegment)upperSeg).getSegmentValue();
            AddressSegment otherSeg = other.getSegment(i);
            int otherSegLowerValue = ((IPAddressSegment)otherSeg).getSegmentValue();
            int otherSegUpperValue = ((IPAddressSegment)otherSeg).getUpperSegmentValue();
            if (lowerSegValue < otherSegLowerValue || upperSegValue > otherSegUpperValue) {
                return false;
            }
            if (lowerSegValue == upperSegValue) continue;
            for (int j = i + 1; j < segCount; ++j) {
                otherSeg = other.getSegment(j);
                if (otherSeg.isFullRange()) continue;
                return false;
            }
            break;
        }
        return true;
    }

    @Override
    public boolean overlaps(IPAddress other) {
        IPAddress lower = this.getLower();
        IPAddress upper = this.getUpper();
        if (!IPAddressSeqRange.versionsMatch(lower, other)) {
            return false;
        }
        int segCount = lower.getSegmentCount();
        for (int i = 0; i < segCount; ++i) {
            AddressSegment lowerSeg = lower.getSegment(i);
            AddressSegment upperSeg = upper.getSegment(i);
            int lowerSegValue = ((IPAddressSegment)lowerSeg).getSegmentValue();
            int upperSegValue = ((IPAddressSegment)upperSeg).getSegmentValue();
            AddressSegment otherSeg = other.getSegment(i);
            int otherSegLowerValue = ((IPAddressSegment)otherSeg).getSegmentValue();
            int otherSegUpperValue = ((IPAddressSegment)otherSeg).getUpperSegmentValue();
            if (lowerSegValue == upperSegValue) {
                if (lowerSegValue >= otherSegLowerValue && lowerSegValue <= otherSegUpperValue) continue;
                return false;
            }
            if (otherSegLowerValue < upperSegValue && otherSegUpperValue > lowerSegValue) {
                return true;
            }
            if (otherSegLowerValue == upperSegValue) {
                for (int j = i + 1; j < segCount; ++j) {
                    otherSeg = other.getSegment(j);
                    upperSeg = upper.getSegment(j);
                    upperSegValue = ((IPAddressSegment)upperSeg).getSegmentValue();
                    otherSegLowerValue = ((IPAddressSegment)otherSeg).getSegmentValue();
                    if (otherSegLowerValue < upperSegValue) {
                        return true;
                    }
                    if (otherSegLowerValue <= upperSegValue) continue;
                    return false;
                }
                break;
            }
            if (otherSegUpperValue == lowerSegValue) {
                for (int j = i + 1; j < segCount; ++j) {
                    otherSeg = other.getSegment(j);
                    lowerSeg = lower.getSegment(j);
                    lowerSegValue = ((IPAddressSegment)lowerSeg).getSegmentValue();
                    otherSegUpperValue = ((IPAddressSegment)otherSeg).getUpperSegmentValue();
                    if (otherSegUpperValue > lowerSegValue) {
                        return true;
                    }
                    if (otherSegUpperValue >= lowerSegValue) continue;
                    return false;
                }
                break;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean overlaps(IPAddressSeqRange other) {
        IPAddress otherLower = other.getLower();
        IPAddress upper = this.getUpper();
        if (!IPAddressSeqRange.versionsMatch(upper, otherLower)) {
            return false;
        }
        return IPAddressSeqRange.overlapsCheck(this.getLower(), upper, otherLower, other.getUpper());
    }

    private static boolean overlapsCheck(IPAddress lower, IPAddress upper, IPAddress otherLower, IPAddress otherUpper) {
        return IPAddressSeqRange.compareLowerValues(otherLower, upper) <= 0 && IPAddressSeqRange.compareLowerValues(otherUpper, lower) >= 0;
    }

    private boolean containsRange(IPAddressRange other, Supplier<IPAddress> lowerComp, Supplier<IPAddress> upperComp) {
        IPAddress otherLower = lowerComp.get();
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, otherLower)) {
            return false;
        }
        return IPAddressSeqRange.compareLowerValues(otherLower, lower) >= 0 && IPAddressSeqRange.compareUpperValues(upperComp.get(), this.getUpper()) <= 0;
    }

    @Override
    public boolean contains(IPAddress other) {
        Supplier<IPAddress> identity = () -> other;
        return this.containsRange(other, identity, identity);
    }

    @Override
    public boolean contains(IPAddressSeqRange other) {
        return this.containsRange(other, other::getLower, other::getUpper);
    }

    @Override
    public BigInteger enumerate(IPAddress other) {
        IPAddress lower = this.getLower();
        if (other == lower) {
            return BigInteger.ZERO;
        }
        if (other == this.getUpper()) {
            return this.getCount().subtract(BigInteger.ONE);
        }
        return lower.enumerate(other);
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    public int hashCode() {
        int res = this.hashCode;
        if (res == 0) {
            this.hashCode = res = 31 * this.getLower().hashCode() + this.getUpper().hashCode();
        }
        return res;
    }

    public boolean equals(Object o) {
        if (o instanceof IPAddressSeqRange) {
            IPAddressSeqRange otherRange = (IPAddressSeqRange)o;
            return this.getLower().equals(otherRange.getLower()) && this.getUpper().equals(otherRange.getUpper());
        }
        return false;
    }

    public IPAddressSeqRange intersect(IPAddressSeqRange other) {
        IPAddress otherLower;
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, otherLower = other.getLower())) {
            return null;
        }
        IPAddress upper = this.getUpper();
        IPAddress otherUpper = other.getUpper();
        if (IPAddressSeqRange.compareLowerValues(lower, otherLower) <= 0) {
            if (IPAddressSeqRange.compareLowerValues(upper, otherUpper) >= 0) {
                return other;
            }
            if (IPAddressSeqRange.compareLowerValues(upper, otherLower) < 0) {
                return null;
            }
            return this.create(otherLower, upper);
        }
        if (IPAddressSeqRange.compareLowerValues(otherUpper, upper) >= 0) {
            return this;
        }
        if (IPAddressSeqRange.compareLowerValues(otherUpper, lower) < 0) {
            return null;
        }
        return this.create(lower, otherUpper);
    }

    public IPAddressSeqRange join(IPAddressSeqRange other) {
        IPAddress otherUpper;
        IPAddress upper;
        IPAddress otherLower;
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, otherLower = other.getLower())) {
            return null;
        }
        int lowerComp = IPAddressSeqRange.compareLowerValues(lower, otherLower);
        IPAddressSeqRange singleJoin = this.joinOverlapping(lowerComp, lower, upper = this.getUpper(), otherLower, otherUpper = other.getUpper());
        if (singleJoin != null) {
            return singleJoin;
        }
        if (lowerComp > 0) {
            if (IPAddressSeqRange.compareLowerValues(otherUpper.increment(), lower) == 0) {
                return this.create(otherLower, upper);
            }
        } else if (IPAddressSeqRange.compareLowerValues(upper.increment(), otherLower) == 0) {
            return this.create(lower, otherUpper);
        }
        return null;
    }

    private IPAddressSeqRange joinOverlapping(int lowerComp, IPAddress lower, IPAddress upper, IPAddress otherLower, IPAddress otherUpper) {
        if (IPAddressSeqRange.overlapsCheck(lower, upper, otherLower, otherUpper)) {
            IPAddress lowestLower;
            int upperComp = IPAddressSeqRange.compareLowerValues(upper, otherUpper);
            if (lowerComp >= 0) {
                if (lowerComp == 0 && upperComp == 0) {
                    return this;
                }
                lowestLower = otherLower;
            } else {
                lowestLower = lower;
            }
            IPAddress highestUpper = upperComp >= 0 ? upper : otherUpper;
            return this.create(lowestLower, highestUpper);
        }
        return null;
    }

    public IPAddressSeqRangeList joinIntoList(IPAddressSeqRange other) {
        IPAddress otherUpper;
        IPAddress upper;
        IPAddress otherLower;
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, otherLower = other.getLower())) {
            throw new IllegalArgumentException(IPAddressSeqRange.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        int lowerComp = IPAddressSeqRange.compareLowerValues(lower, otherLower);
        IPAddressSeqRange singleJoin = this.joinOverlapping(lowerComp, lower, upper = this.getUpper(), otherLower, otherUpper = other.getUpper());
        if (singleJoin == null) {
            if (lowerComp > 0) {
                if (IPAddressSeqRange.compareLowerValues(otherUpper.increment(), lower) == 0) {
                    return this.create(otherLower, upper).intoSequentialRangeList();
                }
                return this.createDoubleList(other, this);
            }
            if (IPAddressSeqRange.compareLowerValues(upper.increment(), otherLower) == 0) {
                return this.create(lower, otherUpper).intoSequentialRangeList();
            }
            return this.createDoubleList(this, other);
        }
        return singleJoin.intoSequentialRangeList();
    }

    public IPAddressSeqRange extend(IPAddress other) {
        return this.extend(other, other, other);
    }

    public IPAddressSeqRange extend(IPAddressSeqRange other) {
        return this.extend(other, other.getLower(), other.getUpper());
    }

    private IPAddressSeqRange extend(IPAddressRange other, IPAddress lowerComp, IPAddress upperComp) {
        IPAddress otherLowerComp;
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, otherLowerComp = lowerComp)) {
            return null;
        }
        IPAddress upper = this.getUpper();
        int lowerComparison = IPAddressSeqRange.compareLowerValues(lower, otherLowerComp);
        int upperComparison = IPAddressSeqRange.compareUpperValues(upper, upperComp);
        if (lowerComparison > 0) {
            if (upperComparison <= 0) {
                return other.coverWithSequentialRange();
            }
            return this.create((IPAddress)other.getLower(), upper);
        }
        if (upperComparison >= 0) {
            return this;
        }
        return this.create(lower, (IPAddress)other.getUpper());
    }

    public IPAddressSeqRange extend(IPAddressRange other) {
        return this.extend(other, (IPAddress)other.getLower(), (IPAddress)other.getUpper());
    }

    public IPAddressSeqRange[] subtract(IPAddressSeqRange other) {
        return this.subtract(other, this::createEmptyArray, this::createSingleThis, this::createSingleArray, this::createDoubleArray);
    }

    public IPAddressSeqRangeList subtractIntoList(IPAddressSeqRange other) {
        return this.subtract(other, this::createList, this::intoSequentialRangeList, this::createSingleList, this::createDoubleList);
    }

    private <T> T subtract(IPAddressSeqRange other, Supplier<T> createEmpty, Supplier<T> createThis, Function<IPAddressSeqRange, T> createSingle, BiFunction<IPAddressSeqRange, IPAddressSeqRange, T> createDouble) {
        IPAddress lower = this.getLower();
        IPAddress upper = this.getUpper();
        IPAddress otherLower = other.getLower();
        IPAddress otherUpper = other.getUpper();
        if (!IPAddressSeqRange.versionsMatch(lower, otherLower)) {
            return createThis.get();
        }
        if (IPAddressSeqRange.compareLowerValues(lower, otherLower) < 0) {
            if (IPAddressSeqRange.compareLowerValues(upper, otherUpper) > 0) {
                IPAddressSeqRange first = this.create(lower, otherLower.decrement());
                IPAddressSeqRange second = this.create(otherUpper.increment(), upper);
                return createDouble.apply(first, second);
            }
            int comp = IPAddressSeqRange.compareLowerValues(upper, otherLower);
            if (comp < 0) {
                return createThis.get();
            }
            IPAddressSeqRange rng = this.create(lower, otherLower.decrement());
            return createSingle.apply(rng);
        }
        if (IPAddressSeqRange.compareLowerValues(otherUpper, upper) >= 0) {
            return createEmpty.get();
        }
        int comp = IPAddressSeqRange.compareLowerValues(otherUpper, lower);
        if (comp < 0) {
            return createThis.get();
        }
        IPAddressSeqRange rng = this.create(otherUpper.increment(), upper);
        return createSingle.apply(rng);
    }

    public IPAddressSeqRange[] complement() {
        return this.complement(this::createEmptyArray, this::createSingleArray, this::createDoubleArray);
    }

    public IPAddressSeqRangeList complementIntoList() {
        return this.complement(this::createList, this::createSingleList, this::createDoubleList);
    }

    private <T> T complement(Supplier<T> createEmpty, Function<IPAddressSeqRange, T> createSingle, BiFunction<IPAddressSeqRange, IPAddressSeqRange, T> createDouble) {
        IPAddress lower = this.getLower();
        IPAddress upper = this.getUpper();
        if (lower.includesZero()) {
            if (upper.includesMax()) {
                return createEmpty.get();
            }
            Object max = ((IPAddressNetwork)lower.getNetwork()).getNetworkMask(this.getBitCount(), false);
            IPAddressSeqRange rng = this.create(upper.increment(), (IPAddress)max);
            return createSingle.apply(rng);
        }
        Object zero = ((IPAddressNetwork)lower.getNetwork()).getNetworkMask(0, false);
        if (this.getUpper().includesMax()) {
            IPAddressSeqRange rng = this.create((IPAddress)zero, lower.decrement());
            return createSingle.apply(rng);
        }
        Object max = ((IPAddressNetwork)lower.getNetwork()).getNetworkMask(this.getBitCount(), false);
        IPAddressSeqRange first = this.create((IPAddress)zero, lower.decrement());
        IPAddressSeqRange second = this.create(upper.increment(), (IPAddress)max);
        return createDouble.apply(first, second);
    }

    public IPAddressSeqRange[] split(IPAddress other) {
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, other)) {
            return this.createArray(2);
        }
        if (IPAddressSeqRange.compareLowerValues(lower, other) < 0) {
            IPAddress upper = this.getUpper();
            if (IPAddressSeqRange.compareLowerValues(upper, other) >= 0) {
                IPAddress otherLower = other.withoutPrefixLength().getLower();
                IPAddressSeqRange first = this.create(lower, otherLower.decrement());
                IPAddressSeqRange second = this.create(otherLower, upper);
                return this.createDoubleArray(first, second);
            }
            return this.createDouble(false);
        }
        return this.createDouble(true);
    }

    public IPAddressSeqRange lowerFromSplit(IPAddress other) {
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, other)) {
            return null;
        }
        if (IPAddressSeqRange.compareLowerValues(lower, other) < 0) {
            if (IPAddressSeqRange.compareLowerValues(this.getUpper(), other) >= 0) {
                return this.lowerSplit(other);
            }
            return this;
        }
        return null;
    }

    IPAddressSeqRange lowerSplit(IPAddress other) {
        return this.create(this.getLower(), other.withoutPrefixLength().decrement());
    }

    public IPAddressSeqRange upperFromSplit(IPAddress other) {
        IPAddress lower = this.getLower();
        if (!IPAddressSeqRange.versionsMatch(lower, other)) {
            return null;
        }
        if (IPAddressSeqRange.compareLowerValues(lower, other) < 0) {
            if (IPAddressSeqRange.compareLowerValues(this.getUpper(), other) >= 0) {
                return this.upperSplit(other);
            }
            return null;
        }
        return this;
    }

    IPAddressSeqRange upperSplit(IPAddress other) {
        return this.create(other.withoutPrefixLength().getLower(), this.getUpper());
    }

    @Override
    public IPAddressSeqRangeList intoSequentialRangeList() {
        return this.createSingleList(this);
    }

    private IPAddressSeqRange[] createSingleThis() {
        IPAddressSeqRange[] arr = this.createArray(1);
        arr[0] = this;
        return arr;
    }

    private IPAddressSeqRange[] createEmptyArray() {
        return this.createArray(0);
    }

    private IPAddressSeqRange[] createSingleArray(IPAddressSeqRange rng) {
        IPAddressSeqRange[] arr = this.createArray(1);
        arr[0] = rng;
        return arr;
    }

    private IPAddressSeqRange[] createDoubleArray(IPAddressSeqRange rng1, IPAddressSeqRange rng2) {
        IPAddressSeqRange[] arr = this.createArray(2);
        arr[0] = rng1;
        arr[1] = rng2;
        return arr;
    }

    private IPAddressSeqRange[] createDouble(boolean asUpper) {
        IPAddressSeqRange[] arr = this.createArray(2);
        arr[asUpper ? 1 : 0] = this;
        return arr;
    }

    protected abstract IPAddressSeqRange create(IPAddress var1, IPAddress var2);

    protected abstract IPAddressSeqRange[] createArray(int var1);

    protected abstract IPAddressSeqRangeList createList();

    private IPAddressSeqRangeList createSingleList(IPAddressSeqRange rng) {
        IPAddressSeqRangeList list = this.createList();
        list.ranges.add(rng);
        return list;
    }

    private IPAddressSeqRangeList createDoubleList(IPAddressSeqRange rng1, IPAddressSeqRange rng2) {
        IPAddressSeqRangeList list = this.createList();
        list.ranges.add(rng1);
        list.ranges.add(rng2);
        return list;
    }

    @Override
    public boolean containsPrefixBlock(int prefixLen) {
        IPAddressSection.checkSubnet(this.lower, prefixLen);
        int divCount = this.lower.getDivisionCount();
        int bitsPerSegment = this.lower.getBitsPerSegment();
        int i = IPAddressSeqRange.getHostSegmentIndex(prefixLen, this.lower.getBytesPerSegment(), bitsPerSegment);
        if (i < divCount) {
            AddressSegment div = this.lower.getSegment(i);
            AddressSegment upperDiv = this.upper.getSegment(i);
            int segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, prefixLen, i);
            if (!((IPAddressSegment)div).containsPrefixBlock(((IPAddressSegment)div).getSegmentValue(), ((IPAddressSegment)upperDiv).getSegmentValue(), segmentPrefixLength)) {
                return false;
            }
            ++i;
            while (i < divCount) {
                div = this.lower.getSegment(i);
                upperDiv = this.upper.getSegment(i);
                if (!((IPAddressSegment)div).includesZero() || !((IPAddressSegment)upperDiv).includesMax()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean containsSinglePrefixBlock(int prefixLen) {
        IPAddressSection.checkSubnet(this.lower, prefixLen);
        int prevBitCount = 0;
        int divCount = this.lower.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            AddressSegment div = this.lower.getSegment(i);
            AddressSegment upperDiv = this.upper.getSegment(i);
            int bitCount = div.getBitCount();
            int totalBitCount = bitCount + prevBitCount;
            if (prefixLen >= totalBitCount) {
                if (!((IPAddressSegment)div).isSameValues(upperDiv)) {
                    return false;
                }
            } else {
                int divPrefixLen = Math.max(0, prefixLen - prevBitCount);
                if (!((IPAddressSegment)div).containsSinglePrefixBlock(((IPAddressSegment)div).getSegmentValue(), ((IPAddressSegment)upperDiv).getSegmentValue(), divPrefixLen)) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.lower.getSegment(i);
                    upperDiv = this.upper.getSegment(i);
                    if (!((IPAddressSegment)div).includesZero() || !((IPAddressSegment)upperDiv).includesMax()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    @Override
    public int getBitCount() {
        return this.getLower().getBitCount();
    }

    @Override
    public byte[] getBytes() {
        return this.getLower().getBytes();
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        return this.getLower().getBytes(bytes);
    }

    @Override
    public byte[] getBytes(byte[] bytes, int index) {
        return this.getLower().getBytes(bytes, index);
    }

    @Override
    public byte[] getUpperBytes() {
        return this.getUpper().getUpperBytes();
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        return this.getUpper().getUpperBytes(bytes);
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes, int index) {
        return this.getUpper().getUpperBytes(bytes, index);
    }

    @Override
    public BigInteger getValue() {
        return this.getLower().getValue();
    }

    @Override
    public BigInteger getUpperValue() {
        return this.getUpper().getValue();
    }

    @Override
    public boolean isZero() {
        return this.includesZero() && !this.isMultiple();
    }

    @Override
    public boolean includesZero() {
        return this.getLower().isZero();
    }

    @Override
    public boolean isMax() {
        return this.includesMax() && !this.isMultiple();
    }

    @Override
    public boolean includesMax() {
        return this.getUpper().isMax();
    }

    @FunctionalInterface
    protected static interface SegValueComparator<T> {
        public boolean apply(T var1, T var2, int var3);
    }

    @FunctionalInterface
    protected static interface IPAddressSeqRangeIteratorProvider<S, T>
    extends IPAddressSection.SeqRangeIteratorProvider<S, T> {
    }

    protected static interface IPAddressSeqRangeSplitterSink<S, T> {
        public void setSplitValues(S var1, S var2);

        public S getAddressItem();
    }
}

