/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.alert;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.service.AlertService;
import com.ghostchu.peerbanhelper.databasent.table.AlertEntity;
import com.ghostchu.peerbanhelper.event.program.PBHServerStartedEvent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.push.PushManagerImpl;
import com.google.common.eventbus.Subscribe;
import io.sentry.Sentry;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.stereotype.Component;

@Component
public final class AlertManagerImpl
implements AlertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertManagerImpl.class);
    private final AlertService alertDao;
    private final PushManagerImpl pushManager;
    private final DatabaseDriver databaseDriver;

    public AlertManagerImpl(AlertService alertDao, PushManagerImpl pushManager, DatabaseDriver databaseDriver) {
        this.alertDao = alertDao;
        this.pushManager = pushManager;
        this.databaseDriver = databaseDriver;
        Main.getEventBus().register((Object)this);
    }

    @Subscribe
    public void init(PBHServerStartedEvent event) {
        CommonUtil.getBgCleanupScheduler().scheduleWithFixedDelay(this::cleanup, 0L, 1L, TimeUnit.DAYS);
    }

    private void cleanup() {
        int removed = this.alertDao.deleteOldAlerts(OffsetDateTime.now().minusDays(30L));
        log.info(TextManager.tlUI(Lang.ALERT_MANAGER_CLEAN_UP, removed));
    }

    @Override
    public void markAlertAsRead(@NotNull String identifier) {
        try {
            if (!this.alertDao.identifierAlertExists(identifier)) {
                return;
            }
            this.alertDao.markAsRead(identifier);
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.UNABLE_READ_ALERT, new Object[0]), (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
    }

    @Override
    public boolean identifierAlertExists(@NotNull String identifier) {
        return this.alertDao.identifierAlertExists(identifier);
    }

    @Override
    public boolean identifierAlertExistsIncludeRead(@NotNull String identifier) {
        return this.alertDao.identifierAlertExistsIncludeRead(identifier);
    }

    @Override
    public void publishAlert(boolean push, @NotNull AlertLevel level, @NotNull String identifier, @NotNull TranslationComponent title, @NotNull TranslationComponent content) {
        try {
            if (this.alertDao.identifierAlertExists(identifier)) {
                return;
            }
            AlertEntity alertEntity = new AlertEntity();
            alertEntity.setLevel(level);
            alertEntity.setIdentifier(Objects.requireNonNullElseGet(identifier, () -> UUID.randomUUID().toString() + System.currentTimeMillis()));
            alertEntity.setTitle(title);
            alertEntity.setContent(content);
            alertEntity.setCreateAt(OffsetDateTime.now());
            this.alertDao.saveOrUpdate(alertEntity);
            if (push && !this.pushManager.pushMessage("[PeerBanHelper/" + level.name() + "] " + TextManager.tlUI(title), TextManager.tlUI(content))) {
                log.error(TextManager.tlUI(Lang.UNABLE_TO_PUSH_ALERT_VIA_PROVIDERS, new Object[0]));
            }
            Level slf4jLevel = switch (level) {
                case AlertLevel.ERROR, AlertLevel.FATAL -> Level.ERROR;
                case AlertLevel.WARN -> Level.WARN;
                default -> Level.INFO;
            };
            Main.getGuiManager().createNotification(slf4jLevel, TextManager.tlUI(title), TextManager.tlUI(content));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.UNABLE_TO_PUSH_ALERT, new Object[0]), (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
    }

    @Override
    @Nullable
    public AlertLevel getHighestUnreadAlertLevel() {
        AlertLevel alertLevel = null;
        List<AlertEntity> unreadAlerts = this.alertDao.getUnreadAlerts();
        for (AlertEntity unreadAlert : unreadAlerts) {
            if (alertLevel == null) {
                alertLevel = unreadAlert.getLevel();
                continue;
            }
            if (unreadAlert.getLevel().ordinal() <= alertLevel.ordinal()) continue;
            alertLevel = unreadAlert.getLevel();
        }
        return alertLevel;
    }

    @Override
    @NotNull
    public List<AlertEntity> getUnreadAlerts() {
        return this.alertDao.getUnreadAlerts();
    }
}

