/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.databasent.service.MetadataService;
import com.ghostchu.peerbanhelper.event.btn.BtnRuleUpdateEvent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.backgroundtask.FunctionalBackgroundTask;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import com.google.gson.JsonObject;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityIPDenyList
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityIPDenyList.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final IPMatcher ipMatcher = new IPMatcher("btn-ip-denylist", "Empty IP Denylist", List.of(new DualIPv4v6AssociativeTries()));
    private final MetadataService metadataDao;
    private final boolean powCaptcha;
    private String ruleVersion = "initial";

    public BtnAbilityIPDenyList(BtnNetwork btnNetwork, MetadataService metadataDao, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.metadataDao = metadataDao;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
    }

    private void loadCacheFile() {
        String cacheVersion = this.metadataDao.get("btn.ability.ip_denylist.cache.version");
        String cacheValue = this.metadataDao.get("btn.ability.ip_denylist.cache.value");
        if (cacheValue != null) {
            DualIPv4v6AssociativeTries associativeTries = new DualIPv4v6AssociativeTries();
            int loaded = this.stringToIPList(cacheValue, (DualIPv4v6AssociativeTries<String>)associativeTries);
            this.ipMatcher.setData("BTN DenyList (Local Cache)", List.of(associativeTries));
            this.ruleVersion = cacheVersion;
            log.debug("[BTN DenyList] Loaded {} IP rules from cache file. Cached version: {}", (Object)loaded, (Object)cacheVersion);
        }
    }

    @Override
    public String getName() {
        return "BtnAbilityIPDenyList";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_IP_DENYLIST_TITLE);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_IP_DENYLIST_DESCRIPTION, this.ruleVersion, this.ipMatcher.size());
    }

    @Override
    public void load() {
        try {
            this.loadCacheFile();
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_DENYLIST_LOADED_FROM_CACHE, this.ruleVersion, this.ipMatcher.size()));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.BTN_ABILITY_IP_DENYLIST_LOAD_FAILED_FROM_CACHE, new Object[0]), (Throwable)e);
            this.setLastStatus(false, new TranslationComponent(e.getClass().getName() + ": " + e.getMessage()));
        }
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::updateRule, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void updateRule() {
        this.btnNetwork.getBackgroundTaskManager().addTaskAsync(new FunctionalBackgroundTask(new TranslationComponent(Lang.BTN_ABILITY_DENY_LIST_SYNC_SERVER), (task, callback) -> {
            String version = Objects.requireNonNullElse(this.ruleVersion, "initial");
            String url = URLUtil.appendUrl(this.endpoint, Map.of("rev", version));
            Request.Builder request = new Request.Builder().url(url).get();
            if (this.powCaptcha) {
                this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "ip_denylist");
            }
            try (Response response = this.btnNetwork.getHttpClient().newCall(request.build()).execute();){
                if (response.code() == 204) {
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_DENYLIST_LOADED_FROM_REMOTE_NO_CHANGES, version, this.ipMatcher.size()));
                    return;
                }
                String responseBody = response.body().string();
                if (!response.isSuccessful()) {
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + responseBody));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                } else {
                    DualIPv4v6AssociativeTries associativeTries = new DualIPv4v6AssociativeTries();
                    int loaded = this.stringToIPList(responseBody, (DualIPv4v6AssociativeTries<String>)associativeTries);
                    this.ipMatcher.setData("BTN DenyList (Remote)", List.of(associativeTries));
                    Main.getEventBus().post((Object)new BtnRuleUpdateEvent());
                    this.ruleVersion = response.header("X-BTN-ContentVersion", "unknown");
                    this.metadataDao.set("btn.ability.ip_denylist.cache.version", this.ruleVersion);
                    this.metadataDao.set("btn.ability.ip_denylist.cache.value", responseBody);
                    log.info(TextManager.tlUI(Lang.BTN_ABILITY_IP_DENYLIST_LOADED_FROM_REMOTE, this.ruleVersion, loaded));
                    this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_DENYLIST_LOADED_FROM_REMOTE, this.ruleVersion, loaded));
                    this.btnNetwork.getModuleMatchCache().invalidateAll();
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, new Object[0]), (Throwable)e);
                this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
            }
        })).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stringToIPList(String data, DualIPv4v6AssociativeTries<String> ips) {
        AtomicInteger count = new AtomicInteger();
        StringJoiner sj = new StringJoiner("\n");
        for (String ele : data.split("\n")) {
            if (ele.isBlank()) continue;
            if (ele.startsWith("#")) {
                sj.add(ele.substring(1));
                continue;
            }
            try {
                Map.Entry<IPAddress, String> parsedIp = this.parseRuleLine(ele, sj.toString());
                if (parsedIp == null) continue;
                count.getAndIncrement();
                ips.put(parsedIp.getKey(), (Object)parsedIp.getValue());
            }
            catch (Exception e) {
                log.error("Unable parse rule: {}", (Object)ele, (Object)e);
            }
            finally {
                sj = new StringJoiner("\n");
            }
        }
        return count.get();
    }

    private Map.Entry<IPAddress, @Nullable String> parseRuleLine(String ele, String preReadComment) {
        if (ele.contains(",")) {
            String comment;
            String[] spilted = ele.split(",");
            if (spilted.length < 3) {
                return null;
            }
            IPAddress start = IPAddressUtil.getIPAddress(spilted[0]);
            IPAddress end = IPAddressUtil.getIPAddress(spilted[1]);
            int level = Integer.parseInt(spilted[2]);
            String string = comment = spilted.length > 3 ? spilted[3] : preReadComment;
            if (level >= 128) {
                return null;
            }
            if (start == null || end == null) {
                return null;
            }
            return Map.entry(start.spanWithRange(end).coverWithPrefixBlock(), comment);
        }
        if (ele.contains("#")) {
            String ip = ele.substring(0, ele.indexOf("#"));
            String comment = null;
            if (ele.contains("#")) {
                comment = ele.substring(ele.indexOf("#") + 1);
            }
            return Map.entry(IPAddressUtil.getIPAddress(ip), Optional.ofNullable(comment).orElse(preReadComment));
        }
        return Map.entry(IPAddressUtil.getIPAddress(ele), preReadComment);
    }

    @Override
    public void unload() {
    }

    @Generated
    public IPMatcher getIpMatcher() {
        return this.ipMatcher;
    }
}

