/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.sqlite;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class OffsetDateTimeTypeHandlerForSQLite
extends BaseTypeHandler<OffsetDateTime> {
    public void setNonNullParameter(PreparedStatement ps, int i, OffsetDateTime parameter, JdbcType jdbcType) throws SQLException {
        long epochMilli = parameter.toInstant().toEpochMilli();
        ps.setLong(i, epochMilli);
    }

    public OffsetDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        long epochMilli = rs.getLong(columnName);
        return this.parseOffsetDateTime(epochMilli, rs.wasNull());
    }

    public OffsetDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        long epochMilli = rs.getLong(columnIndex);
        return this.parseOffsetDateTime(epochMilli, rs.wasNull());
    }

    public OffsetDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        long epochMilli = cs.getLong(columnIndex);
        return this.parseOffsetDateTime(epochMilli, cs.wasNull());
    }

    private OffsetDateTime parseOffsetDateTime(long epochMilli, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneId.systemDefault());
    }
}

