/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceRouter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceRouter.class);

    public static void executeWithRead(Runnable runnable) {
        DataSourceType effectiveType = DataSourceContext.getEffectiveType(DataSourceType.READ);
        if (log.isDebugEnabled() && effectiveType != DataSourceType.READ) {
            log.debug("Requested READ but using {} due to nesting rules", (Object)effectiveType);
        }
        ScopedValue.where(DataSourceContext.getScopedValue(), effectiveType).run(runnable);
    }

    public static <T> T executeWithRead(Callable<T> callable) throws Exception {
        DataSourceType effectiveType = DataSourceContext.getEffectiveType(DataSourceType.READ);
        if (log.isDebugEnabled() && effectiveType != DataSourceType.READ) {
            log.debug("Requested READ but using {} due to nesting rules", (Object)effectiveType);
        }
        return (T)ScopedValue.where(DataSourceContext.getScopedValue(), effectiveType).call(() -> callable.call());
    }

    public static void executeWithWrite(Runnable runnable) {
        ScopedValue.where(DataSourceContext.getScopedValue(), DataSourceType.WRITE).run(runnable);
    }

    public static <T> T executeWithWrite(Callable<T> callable) throws Exception {
        return (T)ScopedValue.where(DataSourceContext.getScopedValue(), DataSourceType.WRITE).call(() -> callable.call());
    }

    public static DataSourceType getCurrentDataSourceType() {
        return DataSourceContext.getDataSourceType();
    }

    public static boolean isReadContext() {
        return DataSourceContext.getDataSourceType() == DataSourceType.READ;
    }

    public static boolean isWriteContext() {
        return DataSourceContext.getDataSourceType() == DataSourceType.WRITE;
    }
}

