/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ReadOnlyTransactionTemplate
extends TransactionTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyTransactionTemplate.class);

    public ReadOnlyTransactionTemplate(@NotNull PlatformTransactionManager transactionManager) {
        super(transactionManager);
        this.setReadOnly(true);
        this.setPropagationBehavior(0);
    }

    public <T> T execute(@NotNull TransactionCallback<T> action) {
        DataSourceType effectiveType = DataSourceContext.getEffectiveType(DataSourceType.READ);
        if (log.isDebugEnabled() && effectiveType != DataSourceType.READ) {
            log.debug("ReadOnlyTransactionTemplate requested READ but using {} due to nesting rules", (Object)effectiveType);
        }
        if (DataSourceContext.isBound() && DataSourceContext.getDataSourceType() == effectiveType) {
            return (T)super.execute(action);
        }
        try {
            return (T)ScopedValue.where(DataSourceContext.getScopedValue(), effectiveType).call(() -> ReadOnlyTransactionTemplate.super.execute(action));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Transaction execution failed", e);
        }
    }
}

