/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.DatabaseDriver;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import java.util.HashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource
extends AbstractRoutingDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoutingDataSource.class);
    private final DatabaseDriver databaseDriver;

    public RoutingDataSource(@NotNull DatabaseDriver databaseDriver) {
        this.databaseDriver = databaseDriver;
        HashMap<DataSourceType, DataSource> targetDataSources = new HashMap<DataSourceType, DataSource>();
        targetDataSources.put(DataSourceType.READ, databaseDriver.getReadDataSource());
        targetDataSources.put(DataSourceType.WRITE, databaseDriver.getWriteDataSource());
        this.setTargetDataSources(targetDataSources);
        this.setDefaultTargetDataSource(databaseDriver.getReadDataSource());
        this.afterPropertiesSet();
        log.info("RoutingDataSource initialized with READ (default) and WRITE datasources");
    }

    protected Object determineCurrentLookupKey() {
        DataSourceType type = DataSourceContext.getDataSourceType();
        if (log.isTraceEnabled()) {
            log.trace("Routing to {} datasource", (Object)type);
        }
        return type;
    }

    public DataSource getCurrentDataSource() {
        return this.determineTargetDataSource();
    }

    public DataSource getReadDataSource() {
        return this.databaseDriver.getReadDataSource();
    }

    public DataSource getWriteDataSource() {
        return this.databaseDriver.getWriteDataSource();
    }
}

